/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.mars_sim.msp.core.person.medical.HealthProblem;
import org.mars_sim.msp.core.structure.building.function.MedicalCare;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class MedicalCareBuildingPanel
extends BuildingFunctionPanel {
    private MedicalCare medical;
    private JLabel physicianLabel;
    private MedicalTableModel medicalTableModel;
    private int physicianCache;

    public MedicalCareBuildingPanel(MedicalCare medical, MainDesktopPane desktop) {
        super(medical.getBuilding(), desktop);
        this.medical = medical;
        this.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(3, 1, 0, 0));
        this.add((Component)labelPanel, "North");
        JLabel medicalCareLabel = new JLabel("Medical Care", 0);
        labelPanel.add(medicalCareLabel);
        JLabel sickBedLabel = new JLabel("Sick Beds: " + medical.getSickBedNum(), 0);
        labelPanel.add(sickBedLabel);
        this.physicianCache = medical.getPhysicianNum();
        this.physicianLabel = new JLabel("Physicians: " + this.physicianCache, 0);
        labelPanel.add(this.physicianLabel);
        JScrollPane medicalScrollPanel = new JScrollPane();
        medicalScrollPanel.setPreferredSize(new Dimension(160, 80));
        this.add((Component)medicalScrollPanel, "Center");
        this.medicalTableModel = new MedicalTableModel(medical);
        JTable medicalTable = new JTable(this.medicalTableModel);
        medicalTable.setCellSelectionEnabled(false);
        medicalScrollPanel.setViewportView(medicalTable);
    }

    @Override
    public void update() {
        if (this.physicianCache != this.medical.getPhysicianNum()) {
            this.physicianCache = this.medical.getPhysicianNum();
            this.physicianLabel.setText("Physicians: " + this.physicianCache);
        }
        this.medicalTableModel.update();
    }

    private static class MedicalTableModel
    extends AbstractTableModel {
        MedicalCare medical;
        List healthProblems;

        private MedicalTableModel(MedicalCare medical) {
            this.medical = medical;
            this.healthProblems = medical.getProblemsBeingTreated();
        }

        @Override
        public int getRowCount() {
            return this.healthProblems.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<Object> dataType = super.getColumnClass(columnIndex);
            if (columnIndex == 0) {
                dataType = String.class;
            } else if (columnIndex == 1) {
                dataType = String.class;
            }
            return dataType;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Patient";
            }
            if (columnIndex == 1) {
                return "Condition";
            }
            return "unknown";
        }

        @Override
        public Object getValueAt(int row, int column) {
            HealthProblem problem = (HealthProblem)this.healthProblems.get(row);
            if (column == 0) {
                return problem.getSufferer().getName();
            }
            if (column == 1) {
                return problem.toString();
            }
            return "unknown";
        }

        public void update() {
            if (!this.healthProblems.equals(this.medical.getProblemsBeingTreated())) {
                this.healthProblems = this.medical.getProblemsBeingTreated();
            }
            this.fireTableDataChanged();
        }
    }
}

