/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.GridLayout;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import org.mars_sim.msp.core.structure.building.Building;
import org.mars_sim.msp.core.structure.building.function.PowerGeneration;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class PowerBuildingPanel
extends BuildingFunctionPanel {
    private boolean isProducer;
    private JLabel powerStatusLabel;
    private JLabel productionLabel;
    private JLabel usedLabel;
    private DecimalFormat formatter = new DecimalFormat("0.0");
    private String powerStatusCache;
    private double productionCache;
    private double usedCache;

    public PowerBuildingPanel(Building building, MainDesktopPane desktop) {
        super(building, desktop);
        this.isProducer = building.hasFunction("Power Generation");
        if (this.isProducer) {
            this.setLayout(new GridLayout(3, 1, 0, 0));
        } else {
            this.setLayout(new GridLayout(2, 1, 0, 0));
        }
        this.powerStatusCache = building.getPowerMode();
        this.powerStatusLabel = new JLabel("Power Status: " + this.powerStatusCache, 0);
        this.add(this.powerStatusLabel);
        if (this.isProducer) {
            PowerGeneration generator = (PowerGeneration)building.getFunction("Power Generation");
            this.productionCache = generator.getGeneratedPower();
            this.productionLabel = new JLabel("Power Produced: " + this.formatter.format(this.productionCache) + " kW.", 0);
            this.add(this.productionLabel);
        }
        this.usedCache = this.powerStatusCache.equals("Full Power") ? building.getFullPowerRequired() : (this.powerStatusCache.equals("Power Down") ? building.getPoweredDownPowerRequired() : 0.0);
        this.usedLabel = new JLabel("Power Used: " + this.formatter.format(this.usedCache) + " kW.", 0);
        this.add(this.usedLabel);
    }

    @Override
    public void update() {
        PowerGeneration generator;
        if (!this.powerStatusCache.equals(this.building.getPowerMode())) {
            this.powerStatusCache = this.building.getPowerMode();
            this.powerStatusLabel.setText("Power Status: " + this.powerStatusCache);
        }
        if (this.isProducer && this.productionCache != (generator = (PowerGeneration)this.building.getFunction("Power Generation")).getGeneratedPower()) {
            this.productionCache = generator.getGeneratedPower();
            this.productionLabel.setText("Power Produced: " + this.formatter.format(this.productionCache) + " kW.");
        }
        double usedPower = 0.0;
        if (this.powerStatusCache.equals("Full Power")) {
            usedPower = this.building.getFullPowerRequired();
        } else if (this.powerStatusCache.equals("Power Down")) {
            usedPower = this.building.getPoweredDownPowerRequired();
        }
        if (this.usedCache != usedPower) {
            this.usedCache = usedPower;
            this.usedLabel.setText("Power Used: " + this.formatter.format(this.usedCache) + " kW.");
        }
    }
}

