/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.structure.building;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mars_sim.msp.core.structure.building.function.Research;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.structure.building.BuildingFunctionPanel;

public class ResearchBuildingPanel
extends BuildingFunctionPanel {
    private Research lab;
    private JLabel researchersLabel;
    private int researchersCache;

    public ResearchBuildingPanel(Research lab, MainDesktopPane desktop) {
        super(lab.getBuilding(), desktop);
        this.lab = lab;
        this.setLayout(new BorderLayout());
        JPanel labelPanel = new JPanel(new GridLayout(4, 1, 0, 0));
        this.add((Component)labelPanel, "North");
        JLabel researchLabel = new JLabel("Research", 0);
        labelPanel.add(researchLabel);
        this.researchersCache = lab.getResearcherNum();
        this.researchersLabel = new JLabel("Number of Researchers: " + this.researchersCache, 0);
        labelPanel.add(this.researchersLabel);
        JLabel researcherCapacityLabel = new JLabel("Researcher Capacity: " + lab.getLaboratorySize(), 0);
        labelPanel.add(researcherCapacityLabel);
        JLabel specialitiesLabel = new JLabel("Specialities: ", 0);
        labelPanel.add(specialitiesLabel);
        String[] specialities = lab.getTechSpecialities();
        JPanel specialitiesListPanel = new JPanel(new GridLayout(specialities.length, 1, 0, 0));
        specialitiesListPanel.setBorder(new MarsPanelBorder());
        this.add((Component)specialitiesListPanel, "Center");
        for (String speciality : specialities) {
            JLabel specialityLabel = new JLabel(speciality, 0);
            specialitiesListPanel.add(specialityLabel);
        }
    }

    @Override
    public void update() {
        if (this.researchersCache != this.lab.getResearcherNum()) {
            this.researchersCache = this.lab.getResearcherNum();
            this.researchersLabel.setText("Number of Researchers: " + this.researchersCache);
        }
    }
}

