/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.vehicle;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.monitor.PersonTableModel;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class CrewTabPanel
extends TabPanel
implements MouseListener,
ActionListener {
    private JLabel crewNumLabel;
    private JLabel crewCapLabel;
    private DefaultListModel crewListModel;
    private JList crewList;
    private Collection<Person> crewCache;
    private int crewNumCache;
    private int crewCapacityCache;

    public CrewTabPanel(Vehicle vehicle, MainDesktopPane desktop) {
        super("Crew", null, "Vehicle's Crew", (Unit)vehicle, desktop);
        Crewable crewable = (Crewable)vehicle;
        JPanel crewCountPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        crewCountPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(crewCountPanel);
        this.crewNumCache = crewable.getCrewNum();
        this.crewNumLabel = new JLabel("Crew: " + this.crewNumCache, 0);
        crewCountPanel.add(this.crewNumLabel);
        this.crewCapacityCache = crewable.getCrewCapacity();
        this.crewCapLabel = new JLabel("Crew Capacity: " + this.crewCapacityCache, 0);
        crewCountPanel.add(this.crewCapLabel);
        JPanel crewDisplayPanel = new JPanel(new FlowLayout(0));
        crewDisplayPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(crewDisplayPanel);
        JScrollPane crewScrollPanel = new JScrollPane();
        crewScrollPanel.setPreferredSize(new Dimension(175, 100));
        crewDisplayPanel.add(crewScrollPanel);
        this.crewListModel = new DefaultListModel();
        this.crewCache = crewable.getCrew();
        Iterator<Person> i = this.crewCache.iterator();
        while (i.hasNext()) {
            this.crewListModel.addElement(i.next());
        }
        this.crewList = new JList(this.crewListModel);
        this.crewList.addMouseListener(this);
        crewScrollPanel.setViewportView(this.crewList);
        JButton monitorButton = new JButton(ImageLoader.getIcon("Monitor"));
        monitorButton.setMargin(new Insets(1, 1, 1, 1));
        monitorButton.addActionListener(this);
        monitorButton.setToolTipText("Open tab in monitor tool");
        crewDisplayPanel.add(monitorButton);
    }

    @Override
    public void update() {
        Vehicle vehicle = (Vehicle)this.unit;
        Crewable crewable = (Crewable)vehicle;
        if (this.crewNumCache != crewable.getCrewNum()) {
            this.crewNumCache = crewable.getCrewNum();
            this.crewNumLabel.setText("Crew: " + this.crewNumCache);
        }
        if (this.crewCapacityCache != crewable.getCrewCapacity()) {
            this.crewCapacityCache = crewable.getCrewCapacity();
            this.crewCapLabel.setText("Crew Capacity: " + this.crewCapacityCache);
        }
        if (!Arrays.equals(this.crewCache.toArray(), crewable.getCrew().toArray())) {
            this.crewCache = crewable.getCrew();
            this.crewListModel.clear();
            Iterator<Person> i = this.crewCache.iterator();
            while (i.hasNext()) {
                this.crewListModel.addElement(i.next());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Vehicle vehicle = (Vehicle)this.unit;
        Crewable crewable = (Crewable)vehicle;
        this.desktop.addModel(new PersonTableModel(crewable));
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Person person;
        if (event.getClickCount() >= 2 && (person = (Person)this.crewList.getSelectedValue()) != null) {
            this.desktop.openUnitWindow((Unit)person, false);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

