/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.vehicle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.Person;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.tool.mission.MissionWindow;
import org.mars_sim.msp.ui.swing.tool.monitor.PersonTableModel;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;

public class MissionTabPanel
extends TabPanel {
    private JTextArea missionTextArea;
    private JTextArea missionPhaseTextArea;
    private DefaultListModel memberListModel;
    private JList memberList;
    private JButton missionButton;
    private JButton monitorButton;
    private String missionCache = "";
    private String missionPhaseCache = "";
    private Collection<Person> memberCache;

    public MissionTabPanel(Vehicle vehicle, MainDesktopPane desktop) {
        super("Mission", null, "Vehicle's Mission", (Unit)vehicle, desktop);
        Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle(vehicle);
        JPanel missionTopPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        missionTopPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(missionTopPanel);
        JPanel missionPanel = new JPanel(new BorderLayout(0, 0));
        missionTopPanel.add(missionPanel);
        JLabel missionTitleLabel = new JLabel("Mission", 0);
        missionPanel.add((Component)missionTitleLabel, "North");
        if (mission != null) {
            this.missionCache = mission.getDescription();
        }
        this.missionTextArea = new JTextArea(2, 20);
        if (this.missionCache != null) {
            this.missionTextArea.setText(this.missionCache);
        }
        this.missionTextArea.setLineWrap(true);
        this.missionTextArea.setEditable(false);
        missionPanel.add((Component)new JScrollPane(this.missionTextArea), "Center");
        JPanel missionPhasePanel = new JPanel(new BorderLayout(0, 0));
        missionTopPanel.add(missionPhasePanel);
        JLabel missionPhaseLabel = new JLabel("Mission Phase", 0);
        missionPhasePanel.add((Component)missionPhaseLabel, "North");
        if (mission != null) {
            this.missionPhaseCache = mission.getPhaseDescription();
        }
        this.missionPhaseTextArea = new JTextArea(2, 20);
        if (this.missionPhaseCache != null) {
            this.missionPhaseTextArea.setText(this.missionPhaseCache);
        }
        this.missionPhaseTextArea.setLineWrap(true);
        this.missionPhaseTextArea.setEditable(false);
        missionPhasePanel.add((Component)new JScrollPane(this.missionPhaseTextArea), "Center");
        JPanel missionBottomPanel = new JPanel(new BorderLayout(0, 0));
        missionBottomPanel.setBorder(new MarsPanelBorder());
        this.topContentPanel.add(missionBottomPanel);
        JLabel memberLabel = new JLabel("Members", 0);
        missionBottomPanel.add((Component)memberLabel, "North");
        JPanel memberListPanel = new JPanel(new FlowLayout(0));
        memberListPanel.setBorder(new MarsPanelBorder());
        missionBottomPanel.add((Component)memberListPanel, "South");
        JScrollPane memberScrollPanel = new JScrollPane();
        memberScrollPanel.setPreferredSize(new Dimension(175, 100));
        memberListPanel.add(memberScrollPanel);
        this.memberListModel = new DefaultListModel();
        this.memberCache = mission != null ? mission.getPeople() : new ConcurrentLinkedQueue<Person>();
        Iterator<Person> i = this.memberCache.iterator();
        while (i.hasNext()) {
            this.memberListModel.addElement(i.next());
        }
        this.memberList = new JList(this.memberListModel);
        this.memberList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getClickCount() >= 2) {
                    MissionTabPanel.this.getDesktop().openUnitWindow((Unit)((Person)MissionTabPanel.this.memberList.getSelectedValue()), false);
                }
            }
        });
        memberScrollPanel.setViewportView(this.memberList);
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 0, 2));
        buttonPanel.setBorder(new MarsPanelBorder());
        memberListPanel.add(buttonPanel);
        this.missionButton = new JButton(ImageLoader.getIcon("Mission"));
        this.missionButton.setMargin(new Insets(1, 1, 1, 1));
        this.missionButton.setToolTipText("Open mission in mission tool.");
        this.missionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Vehicle vehicle = (Vehicle)MissionTabPanel.this.unit;
                Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle(vehicle);
                if (mission != null) {
                    ((MissionWindow)MissionTabPanel.this.getDesktop().getToolWindow("Mission Tool")).selectMission(mission);
                    MissionTabPanel.this.getDesktop().openToolWindow("Mission Tool");
                }
            }
        });
        this.missionButton.setEnabled(mission != null);
        buttonPanel.add(this.missionButton);
        this.monitorButton = new JButton(ImageLoader.getIcon("Monitor"));
        this.monitorButton.setMargin(new Insets(1, 1, 1, 1));
        this.monitorButton.setToolTipText("Open tab in monitor tool for this mission.");
        this.monitorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Vehicle vehicle = (Vehicle)MissionTabPanel.this.unit;
                Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle(vehicle);
                if (mission != null) {
                    MissionTabPanel.this.getDesktop().addModel(new PersonTableModel(mission));
                }
            }
        });
        this.monitorButton.setEnabled(mission != null);
        buttonPanel.add(this.monitorButton);
    }

    @Override
    public void update() {
        Vehicle vehicle = (Vehicle)this.unit;
        Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle(vehicle);
        this.missionCache = mission != null ? mission.getDescription() : "";
        if (!this.missionCache.equals(this.missionTextArea.getText())) {
            this.missionTextArea.setText(this.missionCache);
        }
        this.missionPhaseCache = mission != null ? mission.getPhaseDescription() : "";
        if (!this.missionPhaseCache.equals(this.missionPhaseTextArea.getText())) {
            this.missionPhaseTextArea.setText(this.missionPhaseCache);
        }
        ConcurrentLinkedQueue<Person> tempCollection = null;
        tempCollection = mission != null ? mission.getPeople() : new ConcurrentLinkedQueue<Person>();
        if (!Arrays.equals(this.memberCache.toArray(), tempCollection.toArray())) {
            this.memberCache = tempCollection;
            this.memberListModel.clear();
            Iterator<Person> i = this.memberCache.iterator();
            while (i.hasNext()) {
                this.memberListModel.addElement(i.next());
            }
        }
        this.missionButton.setEnabled(mission != null);
        this.monitorButton.setEnabled(mission != null);
    }
}

