/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.vehicle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import org.mars_sim.msp.core.Coordinates;
import org.mars_sim.msp.core.Simulation;
import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.person.ai.mission.Mission;
import org.mars_sim.msp.core.person.ai.mission.NavPoint;
import org.mars_sim.msp.core.person.ai.mission.VehicleMission;
import org.mars_sim.msp.core.structure.Settlement;
import org.mars_sim.msp.core.vehicle.GroundVehicle;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.core.vehicle.VehicleOperator;
import org.mars_sim.msp.ui.swing.ImageLoader;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.MarsPanelBorder;
import org.mars_sim.msp.ui.swing.unit_window.TabPanel;
import org.mars_sim.msp.ui.swing.unit_window.vehicle.DirectionDisplayPanel;
import org.mars_sim.msp.ui.swing.unit_window.vehicle.TerrainDisplayPanel;

public class NavigationTabPanel
extends TabPanel
implements ActionListener {
    private static String CLASS_NAME = "org.mars_sim.msp.ui.standard.unit_window.vehicle.NavigationTabPanel";
    private static Logger logger = Logger.getLogger(CLASS_NAME);
    private DecimalFormat formatter = new DecimalFormat("0.0");
    private JButton driverButton;
    private JLabel statusLabel;
    private JLabel beaconLabel;
    private JLabel speedLabel;
    private JLabel elevationLabel;
    private JButton centerMapButton;
    private JButton destinationButton;
    private JLabel destinationTextLabel;
    private JPanel destinationLabelPanel;
    private JLabel destinationLatitudeLabel;
    private JLabel destinationLongitudeLabel;
    private JLabel distanceLabel;
    private JLabel etaLabel;
    private DirectionDisplayPanel directionDisplay;
    private TerrainDisplayPanel terrainDisplay;
    private VehicleOperator driverCache;
    private String statusCache;
    private boolean beaconCache;
    private double speedCache;
    private double elevationCache;
    private Settlement destinationSettlementCache;
    private String destinationTextCache;
    private Coordinates destinationLocationCache;
    private String etaCache;
    private double distanceCache;

    public NavigationTabPanel(Unit unit, MainDesktopPane desktop) {
        super("Navigation", null, "Navigation", unit, desktop);
        VehicleMission vehicleMission;
        Vehicle vehicle = (Vehicle)unit;
        JPanel mainPanel = new JPanel(new BorderLayout(0, 0));
        this.topContentPanel.add(mainPanel);
        JPanel topInfoPanel = new JPanel(new BorderLayout(0, 0));
        topInfoPanel.setBorder(new MarsPanelBorder());
        mainPanel.add((Component)topInfoPanel, "North");
        JPanel driverPanel = new JPanel(new FlowLayout(0, 0, 0));
        topInfoPanel.add((Component)driverPanel, "North");
        JLabel driverLabel = new JLabel("Driver: ", 2);
        driverLabel.setBorder(new EmptyBorder(5, 0, 5, 0));
        driverPanel.add(driverLabel);
        this.driverCache = vehicle.getOperator();
        this.driverButton = new JButton();
        this.driverButton.addActionListener(this);
        this.driverButton.setVisible(false);
        if (this.driverCache != null) {
            this.driverButton.setText(this.driverCache.getOperatorName());
            this.driverButton.setVisible(true);
        }
        driverPanel.add(this.driverButton);
        JPanel infoLabelPanel = new JPanel(new GridLayout(3, 1, 0, 0));
        topInfoPanel.add((Component)infoLabelPanel, "Center");
        this.statusCache = vehicle.getStatus();
        this.statusLabel = new JLabel("Status: " + this.statusCache, 2);
        infoLabelPanel.add(this.statusLabel);
        this.beaconCache = vehicle.isEmergencyBeacon();
        String beaconString = this.beaconCache ? "on" : "off";
        this.beaconLabel = new JLabel("Emergency Beacon: " + beaconString, 2);
        infoLabelPanel.add(this.beaconLabel);
        this.speedCache = vehicle.getSpeed();
        this.speedLabel = new JLabel("Speed: " + this.formatter.format(this.speedCache) + " km/h", 2);
        infoLabelPanel.add(this.speedLabel);
        if (vehicle instanceof GroundVehicle) {
            GroundVehicle gVehicle = (GroundVehicle)vehicle;
            this.elevationCache = gVehicle.getElevation();
            this.elevationLabel = new JLabel("Elevation: " + this.formatter.format(this.elevationCache) + " km.", 2);
            topInfoPanel.add((Component)this.elevationLabel, "South");
        }
        JPanel destinationInfoPanel = new JPanel(new BorderLayout(0, 0));
        destinationInfoPanel.setBorder(new MarsPanelBorder());
        mainPanel.add((Component)destinationInfoPanel, "Center");
        this.destinationLabelPanel = new JPanel(new FlowLayout(0));
        destinationInfoPanel.add((Component)this.destinationLabelPanel, "North");
        this.centerMapButton = new JButton(ImageLoader.getIcon("CenterMap"));
        this.centerMapButton.setMargin(new Insets(1, 1, 1, 1));
        this.centerMapButton.addActionListener(this);
        this.centerMapButton.setToolTipText("Locate in Mars Navigator");
        this.destinationLabelPanel.add(this.centerMapButton);
        JLabel destinationLabel = new JLabel("Destination: ", 2);
        this.destinationLabelPanel.add(destinationLabel);
        this.destinationButton = new JButton();
        this.destinationButton.addActionListener(this);
        this.destinationTextLabel = new JLabel("", 2);
        boolean hasDestination = false;
        Mission mission = Simulation.instance().getMissionManager().getMissionForVehicle(vehicle);
        if (mission != null && mission instanceof VehicleMission && (vehicleMission = (VehicleMission)mission).getTravelStatus().equals("Traveling to navpoint")) {
            hasDestination = true;
            this.destinationLocationCache = vehicleMission.getNextNavpoint().getLocation();
            NavPoint destinationPoint = vehicleMission.getNextNavpoint();
            if (destinationPoint.isSettlementAtNavpoint()) {
                this.destinationSettlementCache = destinationPoint.getSettlement();
                this.destinationButton.setText(this.destinationSettlementCache.getName());
                this.destinationLabelPanel.add(this.destinationButton);
            } else {
                this.destinationTextCache = "Coordinates";
                this.destinationTextLabel.setText(this.destinationTextCache);
                this.destinationLabelPanel.add(this.destinationTextLabel);
            }
        }
        if (!hasDestination) {
            this.destinationTextCache = "None";
            this.destinationTextLabel.setText(this.destinationTextCache);
            this.destinationLabelPanel.add(this.destinationTextLabel);
        }
        JPanel destinationInfoLabelPanel = new JPanel(new GridLayout(4, 1, 0, 0));
        destinationInfoPanel.add((Component)destinationInfoLabelPanel, "Center");
        String latitudeString = "";
        if (this.destinationLocationCache != null) {
            latitudeString = this.destinationLocationCache.getFormattedLatitudeString();
        }
        this.destinationLatitudeLabel = new JLabel("Latitude: " + latitudeString, 2);
        destinationInfoLabelPanel.add(this.destinationLatitudeLabel);
        String longitudeString = "";
        if (this.destinationLocationCache != null) {
            longitudeString = this.destinationLocationCache.getFormattedLongitudeString();
        }
        this.destinationLongitudeLabel = new JLabel("Longitude: " + longitudeString, 2);
        destinationInfoLabelPanel.add(this.destinationLongitudeLabel);
        if (mission != null && mission instanceof VehicleMission && ((VehicleMission)mission).getTravelStatus().equals("Traveling to navpoint")) {
            try {
                this.distanceCache = ((VehicleMission)mission).getCurrentLegRemainingDistance();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error getting current leg remaining distance.");
                e.printStackTrace(System.err);
            }
            this.distanceLabel = new JLabel("Distance: " + this.formatter.format(this.distanceCache) + " km.", 2);
        } else {
            this.distanceCache = 0.0;
            this.distanceLabel = new JLabel("Distance: ", 2);
        }
        destinationInfoLabelPanel.add(this.distanceLabel);
        this.etaCache = mission != null && mission instanceof VehicleMission && ((VehicleMission)mission).getLegETA() != null ? ((VehicleMission)mission).getLegETA().toString() : "";
        this.etaLabel = new JLabel("ETA: " + this.etaCache, 2);
        destinationInfoLabelPanel.add(this.etaLabel);
        JPanel graphicDisplayPanel = new JPanel(new FlowLayout(1));
        graphicDisplayPanel.setBorder(new MarsPanelBorder());
        mainPanel.add((Component)graphicDisplayPanel, "South");
        JPanel directionDisplayPanel = new JPanel(new FlowLayout(1, 0, 0));
        directionDisplayPanel.setBorder(new BevelBorder(1));
        graphicDisplayPanel.add(directionDisplayPanel);
        this.directionDisplay = new DirectionDisplayPanel(vehicle);
        directionDisplayPanel.add(this.directionDisplay);
        if (vehicle instanceof GroundVehicle) {
            JPanel terrainDisplayPanel = new JPanel(new FlowLayout(1, 0, 0));
            terrainDisplayPanel.setBorder(new BevelBorder(1));
            graphicDisplayPanel.add(terrainDisplayPanel);
            this.terrainDisplay = new TerrainDisplayPanel((GroundVehicle)vehicle);
            terrainDisplayPanel.add(this.terrainDisplay);
        }
    }

    @Override
    public void update() {
        Mission mission;
        GroundVehicle gVehicle;
        double currentElevation;
        Vehicle vehicle = (Vehicle)this.unit;
        boolean driverChange = false;
        if (this.driverCache == null) {
            if (vehicle.getOperator() != null) {
                driverChange = true;
            }
        } else if (!this.driverCache.equals(vehicle.getOperator())) {
            driverChange = true;
        }
        if (driverChange) {
            this.driverCache = vehicle.getOperator();
            if (this.driverCache == null) {
                this.driverButton.setVisible(false);
            } else {
                this.driverButton.setVisible(true);
                this.driverButton.setText(this.driverCache.getOperatorName());
            }
        }
        if (!this.statusCache.equals(vehicle.getStatus())) {
            this.statusCache = vehicle.getStatus();
            this.statusLabel.setText("Status: " + this.statusCache);
        }
        if (this.beaconCache != vehicle.isEmergencyBeacon()) {
            this.beaconCache = vehicle.isEmergencyBeacon();
            if (this.beaconCache) {
                this.beaconLabel.setText("Emergency Beacon: on");
            } else {
                this.beaconLabel.setText("Emergency Beacon: off");
            }
        }
        if (this.speedCache != vehicle.getSpeed()) {
            this.speedCache = vehicle.getSpeed();
            this.speedLabel.setText("Speed: " + this.formatter.format(this.speedCache) + " km/h");
        }
        if (vehicle instanceof GroundVehicle && this.elevationCache != (currentElevation = (gVehicle = (GroundVehicle)vehicle).getElevation())) {
            this.elevationCache = currentElevation;
            this.elevationLabel.setText("Elevation: " + this.formatter.format(this.elevationCache) + " km.");
        }
        if ((mission = Simulation.instance().getMissionManager().getMissionForVehicle(vehicle)) != null && mission instanceof VehicleMission && ((VehicleMission)mission).getTravelStatus().equals("Traveling to navpoint")) {
            NavPoint destinationPoint = ((VehicleMission)mission).getNextNavpoint();
            if (destinationPoint.isSettlementAtNavpoint()) {
                if (this.destinationSettlementCache != destinationPoint.getSettlement()) {
                    this.destinationSettlementCache = destinationPoint.getSettlement();
                    this.destinationButton.setText(this.destinationSettlementCache.getName());
                    this.addDestinationButton();
                    this.destinationTextCache = "";
                }
            } else if (this.destinationTextCache != "Coordinates") {
                this.destinationTextCache = "Coordinates";
                this.destinationTextLabel.setText(this.destinationTextCache);
                this.addDestinationTextLabel();
                this.destinationSettlementCache = null;
            }
        } else if (this.destinationTextCache != "None") {
            this.destinationTextCache = "None";
            this.destinationTextLabel.setText(this.destinationTextCache);
            this.addDestinationTextLabel();
            this.destinationSettlementCache = null;
        }
        if (mission != null && mission instanceof VehicleMission && ((VehicleMission)mission).getTravelStatus().equals("Traveling to navpoint")) {
            VehicleMission vehicleMission = (VehicleMission)mission;
            if (this.destinationLocationCache == null) {
                this.destinationLocationCache = new Coordinates(vehicleMission.getNextNavpoint().getLocation());
            } else {
                this.destinationLocationCache.setCoords(vehicleMission.getNextNavpoint().getLocation());
            }
            this.destinationLatitudeLabel.setText("Latitude: " + this.destinationLocationCache.getFormattedLatitudeString());
            this.destinationLongitudeLabel.setText("Longitude: " + this.destinationLocationCache.getFormattedLongitudeString());
        } else if (this.destinationLocationCache != null) {
            this.destinationLocationCache = null;
            this.destinationLatitudeLabel.setText("Latitude: ");
            this.destinationLongitudeLabel.setText("Longitude: ");
        }
        if (mission != null && mission instanceof VehicleMission) {
            VehicleMission vehicleMission = (VehicleMission)mission;
            try {
                if (this.distanceCache != vehicleMission.getCurrentLegRemainingDistance()) {
                    this.distanceCache = vehicleMission.getCurrentLegRemainingDistance();
                    this.distanceLabel.setText("Distance: " + this.formatter.format(this.distanceCache) + " km.");
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error getting current leg remaining distance.");
                e.printStackTrace(System.err);
            }
        } else {
            this.distanceCache = 0.0;
            this.distanceLabel.setText("Distance:");
        }
        if (mission != null && mission instanceof VehicleMission) {
            VehicleMission vehicleMission = (VehicleMission)mission;
            if (vehicleMission.getLegETA() != null && !this.etaCache.equals(vehicleMission.getLegETA().toString())) {
                this.etaCache = vehicleMission.getLegETA().toString();
                this.etaLabel.setText("ETA: " + this.etaCache);
            }
        } else {
            this.etaCache = "";
            this.etaLabel.setText("ETA: ");
        }
        this.directionDisplay.update();
        this.terrainDisplay.update();
    }

    private void addDestinationButton() {
        try {
            Component lastComponent = this.destinationLabelPanel.getComponent(2);
            if (lastComponent == this.destinationTextLabel) {
                this.destinationLabelPanel.remove(this.destinationTextLabel);
                this.destinationLabelPanel.add(this.destinationButton);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.destinationLabelPanel.add(this.destinationButton);
        }
    }

    private void addDestinationTextLabel() {
        try {
            Component lastComponent = this.destinationLabelPanel.getComponent(2);
            if (lastComponent == this.destinationButton) {
                this.destinationLabelPanel.remove(this.destinationButton);
                this.destinationLabelPanel.add(this.destinationTextLabel);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.destinationLabelPanel.add(this.destinationTextLabel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JComponent source = (JComponent)event.getSource();
        if (source == this.centerMapButton && this.destinationLocationCache != null) {
            this.desktop.centerMapGlobe(this.destinationLocationCache);
        }
        if (source == this.destinationButton) {
            this.desktop.openUnitWindow((Unit)this.destinationSettlementCache, false);
        }
        if (source == this.driverButton) {
            this.desktop.openUnitWindow((Unit)this.driverCache, false);
        }
    }
}

