/*
 * Decompiled with CFR 0.152.
 */
package org.mars_sim.msp.ui.swing.unit_window.vehicle;

import org.mars_sim.msp.core.Unit;
import org.mars_sim.msp.core.vehicle.Crewable;
import org.mars_sim.msp.core.vehicle.Rover;
import org.mars_sim.msp.core.vehicle.Vehicle;
import org.mars_sim.msp.ui.swing.MainDesktopPane;
import org.mars_sim.msp.ui.swing.unit_window.InventoryTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.LocationTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.MaintenanceTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.SalvageTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.UnitWindow;
import org.mars_sim.msp.ui.swing.unit_window.vehicle.CrewTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.vehicle.LaboratoryTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.vehicle.MissionTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.vehicle.NavigationTabPanel;
import org.mars_sim.msp.ui.swing.unit_window.vehicle.TowTabPanel;

public class VehicleWindow
extends UnitWindow {
    private boolean salvaged;

    public VehicleWindow(MainDesktopPane desktop, Vehicle vehicle) {
        super(desktop, (Unit)vehicle, true);
        Rover rover;
        this.addTabPanel(new NavigationTabPanel((Unit)vehicle, desktop));
        if (vehicle instanceof Crewable) {
            this.addTabPanel(new CrewTabPanel(vehicle, desktop));
        }
        this.addTabPanel(new LocationTabPanel((Unit)vehicle, desktop));
        this.addTabPanel(new InventoryTabPanel((Unit)vehicle, desktop));
        this.addTabPanel(new MaintenanceTabPanel((Unit)vehicle, desktop));
        if (vehicle instanceof Rover && (rover = (Rover)vehicle).hasLab()) {
            this.addTabPanel(new LaboratoryTabPanel((Unit)rover, desktop));
        }
        this.addTabPanel(new MissionTabPanel(vehicle, desktop));
        this.addTabPanel(new TowTabPanel((Unit)vehicle, desktop));
        this.salvaged = vehicle.isSalvaged();
        if (this.salvaged) {
            this.addTabPanel(new SalvageTabPanel((Unit)vehicle, desktop));
        }
    }

    @Override
    public void update() {
        super.update();
        Vehicle vehicle = (Vehicle)this.getUnit();
        if (!this.salvaged && vehicle.isSalvaged()) {
            this.addTabPanel(new SalvageTabPanel((Unit)vehicle, this.desktop));
            this.salvaged = true;
        }
    }
}

