/*
 * Decompiled with CFR 0.152.
 */
package rescue.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import rescue.RunRescue;

public class SmallMapPanel
extends JPanel
implements MouseListener {
    private RunRescue rescue;

    public SmallMapPanel(RunRescue rr, int w, int h) {
        this.rescue = rr;
        this.addMouseListener(this);
        Dimension size = new Dimension(w, h);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
    }

    public void paintComponent(Graphics g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.WHITE);
        if (this.rescue.getShip() != null && this.rescue.getShip().getSystem(5) == 0) {
            g.drawLine(this.getWidth() / 2, this.getHeight() / 2 + 10, this.getWidth() / 2, this.getHeight() / 2 - 10);
            g.drawLine(this.getWidth() / 2 + 10, this.getHeight() / 2, this.getWidth() / 2 - 10, this.getHeight() / 2);
            this.rescue.drawShipsSmall(g, this.getWidth(), this.getHeight());
        } else {
            g.drawString("-- OFFLINE --", this.getWidth() / 2 - 30, this.getHeight() / 2 + 3);
        }
    }

    public void list() {
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        boolean leftClick;
        boolean rightClick = e.getModifiers() == 16;
        boolean middleClick = e.getModifiers() == 8;
        boolean bl = leftClick = e.getModifiers() == 4;
        if (rightClick || leftClick) {
            this.rescue.shipWarp(e.getX(), e.getY(), this.getWidth(), this.getHeight());
        }
        if (leftClick) {
            this.rescue.shipWarpOn();
        } else if (middleClick) {
            double angle = Math.atan((double)(e.getX() - this.getWidth() / 2) / (double)(this.getHeight() / 2 - e.getY()));
            if (e.getY() > this.getHeight() / 2) {
                angle += Math.toRadians(180.0);
            }
            if (angle < 0.0) {
                angle += Math.toRadians(360.0);
            }
            this.rescue.shipManWarp(angle);
        }
    }
}

