/*
 * Decompiled with CFR 0.152.
 */
package rescue.spaceobjects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Vector;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.ParticleEffect;
import rescue.spaceobjects.Ship;
import rescue.spaceobjects.Torpedo;

public abstract class MannedObject
extends ImageObject {
    protected int systemPhaserBanks = 0;
    protected int systemTorpedoTubes = 0;
    protected int systemShields = 0;
    protected int systemComputer = 0;
    protected int systemTransporters = 0;
    protected int systemTractorBeam = 0;
    protected int INFOmax_phaserIntensity;
    protected int INFOmax_phaserbanks;
    protected int INFOmax_torpedoSalvo;
    protected int INFOmax_torpedosleft;
    protected int INFOmax_shieldsPower;
    protected int INFOmax_tractorPower;
    protected int INFOmax_totalenergy;
    protected int INFOmax_cloakPower;
    protected String type;
    protected int number;
    protected int[] SpaceObjectsLikes;
    protected int firingPhaser;
    protected MannedObject phaserTarget;
    protected int phaserIntensity;
    protected int TorpedoSalvo;
    protected int target;
    protected int shieldPower;
    protected boolean ShieldsUp;
    protected int teams;
    protected int people;
    protected int totalEnergy;
    protected int phaserBanks;
    protected int torpedosLeft;
    protected Ship tractoredShip;
    protected int tractorBeamPower;
    protected boolean cloaked;
    protected int cloakPower;
    protected boolean alive;
    protected int reserve;
    protected int reserveMAX = 1000;
    private int counter = 0;

    public MannedObject(int num, String t, String n, int ix, int iy, ImageObject[] so, BufferedImage a, BufferedImage b, BufferedImage c, BufferedImage d, Vector z) {
        super(ix, iy, so, z, a, b, c, d, n);
        this.number = num;
        this.type = t;
        this.x = ix;
        this.y = iy;
        this.SpaceObjects = so;
        this.phaserTarget = null;
        this.firingPhaser = 0;
        this.target = 0;
        this.alive = true;
        this.torpedos = z;
        this.teams = num != -1 && num == so.length - 1 ? 10 : 0;
        this.reserve = this.reserveMAX;
    }

    public void setInfo(int a, int b, int e, int f, int g, int h, int i, int j) {
        this.INFOmax_phaserIntensity = a;
        this.INFOmax_torpedoSalvo = b;
        this.INFOmax_tractorPower = e;
        this.INFOmax_cloakPower = f;
        this.INFOmax_totalenergy = g;
        this.INFOmax_phaserbanks = h;
        this.INFOmax_torpedosleft = i;
        this.INFOmax_shieldsPower = j;
        if (this.INFOmax_cloakPower > 0) {
            this.cloakPower = this.INFOmax_cloakPower;
            this.cloaked = true;
        }
        if (this.INFOmax_shieldsPower > 0) {
            this.shieldPower = this.INFOmax_shieldsPower;
            this.ShieldsUp = true;
        }
        this.totalEnergy = this.INFOmax_totalenergy;
        this.phaserBanks = this.INFOmax_phaserbanks;
        this.torpedosLeft = this.INFOmax_torpedosleft;
        this.tractorBeamPower = this.INFOmax_tractorPower;
        this.TorpedoSalvo = this.INFOmax_torpedoSalvo;
        this.phaserIntensity = this.INFOmax_phaserIntensity;
    }

    public int getShieldPower() {
        return this.shieldPower;
    }

    public int getTotalEnergy() {
        return this.totalEnergy;
    }

    public int getPhaserBanks() {
        return this.phaserBanks;
    }

    public int getTorpedosLeft() {
        return this.torpedosLeft;
    }

    public void setNoAwayTeams(int a) {
        this.teams = a;
    }

    public int getNoAwayTeams() {
        return this.teams;
    }

    public boolean doYouLike(MannedObject a) {
        return this.SpaceObjectsLikes[a.getNumber()] > 0;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int a) {
        this.number = a;
    }

    public int getPeople() {
        return this.people;
    }

    public void addPeople(int a) {
        this.people += a;
    }

    public void beamTeamFrom(MannedObject from) {
        if (from.beamTeamUp()) {
            ++this.teams;
            if (this instanceof Ship && from instanceof Ship && this.SpaceObjectsLikes[this.SpaceObjectsLikes.length - 1] < 1) {
                this.SpaceObjectsLikes = from.copyLikeInfo();
                for (int i = 0; i < this.SpaceObjects.length; ++i) {
                    if (!(this.SpaceObjects[i] instanceof MannedObject)) continue;
                    ((MannedObject)this.SpaceObjects[i]).setLike(this.number, from.getNumber());
                }
            }
        }
    }

    public boolean beamTeamUp() {
        if (this.teams > 0) {
            --this.teams;
            return true;
        }
        return false;
    }

    public int[] copyLikeInfo() {
        int[] a = new int[this.SpaceObjectsLikes.length];
        System.arraycopy(this.SpaceObjectsLikes, 0, a, 0, a.length);
        return a;
    }

    public void setLike(int a, int b) {
        this.SpaceObjectsLikes[a] = this.SpaceObjectsLikes[b];
    }

    public void TractorShip(Ship a) {
        if (a != null && this.systemTractorBeam == 0) {
            a.setOwner(this);
            this.tractoredShip = a;
        } else if (this.tractoredShip != null) {
            this.tractoredShip.setOwner(null);
            this.tractoredShip = null;
        }
    }

    public void TorpedoHit(MannedObject who) {
        this.gotHit(who, 6, 0);
    }

    public void PhaserHit(MannedObject who, int a, int t) {
        this.gotHit(who, a, t);
    }

    public void gotHit(MannedObject who, int hitpower, int hitlocation) {
        int c = who.getNumber();
        int b = this.number;
        for (int i = 0; i < this.SpaceObjectsLikes.length; ++i) {
            if (!(this.SpaceObjects[i] instanceof MannedObject)) continue;
            ((MannedObject)this.SpaceObjects[i]).youShouldLike(c, b);
        }
        double spower = (double)Math.max(this.shieldPower, 1) / 100.0;
        int damage = hitpower * 5;
        if (this.ShieldsUp) {
            int hitshields = (int)((double)damage * spower);
            this.shieldPower -= damage;
            damage -= hitshields;
            if (this.shieldPower < 5) {
                this.shieldPower = 0;
            }
        }
        while (damage != 0) {
            if (hitlocation == 0) {
                while (this.getSystem(hitlocation = (int)Math.round(Math.random() * 9.0) + 1) == 10) {
                }
            }
            if (hitlocation == 1 || hitlocation == 2 || hitlocation == 5 || hitlocation == 6) {
                if (this instanceof Ship) {
                    damage = ((Ship)this).shipDamage(hitlocation, damage);
                }
            } else if (hitlocation == 3) {
                this.systemPhaserBanks -= damage;
                if (this.systemPhaserBanks < -10) {
                    damage -= this.systemPhaserBanks + 10;
                    this.systemPhaserBanks = -10;
                }
            } else if (hitlocation == 4) {
                this.systemTorpedoTubes -= damage;
                if (this.systemTorpedoTubes < -10) {
                    damage -= this.systemTorpedoTubes + 10;
                    this.systemTorpedoTubes = -10;
                }
            } else if (hitlocation == 7) {
                this.systemShields -= damage;
                if (this.systemShields < -10) {
                    damage -= this.systemShields + 10;
                    this.systemShields = -10;
                }
            } else if (hitlocation == 8) {
                this.systemComputer -= damage;
                if (this.systemComputer < -10) {
                    damage -= this.systemComputer + 10;
                    this.systemComputer = -10;
                }
            } else if (hitlocation == 9) {
                this.systemTransporters -= damage;
                if (this.systemTransporters < -10) {
                    damage -= this.systemTransporters + 10;
                    this.systemTransporters = -10;
                }
            } else if (hitlocation == 10) {
                this.systemTractorBeam -= damage;
                if (this.systemTractorBeam < -10) {
                    damage -= this.systemTractorBeam + 10;
                    this.systemTractorBeam = -10;
                }
            }
            damage /= 4;
            hitlocation = (int)Math.round(Math.random() * 10.0);
        }
        this.checkdead();
        if (this.ShieldsUp && this.shieldPower > 0) {
            this.torpedos.add(new ParticleEffect(this.x, this.y, this.SpaceObjects, this.torpedos, 20, Color.YELLOW, 0.0, 3.0, 0.0, this.getSize() / 2, false, 5));
        } else if (!this.alive) {
            this.torpedos.add(new ParticleEffect(this.x, this.y, this.SpaceObjects, this.torpedos, 50, Color.RED, 0.0, 3.0, 0.0, this.getSize(), false, 5));
        } else {
            this.torpedos.add(new ParticleEffect(this.x, this.y, this.SpaceObjects, this.torpedos, 20, Color.RED, 0.0, 3.0, 0.0, this.getSize() / 2, false, 5));
        }
    }

    public void checkdead() {
        int a = this.getLifeInfo();
        if (a <= -60) {
            this.alive = false;
        }
    }

    public int getLifeInfo() {
        int a = this.systemPhaserBanks + this.systemTorpedoTubes + this.systemShields + this.systemComputer + this.systemTransporters + this.systemTractorBeam;
        if (this instanceof Ship) {
            a += ((Ship)this).shipGetLifeInfo();
        }
        return a;
    }

    public boolean checkFixNeeded() {
        int a = this.systemPhaserBanks + this.systemTorpedoTubes + this.systemShields + this.systemComputer + this.systemTransporters + this.systemTractorBeam;
        if (this instanceof Ship) {
            a += ((Ship)this).shipGetLifeInfo();
        }
        return a != 0;
    }

    public void youShouldLike(int a, int b) {
        if (this.SpaceObjectsLikes[b] < 0) {
            this.SpaceObjectsLikes[a] = this.SpaceObjectsLikes[a] + 1;
        } else if (this.SpaceObjectsLikes[b] > 0) {
            this.SpaceObjectsLikes[a] = this.SpaceObjectsLikes[a] - 1;
        }
    }

    public boolean enemyOf(int a) {
        return this.SpaceObjectsLikes[a] < 0;
    }

    public boolean friendOf(int a) {
        return this.SpaceObjectsLikes[a] > 0;
    }

    public String getType() {
        return this.type;
    }

    public void setLikes(int[] v) {
        this.SpaceObjectsLikes = v;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void drawBigShape(Graphics g, boolean highLight) {
        if (this.firingPhaser != 0) {
            g.setColor(Color.RED);
            g.drawLine(this.x, this.y, this.phaserTarget.x, this.phaserTarget.y);
        }
        if (this.tractoredShip != null) {
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(this.x, this.y, this.tractoredShip.x, this.tractoredShip.y);
        }
        if (highLight) {
            int s = this.getSize();
            g.setColor(new Color(255, 0, 0));
            g.drawOval(this.x - s, this.y - s, s * 2, s * 2);
        }
    }

    public void drawSmallShape(Graphics g, double sx, double sy, int scan) {
        if (this.alive && (!this.cloaked || scan >= this.cloakPower)) {
            super.drawSmallShape(g, sx, sy, scan);
        }
    }

    public int getCloakPower() {
        return this.cloakPower;
    }

    public boolean hasSelected(Point p) {
        return this.alive && super.hasSelected(p);
    }

    public void FireTorpedo(MannedObject p) {
        if (this.torpedosLeft > 0 && this.systemTorpedoTubes == 0) {
            if (this.TorpedoSalvo > this.torpedosLeft) {
                this.TorpedoSalvo = this.torpedosLeft;
            }
            this.torpedosLeft -= this.TorpedoSalvo;
            if (this.TorpedoSalvo == 1) {
                this.FireTorpedo(p, this.getAngle(p));
            } else if (this.TorpedoSalvo == 2) {
                double c = this.getAngle(p);
                this.FireTorpedo(p, Math.toDegrees(c) < 350.0 ? c + Math.toRadians(10.0) : c - Math.toRadians(350.0));
                this.FireTorpedo(p, Math.toDegrees(c) >= 10.0 ? c - Math.toRadians(10.0) : c + Math.toRadians(350.0));
            } else {
                double c = this.getAngle(p);
                this.FireTorpedo(p, Math.toDegrees(c) < 350.0 ? c + Math.toRadians(10.0) : c - Math.toRadians(350.0));
                this.FireTorpedo(p, c);
                this.FireTorpedo(p, Math.toDegrees(c) >= 10.0 ? c - Math.toRadians(10.0) : c + Math.toRadians(350.0));
            }
        }
    }

    public void FireTorpedo(MannedObject p, double a) {
        this.torpedos.add(new Torpedo(this.x, this.y, this.SpaceObjects, this.torpedos, p, this, a));
    }

    public void FirePhaser(MannedObject p) {
        if (this.phaserBanks >= 50 && this.systemPhaserBanks == 0) {
            if (this.phaserIntensity * 50 > this.phaserBanks) {
                this.phaserIntensity = this.phaserBanks / 50;
            }
            this.phaserBanks -= this.phaserIntensity * 50;
            this.phaserTarget = p;
            this.firingPhaser = 10;
            this.phaserTarget.PhaserHit(this, this.phaserIntensity, this.target);
        }
    }

    public int getTractorBeamPower() {
        if (this.tractoredShip != null) {
            return this.tractorBeamPower;
        }
        return 0;
    }

    public int getTractorBeamMaxPower() {
        return this.INFOmax_tractorPower;
    }

    public int getMaxtotalenergy() {
        return this.INFOmax_totalenergy;
    }

    public int getMaxphaserbanks() {
        return this.INFOmax_phaserbanks;
    }

    public int getMaxtorpedosleft() {
        return this.INFOmax_torpedosleft;
    }

    public int getMaxshieldpower() {
        return this.INFOmax_shieldsPower;
    }

    public int getEnergy(int nrg) {
        if (this.totalEnergy > nrg) {
            this.totalEnergy -= nrg;
            return nrg;
        }
        int a = this.totalEnergy;
        this.totalEnergy = 0;
        return a;
    }

    public int getPhaser(int nrg) {
        if (this.phaserBanks > nrg) {
            this.phaserBanks -= nrg;
            return nrg;
        }
        int a = this.phaserBanks;
        this.phaserBanks = 0;
        return a;
    }

    public int getTorpedos(int nrg) {
        if (this.torpedosLeft > nrg) {
            this.torpedosLeft -= nrg;
            return nrg;
        }
        int a = this.torpedosLeft;
        this.torpedosLeft = 0;
        return a;
    }

    public void fixSystems() {
        if (this.systemPhaserBanks < 0) {
            ++this.systemPhaserBanks;
            return;
        }
        if (this.systemTorpedoTubes < 0) {
            ++this.systemTorpedoTubes;
            return;
        }
        if (this.systemShields < 0) {
            ++this.systemShields;
            return;
        }
        if (this.systemComputer < 0) {
            ++this.systemComputer;
            return;
        }
        if (this.systemTransporters < 0) {
            ++this.systemTransporters;
            return;
        }
        if (this.systemTractorBeam < 0) {
            ++this.systemTractorBeam;
            return;
        }
    }

    public int getSystem(int sys) {
        if (sys == 3) {
            return this.systemPhaserBanks;
        }
        if (sys == 4) {
            return this.systemTorpedoTubes;
        }
        if (sys == 7) {
            return this.systemShields;
        }
        if (sys == 8) {
            return this.systemComputer;
        }
        if (sys == 9) {
            return this.systemTransporters;
        }
        if (sys == 10) {
            return this.systemTractorBeam;
        }
        if (this instanceof Ship) {
            return ((Ship)this).shipGetSystem(sys);
        }
        return 0;
    }

    public void advance() {
        if (this.alive) {
            if (this.counter < 50) {
                ++this.counter;
            } else if (this.counter == 50) {
                this.counter = 0;
            }
            if (this.phaserBanks < this.INFOmax_phaserbanks && this.totalEnergy > 1) {
                --this.totalEnergy;
                ++this.phaserBanks;
            }
            if (this.ShieldsUp) {
                if (this.totalEnergy > 5) {
                    this.totalEnergy -= 5;
                } else {
                    this.ShieldsUp = false;
                }
            }
            if (this.counter == 0 && this.shieldPower < this.INFOmax_shieldsPower && this.totalEnergy > 20) {
                ++this.shieldPower;
                this.totalEnergy -= 20;
            }
            if (this.tractoredShip != null) {
                int te = this.tractoredShip.tractorEnergyUsed(this.INFOmax_tractorPower);
                if (this.totalEnergy > te) {
                    this.totalEnergy -= te;
                    this.tractorBeamPower = te;
                } else {
                    this.TractorShip(null);
                }
            }
            if (this.counter == 0 && this.checkFixNeeded() && this.totalEnergy > 300) {
                this.fixSystems();
                this.totalEnergy -= 300;
            }
            if (this.reserve < this.reserveMAX && this.totalEnergy > 1) {
                --this.totalEnergy;
                ++this.reserve;
            }
            if (this.totalEnergy < this.INFOmax_totalenergy) {
                this.totalEnergy += 10;
            }
            if (this.totalEnergy > this.INFOmax_totalenergy) {
                this.totalEnergy = this.INFOmax_totalenergy;
            }
        }
        if (this.firingPhaser != 0) {
            --this.firingPhaser;
        }
    }
}

