/*
 * Decompiled with CFR 0.152.
 */
package rescue.spaceobjects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import java.util.Vector;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.SpaceObject;

public class ParticleEffect
extends SpaceObject {
    private Color c = null;
    private boolean heavy = false;
    private double xdirection;
    private double ydirection;
    private boolean infinite = false;
    private int age = 0;
    private int number = 0;
    private int created = 0;
    private int finished = 0;
    private int release = 1;
    private double spread = 0.0;
    private Point2D attach;
    private Particle[] particles = null;
    private int attach_xoff;
    private int attach_yoff;

    public void attach(Point2D a, int attach_xoff, int attach_yoff) {
        this.attach = a;
        this.attach_xoff = attach_xoff;
        this.attach_yoff = attach_yoff;
    }

    public ParticleEffect(int ix, int iy, ImageObject[] so, Vector t, int number, Color c, double xdirection, double spread, double ydirection, int age, boolean infinite, int release) {
        super(ix, iy, so, t);
        this.number = number;
        this.release = release;
        this.spread = spread;
        this.heavy = false;
        this.c = c;
        this.xdirection = xdirection;
        this.ydirection = ydirection;
        this.age = age;
        this.infinite = infinite;
        this.particles = new Particle[number];
    }

    public boolean finished() {
        if (this.infinite) {
            return false;
        }
        return this.finished == this.number;
    }

    public Particle makeParticle() {
        double xdr = Math.random() * this.xdirection + Math.random() * this.spread * 2.0 - this.spread;
        double ydr = Math.random() * this.ydirection + Math.random() * this.spread * 2.0 - this.spread;
        double ax = this.x;
        double ay = this.y;
        if (this.attach != null) {
            ax = this.attach.getX() + (double)this.attach_xoff;
            ay = this.attach.getY() + (double)this.attach_yoff;
        }
        return new Particle(ax, ay, xdr, ydr);
    }

    public void makeParticles() {
        if (this.created < this.number) {
            int made = 0;
            while (this.created < this.number && made < this.release) {
                ++made;
                this.particles[this.created] = this.makeParticle();
                ++this.created;
            }
        }
    }

    public void drawBigShape(Graphics g, boolean highLight) {
        g.setColor(this.c);
        for (int i = 0; i < this.particles.length; ++i) {
            if (this.particles[i] == null || this.particles[i].getAge() >= this.age) continue;
            this.particles[i].draw(g);
        }
    }

    public void advance() {
        this.makeParticles();
        for (int i = 0; i < this.particles.length; ++i) {
            if (this.particles[i] == null) continue;
            if (this.particles[i].getAge() < this.age) {
                this.particles[i].move();
                continue;
            }
            if (this.infinite) {
                this.particles[i] = this.makeParticle();
                continue;
            }
            ++this.finished;
            this.particles[i] = null;
        }
        if (this.finished()) {
            this.torpedos.remove(this);
        }
    }

    public class Particle {
        private double x;
        private double y;
        private double xdirection;
        private double ydirection;
        private int age = 0;

        public Particle(double x, double y, double xdirection, double ydirection) {
            this.x = x;
            this.y = y;
            this.xdirection = xdirection;
            this.ydirection = ydirection;
        }

        public void move() {
            this.x += this.xdirection;
            this.y += this.ydirection;
            ++this.age;
        }

        public int getAge() {
            return this.age;
        }

        public void draw(Graphics g) {
            g.drawRect((int)this.x, (int)this.y, 1, 1);
        }
    }
}

