/*
 * Decompiled with CFR 0.152.
 */
package rescue.spaceobjects;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Vector;
import rescue.IndicatorsListener;
import rescue.JukeBox;
import rescue.RunRescue;
import rescue.spaceobjects.Base;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.MannedObject;

public class Ship
extends MannedObject {
    protected int systemWarpDrive = 0;
    protected int systemImpulseDrive = 0;
    protected boolean jump;
    protected boolean turn;
    protected Point autoImpulse;
    protected Point autoWarp;
    protected double manualImpulse = 0.0;
    protected double manualWarp = 0.0;
    protected int impulseSpeed;
    protected int warpSpeed;
    protected int speed = 0;
    protected double direction = 0.0;
    protected boolean autoImpulseOn = true;
    protected boolean autoWarpOn = true;
    protected boolean impulseOn = false;
    protected boolean warpOn = false;
    protected boolean stop = true;
    private int counter = 0;
    private int warpWormUpTime = 50;
    private int warpTurnSpeed = 25;
    protected MannedObject owner;
    protected int warpFactor;
    protected double impulseFactor;
    protected int evasive;
    protected boolean player;
    protected int systemLongRangeScan = 0;
    protected int systemSensorScan = 0;
    private int INFOmax_warp;
    private double INFOmax_impulse;
    private int SensorScan;
    private int fixPriority = 0;
    private IndicatorsListener indicatorsListener;
    private boolean leftright;
    private int shootcounter = 0;

    public Ship(int num, String t, String n, int ix, int iy, ImageObject[] so, BufferedImage a, BufferedImage b, BufferedImage c, BufferedImage d, Vector z) {
        super(num, t, n, ix, iy, so, a, b, c, d, z);
    }

    public void setOwner(MannedObject a) {
        this.owner = a;
    }

    public void adjustSpeed(int distance, int neededSpeed, double angle) {
        if (angle != this.direction && this.speed < 100 && this.speed > 0 && !Double.isNaN(angle)) {
            if (this.turn) {
                double t = RunRescue.getTurn(angle, this.direction);
                double turnShip = Math.toRadians((double)(t > 0.0 ? 30 : -30) * (1.0 / ((double)this.speed * 3.0)));
                if (turnShip > 0.0 && turnShip > t || turnShip < 0.0 && turnShip < t) {
                    turnShip = t;
                }
                this.direction += turnShip;
                if (this.direction < 0.0) {
                    this.direction += Math.toRadians(360.0);
                } else if (this.direction >= Math.toRadians(360.0)) {
                    this.direction -= Math.toRadians(360.0);
                }
            } else {
                this.direction = angle;
            }
        }
        if (!this.stop && this.jump && this.warpOn && distance < this.speed) {
            this.stop = true;
        } else if (!(this.stop || this.jump && !this.impulseOn || distance >= Math.max(this.speed * this.speed / 2, 1))) {
            this.stop = true;
        }
        if (this.stop && this.speed > 0) {
            if (this.warpOn && this.jump) {
                this.speed = 1;
                this.counter = 0;
            }
            --this.speed;
        } else if ((this.direction - angle > Math.toRadians(5.0) || this.direction - angle < Math.toRadians(-5.0)) && (this.impulseOn && this.speed > 1 || this.warpOn && this.speed > this.warpTurnSpeed)) {
            if (this.warpOn && this.jump) {
                this.speed = this.warpTurnSpeed + 1;
            }
            --this.speed;
        } else if (this.speed > neededSpeed) {
            this.speed = this.warpOn && this.jump ? neededSpeed : --this.speed;
        } else if (!this.stop && this.speed < neededSpeed) {
            if (this.warpOn && this.jump) {
                if (this.counter < this.warpWormUpTime) {
                    ++this.counter;
                    ++this.speed;
                } else if ((int)(this.direction * 1000.0) == (int)(angle * 1000.0)) {
                    this.speed = neededSpeed;
                }
            } else {
                ++this.speed;
            }
        }
        if (this.stop && this.speed == 0 && this.impulseOn) {
            this.impulseOn = false;
            this.changeEvasiveAndFireIndicatorUpdate(0);
            if (this.player) {
                JukeBox.stop("background");
            }
        } else if (this.stop && this.speed == 0 && this.warpOn) {
            this.warpOn = false;
            if (this.player) {
                JukeBox.stop("background");
            }
        }
    }

    public int getSpeed() {
        return this.speed;
    }

    public void advanceShipLocation() {
        int eneeded;
        int n = eneeded = this.impulseOn ? (int)(this.impulseFactor * 4.0) : this.warpFactor * (this.warpFactor - 1) / 2 + 3;
        if (this.owner != null) {
            int a = (int)this.distance(this.owner);
            if (a > 250 || this.owner.getSystem(10) != 0) {
                this.owner.TractorShip(null);
            } else if (this.owner instanceof Ship && ((Ship)this.owner).getSpeed() > 0) {
                Point p = ((Ship)this.owner).moveTo();
                this.translate(p.x, p.y);
            } else if (a > 0) {
                this.autoImpulse = this.owner;
                this.autoImpulseOn = true;
                this.impulseOn = true;
                this.stop = false;
                this.adjustSpeed(a, 1, this.getAngle(this.owner));
                Point p = this.moveTo();
                this.translate(p.x, p.y);
            }
        } else if (this.impulseOn) {
            if ((this.totalEnergy <= eneeded || this.systemImpulseDrive != 0 || !this.alive) && this.alive) {
                this.stop = true;
            }
            if (this.evasive == 1) {
                this.adjustSpeed(1000000, this.impulseSpeed, this.direction + Math.toRadians(1.0));
            } else if (this.evasive == 2) {
                if (this.autoImpulse == null) {
                    this.autoImpulse = new Point(this.x + 50, this.y + 50);
                }
                if (this.distance(this.autoImpulse) > 500.0) {
                    this.manualImpulse = this.getAngle(this.autoImpulse) + Math.toRadians(10.0);
                    if (this.manualImpulse > Math.toRadians(360.0)) {
                        this.manualImpulse -= Math.toRadians(360.0);
                    }
                }
                this.adjustSpeed(1000000, this.impulseSpeed, this.manualImpulse);
            } else if (this.evasive == 3) {
                int diz = (int)Math.round(Math.toDegrees(this.direction));
                if (diz == 0 || diz == 90 || diz == 180 || diz == 270 || diz == 360) {
                    boolean bl = this.leftright = Math.random() < 0.5;
                }
                if (this.leftright) {
                    this.adjustSpeed(1000000, this.impulseSpeed, this.direction + Math.toRadians(-1.0));
                } else {
                    this.adjustSpeed(1000000, this.impulseSpeed, this.direction + Math.toRadians(1.0));
                }
            } else if (this.autoImpulseOn) {
                this.adjustSpeed((int)this.distance(this.autoImpulse), this.impulseSpeed, this.getAngle(this.autoImpulse));
            } else {
                this.adjustSpeed(1000000, this.impulseSpeed, this.manualImpulse);
            }
            Point p = this.moveTo();
            this.translate(p.x, p.y);
            if (!this.stop && this.alive) {
                this.totalEnergy -= eneeded;
            }
        } else if (this.warpOn) {
            if (this.totalEnergy <= eneeded || this.systemWarpDrive != 0 || !this.alive) {
                this.stop = true;
            }
            if (this.autoWarpOn) {
                this.adjustSpeed((int)this.distance(this.autoWarp), this.warpSpeed, this.getAngle(this.autoWarp));
            } else {
                this.adjustSpeed(1000000, this.warpSpeed, this.manualWarp);
            }
            Point p = this.moveTo();
            this.translate(p.x, p.y);
            if (!this.stop) {
                this.totalEnergy -= eneeded;
            }
        }
    }

    public Point moveTo() {
        return new Point((int)Math.round((double)this.speed * Math.sin(this.direction)), -((int)Math.round((double)this.speed * Math.cos(this.direction))));
    }

    public void fixSystems() {
        int fix;
        if (this.fixPriority == 0 || this.fixPriority != 0 && this.getSystem(this.fixPriority) == 0) {
            int[] tmp = new int[10];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = this.getSystem(i + 1);
            }
            int low = tmp[0];
            int lowi = 0;
            for (int i = 1; i < tmp.length; ++i) {
                if (tmp[i] >= low) continue;
                low = tmp[i];
                lowi = i;
            }
            fix = lowi + 1;
        } else {
            fix = this.fixPriority;
        }
        if (this.getSystem(fix) < 0) {
            this.fixSystem(fix);
        }
    }

    public void fixSystem(int fix) {
        if (fix == 1) {
            ++this.systemWarpDrive;
            return;
        }
        if (fix == 2) {
            ++this.systemImpulseDrive;
            return;
        }
        if (fix == 3) {
            ++this.systemPhaserBanks;
            return;
        }
        if (fix == 4) {
            ++this.systemTorpedoTubes;
            return;
        }
        if (fix == 5) {
            ++this.systemLongRangeScan;
            return;
        }
        if (fix == 6) {
            ++this.systemSensorScan;
            return;
        }
        if (fix == 7) {
            ++this.systemShields;
            return;
        }
        if (fix == 8) {
            ++this.systemComputer;
            return;
        }
        if (fix == 9) {
            ++this.systemTransporters;
            return;
        }
        if (fix == 10) {
            ++this.systemTractorBeam;
            return;
        }
        System.out.print("ERROR, asked to fix system " + fix + "\n");
    }

    public String getSystemText(int sys) {
        int a = this.getSystem(sys);
        if (a == 0) {
            return "OK";
        }
        return -a + " rpr";
    }

    public int shipGetSystem(int sys) {
        if (sys == 1) {
            return this.systemWarpDrive;
        }
        if (sys == 2) {
            return this.systemImpulseDrive;
        }
        if (sys == 5) {
            return this.systemLongRangeScan;
        }
        if (sys == 6) {
            return this.systemSensorScan;
        }
        return 100;
    }

    public void setPlayer(boolean a, IndicatorsListener il) {
        this.player = a;
        this.indicatorsListener = il;
    }

    public void setInfo(int a, double b, int c, int d) {
        this.INFOmax_warp = a;
        this.INFOmax_impulse = b;
        this.jump = c == 1;
        this.turn = d == 1;
        this.warpFactor = this.INFOmax_warp;
        this.impulseFactor = this.INFOmax_impulse;
        this.warpSpeed = (int)(10.0 * Math.pow(this.warpFactor, 3.3333333333333335));
        this.impulseSpeed = (int)(10.0 * this.impulseFactor);
    }

    public int shipDamage(int hitlocation, int damage) {
        if (hitlocation == 1) {
            this.systemWarpDrive -= damage;
            if (this.systemWarpDrive < -10) {
                damage -= this.systemWarpDrive + 10;
                this.systemWarpDrive = -10;
            }
        } else if (hitlocation == 2) {
            this.systemImpulseDrive -= damage;
            if (this.systemImpulseDrive < -10) {
                damage -= this.systemImpulseDrive + 10;
                this.systemImpulseDrive = -10;
            }
        } else if (hitlocation == 5) {
            this.systemLongRangeScan -= damage;
            if (this.systemLongRangeScan < -10) {
                damage -= this.systemLongRangeScan + 10;
                this.systemLongRangeScan = -10;
            }
        } else if (hitlocation == 6) {
            this.systemSensorScan -= damage;
            if (this.systemSensorScan < -10) {
                damage -= this.systemSensorScan + 10;
                this.systemSensorScan = -10;
            }
        }
        return damage;
    }

    public int shipGetLifeInfo() {
        return this.systemWarpDrive + this.systemImpulseDrive + this.systemLongRangeScan + this.systemSensorScan;
    }

    public void drawBigShape(Graphics g, boolean highLight) {
        if (this.player && this.autoImpulse != null) {
            g.setColor(Color.WHITE);
            g.drawLine(this.autoImpulse.x + 2, this.autoImpulse.y + 2, this.autoImpulse.x - 2, this.autoImpulse.y - 2);
            g.drawLine(this.autoImpulse.x + 2, this.autoImpulse.y - 2, this.autoImpulse.x - 2, this.autoImpulse.y + 2);
        }
        if (this.alive) {
            if (this.turn) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.rotate(this.direction, this.x, this.y);
                g2.drawImage((Image)this.image, this.x - this.image.getWidth() / 2, this.y - this.image.getHeight() / 2, null);
            } else {
                g.drawImage(this.image, this.x - this.image.getWidth() / 2, this.y - this.image.getHeight() / 2, null);
            }
        }
        super.drawBigShape(g, highLight);
    }

    public void drawSmallShape(Graphics g, double sx, double sy, int scan) {
        if (this.player) {
            g.setColor(Color.DARK_GRAY);
            g.drawOval((int)((double)this.x * sx) - 4, (int)((double)this.y * sy) - 4, 8, 8);
            if (this.autoWarp != null) {
                g.setColor(Color.WHITE);
                g.drawLine((int)((double)this.autoWarp.x * sx) + 1, (int)((double)this.autoWarp.y * sy) + 1, (int)((double)this.autoWarp.x * sx) - 1, (int)((double)this.autoWarp.y * sy) - 1);
                g.drawLine((int)((double)this.autoWarp.x * sx) + 1, (int)((double)this.autoWarp.y * sy) - 1, (int)((double)this.autoWarp.x * sx) - 1, (int)((double)this.autoWarp.y * sy) + 1);
            }
        }
        super.drawSmallShape(g, sx, sy, scan);
    }

    public void stop() {
        this.stop = true;
    }

    public void setEvasive(int a) {
        if (!this.warpOn) {
            this.changeEvasiveAndFireIndicatorUpdate(a);
            this.impulseOn = true;
            this.stop = false;
        }
    }

    public int getEvasive() {
        return this.evasive;
    }

    public void useReserve() {
        int needed = this.INFOmax_totalenergy - this.totalEnergy;
        if (needed >= this.reserve) {
            this.totalEnergy += this.reserve;
            this.reserve = 0;
        } else {
            this.totalEnergy += needed;
            this.reserve -= needed;
        }
    }

    public void divertPhaser() {
        int needed = this.INFOmax_totalenergy - this.totalEnergy;
        if (needed >= this.phaserBanks) {
            this.totalEnergy += this.phaserBanks;
            this.phaserBanks = 0;
        } else {
            this.totalEnergy += needed;
            this.phaserBanks -= needed;
        }
    }

    public void setFixPriority(int a) {
        this.fixPriority = a;
    }

    public void setScan(boolean a) {
        if (a && this.SensorScan < this.getMaxScan()) {
            ++this.SensorScan;
            return;
        }
        if (!a && this.SensorScan > 0) {
            --this.SensorScan;
            return;
        }
    }

    public int getMaxScan() {
        return 3;
    }

    public void sendPeople(Ship a) {
        a.addPeople(this.people);
        this.people = 0;
    }

    public void shipDockWith(MannedObject base) {
        this.totalEnergy += base.getEnergy(this.INFOmax_totalenergy - this.totalEnergy);
        this.phaserBanks += base.getPhaser(this.INFOmax_phaserbanks - this.phaserBanks);
        this.torpedosLeft += base.getTorpedos(this.INFOmax_torpedosleft - this.torpedosLeft);
        if (base instanceof Base) {
            base.addPeople(this.people);
            this.people = 0;
            this.shieldPower = this.INFOmax_shieldsPower;
            for (int a = 0; this.checkFixNeeded() && a < 10; ++a) {
                this.fixSystems();
            }
        }
    }

    public void setTarget(int a) {
        this.target = a;
    }

    public void changeShields() {
        this.ShieldsUp = !this.ShieldsUp;
    }

    public void setAutoImpulse(Point p) {
        if (!this.warpOn) {
            this.autoImpulse = p;
            this.autoImpulseOn = true;
            this.changeEvasiveAndFireIndicatorUpdate(0);
        }
    }

    public void setAutoWarp(Point p) {
        this.autoWarp = p;
        this.autoWarpOn = true;
        this.changeEvasiveAndFireIndicatorUpdate(0);
    }

    public void setManImpulse(double z) {
        this.manualImpulse = z;
        this.changeEvasiveAndFireIndicatorUpdate(0);
    }

    public void setManWarp(double z) {
        this.manualWarp = z;
        this.changeEvasiveAndFireIndicatorUpdate(0);
    }

    private void changeEvasiveAndFireIndicatorUpdate(int e) {
        this.evasive = e;
        if (this.indicatorsListener != null) {
            this.indicatorsListener.updateEvasiveIndicators(this.evasive);
        }
    }

    public void setAutoImpulseOn(boolean a) {
        if (a && this.impulseOn && this.autoImpulse == null) {
            return;
        }
        this.autoImpulseOn = a;
    }

    public void setAutoWarpOn(boolean a) {
        if (a && this.warpOn && this.autoWarp == null) {
            return;
        }
        this.autoWarpOn = a;
    }

    public void setImpulseFactor(int a) {
        if ((double)a / 4.0 <= this.INFOmax_impulse) {
            this.impulseFactor = (double)a / 4.0;
            this.impulseSpeed = (int)(10.0 * this.impulseFactor);
        }
    }

    public void setImpulseUpDown(boolean up) {
        if (up && this.impulseFactor == this.INFOmax_impulse || !up && this.impulseFactor == 0.25) {
            return;
        }
        this.impulseFactor = up ? (this.impulseFactor += 0.25) : (this.impulseFactor -= 0.25);
        this.impulseSpeed = (int)(10.0 * this.impulseFactor);
    }

    public double getMaxImpulseFactor() {
        return this.INFOmax_impulse;
    }

    public void setWarpFactor(int a) {
        if (a <= this.INFOmax_warp) {
            this.warpFactor = a;
            this.warpSpeed = (int)(10.0 * Math.pow(this.warpFactor, 3.3333333333333335));
        }
    }

    public void setWarpUpDown(boolean up) {
        if (up && this.warpFactor == this.INFOmax_warp || !up && this.warpFactor == 1) {
            return;
        }
        this.warpFactor = up ? ++this.warpFactor : --this.warpFactor;
        this.warpSpeed = (int)(10.0 * Math.pow(this.warpFactor, 3.3333333333333335));
    }

    public int getMaxWarpFactor() {
        return this.INFOmax_warp;
    }

    public void setTorpedoSalvo(int a) {
        if (a <= this.INFOmax_torpedoSalvo) {
            this.TorpedoSalvo = a;
        }
    }

    public void setTorpedoSalvoUpDown(boolean up) {
        if (up && this.TorpedoSalvo < this.INFOmax_torpedoSalvo) {
            ++this.TorpedoSalvo;
        } else if (!up && this.TorpedoSalvo > 1) {
            --this.TorpedoSalvo;
        }
    }

    public int getMaxTorpedoSalvo() {
        return this.INFOmax_torpedoSalvo;
    }

    public void setPhaserIntensity(int a) {
        if (a <= this.INFOmax_phaserIntensity) {
            this.phaserIntensity = a;
        }
    }

    public void setPhaserIntensityUpDown(boolean up) {
        if (up && this.phaserIntensity < this.INFOmax_phaserIntensity) {
            ++this.phaserIntensity;
        } else if (!up && this.phaserIntensity > 1) {
            --this.phaserIntensity;
        }
    }

    public int getMaxPhaserIntensity() {
        return this.INFOmax_phaserIntensity;
    }

    public void setImpulseOn(boolean a) {
        if (a) {
            if (!(this.warpOn || this.autoImpulseOn && this.autoImpulse == null)) {
                this.impulseOn = true;
                this.stop = false;
                JukeBox.play("background");
            }
        } else if (this.impulseOn) {
            this.stop = true;
        }
    }

    public void setWarpOn(boolean a) {
        if (a) {
            if (!this.autoWarpOn || this.autoWarp != null) {
                this.impulseOn = false;
                this.warpOn = true;
                this.stop = false;
                JukeBox.play("background");
            }
        } else if (this.warpOn) {
            this.stop = true;
        }
    }

    public int getCondition() {
        if (this.getLifeInfo() != 0 || this.shieldPower != this.INFOmax_shieldsPower) {
            return 3;
        }
        int j = 1000;
        int k = this.SpaceObjects.length - 1;
        for (int i = 0; i < k; ++i) {
            if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).isAlive() || !(this.distance(this.SpaceObjects[i]) < (double)j) || this.SpaceObjectsLikes[i] >= 0) continue;
            return 2;
        }
        return 1;
    }

    public int getManImpulse() {
        return (int)Math.round(Math.toDegrees(this.manualImpulse));
    }

    public int getManWarp() {
        return (int)Math.round(Math.toDegrees(this.manualWarp));
    }

    public int getFixPriority() {
        return this.fixPriority;
    }

    public String getScan() {
        if (this.systemSensorScan == 0) {
            if (this.SensorScan == 0) {
                return "OFF";
            }
            if (this.SensorScan == 1) {
                return "MIN";
            }
            if (this.SensorScan == 2) {
                return "MED";
            }
            if (this.SensorScan == 3) {
                return "MAX";
            }
            return this.SensorScan + "";
        }
        return "XXX";
    }

    public int getSensorScan() {
        if (this.systemSensorScan == 0) {
            return this.SensorScan;
        }
        return 0;
    }

    public Ship getTractoredShip() {
        return this.tractoredShip;
    }

    public int getNoColonies() {
        return this.people;
    }

    public int getTarget() {
        return this.target;
    }

    public boolean getShieldsUp() {
        return this.ShieldsUp;
    }

    public double getSpeedMofC() {
        return (double)this.speed / 10.0;
    }

    public double getDirection() {
        return this.direction;
    }

    public Point getAutoImpulse() {
        return this.autoImpulse;
    }

    public Point getAutoWarp() {
        return this.autoWarp;
    }

    public boolean getAutoImpulseOn() {
        return this.autoImpulseOn;
    }

    public boolean getAutoWarpOn() {
        return this.autoWarpOn;
    }

    public String getImpulseSpeed() {
        if (this.systemImpulseDrive == 0) {
            if (this.impulseFactor == 0.25) {
                return "1/4";
            }
            if (this.impulseFactor == 0.5) {
                return "1/2";
            }
            if (this.impulseFactor == 0.75) {
                return "3/4";
            }
            if (this.impulseFactor == 1.0) {
                return "MAX";
            }
            return this.impulseFactor + "";
        }
        return "XXX";
    }

    public String getWarpSpeed() {
        if (this.systemWarpDrive == 0) {
            return this.warpFactor + "";
        }
        return "XXX";
    }

    public int getWarpFactor() {
        return this.warpFactor;
    }

    public double getImpulseFactor() {
        return this.impulseFactor;
    }

    public boolean getImpulseOn() {
        return this.impulseOn;
    }

    public boolean getWarpOn() {
        return this.warpOn;
    }

    public String getTorpedoSalvo() {
        if (this.systemTorpedoTubes == 0) {
            return this.TorpedoSalvo + "";
        }
        return "XXX";
    }

    public String getPhaserIntensity() {
        if (this.systemPhaserBanks == 0) {
            if (this.phaserIntensity == 1) {
                return "MIN";
            }
            if (this.phaserIntensity == 2) {
                return "MED";
            }
            if (this.phaserIntensity == 3) {
                return "MAX";
            }
            return this.phaserIntensity + "";
        }
        return "XXX";
    }

    public int getPhaserIntensityInt() {
        return this.phaserIntensity;
    }

    public int getTorpedoSalvoInt() {
        return this.TorpedoSalvo;
    }

    public int tractorEnergyUsed(int nrg) {
        if (this.SpaceObjectsLikes[this.owner.getNumber()] > 0 || this.systemImpulseDrive != 0) {
            return 10;
        }
        int a = (int)((double)(nrg - 10) * (this.distance(this.owner) / 250.0));
        if (this.totalEnergy < a) {
            return 10;
        }
        this.totalEnergy -= a;
        return a += 10;
    }

    public void advance() {
        if (this.alive && !this.player) {
            MannedObject thehated = null;
            int hate = 0;
            int dis = 1000000000;
            int tmp = 0;
            for (int i = 0; i < this.SpaceObjectsLikes.length; ++i) {
                tmp = this.SpaceObjectsLikes[i];
                if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).isAlive() || tmp >= hate && (tmp >= 0 || tmp > hate || (int)this.distance(this.SpaceObjects[i]) >= dis)) continue;
                hate = this.SpaceObjectsLikes[i];
                thehated = (MannedObject)this.SpaceObjects[i];
                dis = (int)this.distance(thehated);
            }
            if (thehated != null) {
                if (dis > 1000) {
                    if (this.impulseOn) {
                        this.impulseOn = false;
                    }
                    this.autoWarp = thehated;
                    this.warpOn = true;
                    this.stop = false;
                } else if (dis > 500) {
                    if (this.warpOn) {
                        this.stop = true;
                    } else {
                        this.autoImpulse = thehated;
                        this.autoImpulseOn = true;
                        this.impulseOn = true;
                        this.stop = false;
                    }
                } else {
                    if (this.autoImpulseOn) {
                        this.manualImpulse = this.getAngle(thehated) + Math.toRadians(10.0);
                        if (this.manualImpulse > Math.toRadians(360.0)) {
                            this.manualImpulse -= Math.toRadians(360.0);
                        }
                        this.autoImpulseOn = false;
                        this.impulseOn = true;
                        this.stop = false;
                    }
                    if (this.shootcounter == 0 && dis <= 500 && dis > 250) {
                        this.FireTorpedo(thehated);
                        ++this.shootcounter;
                    } else if (this.shootcounter == 0 && dis <= 250) {
                        this.FirePhaser(thehated);
                        ++this.shootcounter;
                    }
                    if (this.shootcounter != 0) {
                        ++this.shootcounter;
                    }
                    if (this.shootcounter == 100) {
                        this.shootcounter = 0;
                    }
                }
            } else {
                this.stop = true;
            }
        } else if (!this.alive && this.impulseOn && this.autoImpulseOn) {
            this.manualImpulse = this.direction;
            this.autoImpulseOn = false;
        }
        this.advanceShipLocation();
        super.advance();
    }
}

