/*
 * Decompiled with CFR 0.152.
 */
package solarex.galaxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;

public class SystemLocation {
    public int galacticSectorI;
    public int galacticSectorJ;
    public int systemNumber;
    public int ioff;
    public int joff;
    public long systemSeed;
    public String name = "unknown";

    public double distance(SystemLocation there) {
        int x1 = this.galacticSectorI * 128 + this.ioff;
        int y1 = this.galacticSectorJ * 128 + this.joff;
        int x2 = there.galacticSectorI * 128 + there.ioff;
        int y2 = there.galacticSectorJ * 128 + there.joff;
        double sectorDistance = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        sectorDistance = sectorDistance * 10.0 / 128.0;
        System.err.println("distance=" + sectorDistance);
        return sectorDistance;
    }

    public void save(Writer writer) throws IOException {
        writer.write("<Location>\n");
        writer.write("<version>2</version>\n");
        writer.write("<gs_i>" + this.galacticSectorI + "</gs_i>\n");
        writer.write("<gs_j>" + this.galacticSectorJ + "</gs_j>\n");
        writer.write("<ioff>" + this.ioff + "</ioff>\n");
        writer.write("<joff>" + this.joff + "</joff>\n");
        writer.write("<sysn>" + this.systemNumber + "</sysn>\n");
        writer.write("<seed>" + this.systemSeed + "</seed>\n");
        writer.write("<name>" + this.name + "</name>\n");
        writer.write("</Location>\n");
    }

    public void load(BufferedReader reader) throws IOException {
        reader.readLine();
        reader.readLine();
        String tmp = reader.readLine();
        this.galacticSectorI = Integer.parseInt(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.galacticSectorJ = Integer.parseInt(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.ioff = Integer.parseInt(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.joff = Integer.parseInt(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.systemNumber = Integer.parseInt(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.systemSeed = Long.parseLong(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.name = tmp.substring(6, tmp.length() - 7);
        reader.readLine();
    }

    public boolean equals(Object other) {
        if (other instanceof SystemLocation) {
            SystemLocation loca = (SystemLocation)other;
            return loca.systemSeed == this.systemSeed && loca.systemNumber == this.systemNumber;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + this.galacticSectorI;
        hash = 59 * hash + this.galacticSectorJ;
        hash = 59 * hash + this.systemNumber;
        hash = 59 * hash + (int)(this.systemSeed ^ this.systemSeed >>> 32);
        hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }
}

