/*
 * Decompiled with CFR 0.152.
 */
package solarex.ship;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import solarex.galaxy.Galaxy;
import solarex.galaxy.SystemLocation;
import solarex.ship.Cargo;
import solarex.ship.Player;
import solarex.ship.components.EquipmentFactory;
import solarex.ship.components.ShipAssembly;
import solarex.ship.components.ShipComponent;
import solarex.system.Solar;
import solarex.system.Vec3;
import solarex.ui.observables.ObservableString;

public class Ship {
    private State state;
    public ObservableString stateString = new ObservableString();
    public long spaceBodySeed;
    public SystemLocation loca;
    public SystemLocation hyperjumpDestination;
    public int totalSpace = 15;
    public Vec3 position;
    public Vec3 destination;
    public Cargo cargo;
    public int totalWeight = 65;
    public int equipmentSpace = 20;
    public ShipAssembly equipment;
    public Player player;

    public Ship() {
        this.setState(State.FLIGHT);
        this.position = new Vec3();
        this.destination = new Vec3();
        this.cargo = new Cargo();
        this.equipment = new ShipAssembly();
        this.player = new Player();
        this.position.x = 2.0E8;
        this.position.y = 0.0;
        this.destination.x = 1.9999E8;
        this.destination.y = 0.0;
        EquipmentFactory factory = new EquipmentFactory();
        ShipComponent drive = factory.create(EquipmentFactory.Component.STANDARD_DRIVE);
        this.equipment.addComponent(drive);
        this.recalculateCargoSpace();
    }

    public String getStateString() {
        return this.getState().toString();
    }

    public final void recalculateCargoSpace() {
        this.cargo.space = (this.equipmentSpace - this.equipment.getWeight()) * 1000;
    }

    public void save(Writer writer) throws IOException {
        writer.write("<?xml version='1.0' encoding='UTF-8'?>\n");
        writer.write("<Solarexsave>\n");
        writer.write("<Ship>\n");
        writer.write("<version>2</version>\n");
        writer.write("<capa>" + this.totalSpace + "</capa>\n");
        writer.write("<posx>" + this.position.x + "</posx>\n");
        writer.write("<posy>" + this.position.y + "</posy>\n");
        writer.write("<posz>" + this.position.z + "</posz>\n");
        writer.write("<dstx>" + this.destination.x + "</dstx>\n");
        writer.write("<dsty>" + this.destination.y + "</dsty>\n");
        writer.write("<dstz>" + this.destination.z + "</dstz>\n");
        writer.write("<stat>" + this.getState().name() + "</stat>\n");
        writer.write("<body>" + this.spaceBodySeed + "</body>\n");
        writer.write("</Ship>\n");
        this.loca.save(writer);
        this.cargo.save(writer);
        this.equipment.save(writer);
        this.player.save(writer);
        writer.write("</Solarexsave>\n");
    }

    public void load(BufferedReader reader) throws IOException {
        reader.readLine();
        reader.readLine();
        reader.readLine();
        reader.readLine();
        String tmp = reader.readLine();
        this.totalSpace = Integer.parseInt(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.position.x = Double.parseDouble(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.position.y = Double.parseDouble(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.position.z = Double.parseDouble(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.destination.x = Double.parseDouble(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.destination.y = Double.parseDouble(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.destination.z = Double.parseDouble(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        State stateNew = State.valueOf(tmp.substring(6, tmp.length() - 7));
        tmp = reader.readLine();
        this.spaceBodySeed = Long.parseLong(tmp.substring(6, tmp.length() - 7));
        reader.readLine();
        this.loca.load(reader);
        this.cargo.load(reader);
        this.equipment.load(reader);
        this.player.load(reader);
        this.setState(stateNew);
        this.recalculateCargoSpace();
    }

    public State getState() {
        return this.state;
    }

    public final void setState(State state) {
        this.state = state;
        this.stateString.setValue(state.toString());
    }

    public void arrive(Galaxy galaxy, Solar destination) {
        this.player.setExplored(destination, 0);
        if (destination.btype == Solar.BodyType.PLANET) {
            this.spaceBodySeed = destination.seed;
            this.loca.name = destination.name;
            this.setState(State.ORBIT);
            this.position = destination.getAbsolutePosition();
            this.position.x += (double)destination.radius * 2.0;
            this.destination.set(this.position);
        } else if (destination.btype == Solar.BodyType.STATION || destination.btype == Solar.BodyType.SPACEPORT) {
            this.spaceBodySeed = destination.seed;
            this.loca.name = destination.name;
            this.setState(State.DOCKED);
            this.position = destination.getAbsolutePosition();
            this.destination.set(this.position);
        }
        if (this.player != null) {
            this.player.testQuests(galaxy, destination, this);
        }
    }

    public void depart() {
        this.setState(State.FLIGHT);
    }

    public static enum State {
        FLIGHT("Flight"),
        ORBIT("Orbit"),
        DOCKED("Docked");

        private String label;

        private State(String s) {
            this.label = s;
        }

        public String toString() {
            return this.label;
        }
    }
}

