/*
 * Decompiled with CFR 0.152.
 */
package solarex.ship.components;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import solarex.ship.components.EquipmentFactory;
import solarex.ship.components.EquipmentType;
import solarex.ship.components.ShipComponent;

public class ShipAssembly
implements ShipComponent {
    public final ArrayList<ShipComponent> components = new ArrayList();

    @Override
    public EquipmentType getType() {
        return EquipmentType.OTHER;
    }

    @Override
    public String getName() {
        return "Ship";
    }

    @Override
    public int getWeight() {
        int sum = 0;
        for (ShipComponent component : this.components) {
            sum += component.getWeight();
        }
        return sum;
    }

    @Override
    public int getCargoCapacity() {
        int sum = 0;
        for (ShipComponent component : this.components) {
            sum += component.getCargoCapacity();
        }
        return sum;
    }

    @Override
    public int getPassengerCapacity() {
        int sum = 0;
        for (ShipComponent component : this.components) {
            sum += component.getPassengerCapacity();
        }
        return sum;
    }

    @Override
    public int getHyperjumpRange() {
        int sum = 0;
        for (ShipComponent component : this.components) {
            sum += component.getHyperjumpRange();
        }
        return sum;
    }

    @Override
    public String getKey() {
        return "ShipAssembly";
    }

    @Override
    public int getBasePrice() {
        int sum = 0;
        for (ShipComponent component : this.components) {
            sum += component.getBasePrice();
        }
        return sum;
    }

    @Override
    public int getMinOperatingTemp() {
        return 0;
    }

    @Override
    public int getMaxOperatingTemp() {
        return 0;
    }

    public void addComponent(ShipComponent comp) {
        this.components.add(comp);
    }

    public void removeComponent(ShipComponent comp) {
        this.components.remove(comp);
    }

    public void save(Writer writer) throws IOException {
        writer.write("<Equipment>\n");
        writer.write("<version>1</version>\n");
        writer.write("<itms>" + this.components.size() + "</itms>\n");
        for (ShipComponent comp : this.components) {
            writer.write("<comp>" + comp.getKey() + "</comp>\n");
        }
        writer.write("</Equipment>\n");
    }

    public void load(BufferedReader reader) throws IOException {
        this.components.clear();
        reader.readLine();
        reader.readLine();
        String tmp = reader.readLine();
        int count = Integer.parseInt(tmp.substring(6, tmp.length() - 7));
        EquipmentFactory fab = new EquipmentFactory();
        for (int i = 0; i < count; ++i) {
            tmp = reader.readLine();
            String key = tmp.substring(6, tmp.length() - 7);
            EquipmentFactory.Component compKey = EquipmentFactory.Component.valueOf(key);
            this.components.add(fab.create(compKey));
        }
        reader.readLine();
    }
}

