/*
 * Decompiled with CFR 0.152.
 */
package solarex.system;

import java.util.Random;
import solarex.ship.Good;
import solarex.system.Society;
import solarex.system.Solar;
import solarex.util.RandomHelper;

public class PlanetResources {
    public static int metalToGood(int i) {
        int n = 0;
        Metals metal = Metals.values()[i];
        switch (metal) {
            case Bismuth: {
                n = Good.Type.HeavyMetals.ordinal();
                break;
            }
            case Chromium: {
                n = Good.Type.NonIronMetals.ordinal();
                break;
            }
            case Copper: {
                n = Good.Type.NonIronMetals.ordinal();
                break;
            }
            case Gold: {
                n = Good.Type.NobleMetals.ordinal();
                break;
            }
            case Indium: {
                n = Good.Type.NonIronMetals.ordinal();
                break;
            }
            case Iridium: {
                n = Good.Type.NonIronMetals.ordinal();
                break;
            }
            case Iron: {
                n = Good.Type.IronMetals.ordinal();
                break;
            }
            case Lead: {
                n = Good.Type.HeavyMetals.ordinal();
                break;
            }
            case Manganese: {
                n = Good.Type.NonIronMetals.ordinal();
                break;
            }
            case Mercury: {
                n = Good.Type.HeavyMetals.ordinal();
                break;
            }
            case Nickel: {
                n = Good.Type.NonIronMetals.ordinal();
                break;
            }
            case Osmium: {
                n = Good.Type.HeavyMetals.ordinal();
                break;
            }
            case Palladium: {
                n = Good.Type.NobleMetals.ordinal();
                break;
            }
            case Platinum: {
                n = Good.Type.NobleMetals.ordinal();
                break;
            }
            case Rhodium: {
                n = Good.Type.NobleMetals.ordinal();
                break;
            }
            case Ruthenium: {
                n = Good.Type.NobleMetals.ordinal();
                break;
            }
            case Silver: {
                n = Good.Type.NobleMetals.ordinal();
                break;
            }
            case Tellurium: {
                n = Good.Type.NonIronMetals.ordinal();
                break;
            }
            case Tin: {
                n = Good.Type.HeavyMetals.ordinal();
                break;
            }
            case Zinc: {
                n = Good.Type.NonIronMetals.ordinal();
            }
        }
        return n;
    }

    public static int gasToGood(int i) {
        int n = 0;
        Gases gas = Gases.values()[i];
        switch (gas) {
            case Ammonia: {
                n = Good.Type.Fertilizer.ordinal();
                break;
            }
            case Nitrogen: 
            case Oxygen: 
            case CarbonDioxide: {
                n = Good.Type.AtmoGases.ordinal();
                break;
            }
            case Helium: {
                n = Good.Type.InertGases.ordinal();
                break;
            }
            case Hydrogen: {
                n = Good.Type.LowFuel.ordinal();
                break;
            }
            case Methane: {
                n = Good.Type.Hydrocarbons.ordinal();
                break;
            }
            case WaterVapor: {
                n = Good.Type.Water.ordinal();
            }
        }
        return n;
    }

    public static int fluidToGood(int i) {
        int n = 0;
        Fluids fluid = Fluids.values()[i];
        switch (fluid) {
            case Ammonia: {
                n = Good.Type.Fertilizer.ordinal();
                break;
            }
            case Hydrocarbons: {
                n = Good.Type.Hydrocarbons.ordinal();
                break;
            }
            case Silicones: {
                n = Good.Type.Silicones.ordinal();
                break;
            }
            case SulfurDioxide: {
                n = Good.Type.AtmoGases.ordinal();
                break;
            }
            case Water: {
                n = Good.Type.Water.ordinal();
            }
        }
        return n;
    }

    public static boolean isRareEarth(int index) {
        return index == Minerals.Scandium.ordinal() || index == Minerals.Yttrium.ordinal() || index == Minerals.Lanthanum.ordinal() || index == Minerals.Cerium.ordinal() || index == Minerals.Praseodymium.ordinal() || index == Minerals.Neodymium.ordinal() || index == Minerals.Promethium.ordinal() || index == Minerals.Samarium.ordinal() || index == Minerals.Europium.ordinal() || index == Minerals.Gadolinium.ordinal() || index == Minerals.Terbium.ordinal() || index == Minerals.Dysprosium.ordinal() || index == Minerals.Holmium.ordinal() || index == Minerals.Erbium.ordinal() || index == Minerals.Thulium.ordinal() || index == Minerals.Ytterbium.ordinal() || index == Minerals.Lutetium.ordinal();
    }

    public static boolean isNobleMetal(int index) {
        return index == Metals.Gold.ordinal() || index == Metals.Platinum.ordinal() || index == Metals.Silver.ordinal() || index == Metals.Osmium.ordinal() || index == Metals.Palladium.ordinal() || index == Metals.Rhodium.ordinal() || index == Metals.Ruthenium.ordinal() || index == Metals.Iridium.ordinal();
    }

    public static boolean isNonIronMetal(int index) {
        return index == Metals.Bismuth.ordinal() || index == Metals.Chromium.ordinal() || index == Metals.Copper.ordinal() || index == Metals.Lead.ordinal() || index == Metals.Manganese.ordinal() || index == Metals.Mercury.ordinal() || index == Metals.Nickel.ordinal() || index == Metals.Tellurium.ordinal() || index == Metals.Indium.ordinal() || index == Metals.Tin.ordinal() || index == Metals.Zinc.ordinal();
    }

    public static boolean isHeavyMetal(int index) {
        return index == Metals.Bismuth.ordinal() || index == Metals.Chromium.ordinal() || index == Metals.Copper.ordinal() || index == Metals.Lead.ordinal() || index == Metals.Mercury.ordinal() || index == Metals.Nickel.ordinal() || index == Metals.Tin.ordinal();
    }

    public static void calculateMetals(Solar planet, Random rng, int[] deposits, long[] positions) {
        int i;
        switch (planet.ptype) {
            case BARE_ROCK: 
            case GRAPHITE_ROCK: {
                deposits[Metals.Chromium.ordinal()] = rng.nextInt(300) / 100;
                deposits[Metals.Copper.ordinal()] = rng.nextInt(400) / 100;
                deposits[Metals.Gold.ordinal()] = rng.nextInt(150) / 100;
                deposits[Metals.Lead.ordinal()] = rng.nextInt(300) / 100;
                deposits[Metals.Manganese.ordinal()] = rng.nextInt(400) / 100;
                deposits[Metals.Platinum.ordinal()] = rng.nextInt(150) / 100;
                deposits[Metals.Silver.ordinal()] = rng.nextInt(200) / 100;
                deposits[Metals.Tin.ordinal()] = rng.nextInt(300) / 100;
                deposits[Metals.Zinc.ordinal()] = rng.nextInt(300) / 100;
                deposits[Metals.Iron.ordinal()] = rng.nextInt(600) / 100;
                deposits[Metals.Nickel.ordinal()] = rng.nextInt(500) / 100;
                deposits[Metals.Mercury.ordinal()] = rng.nextInt(120) / 100;
                deposits[Metals.Iridium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Osmium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Palladium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Rhodium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Ruthenium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Bismuth.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Indium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Tellurium.ordinal()] = rng.nextInt(101) / 100;
                break;
            }
            case ATM_ROCK: {
                deposits[Metals.Chromium.ordinal()] = rng.nextInt(150) / 100;
                deposits[Metals.Copper.ordinal()] = rng.nextInt(250) / 100;
                deposits[Metals.Gold.ordinal()] = rng.nextInt(130) / 100;
                deposits[Metals.Lead.ordinal()] = rng.nextInt(201) / 100;
                deposits[Metals.Manganese.ordinal()] = rng.nextInt(330) / 100;
                deposits[Metals.Platinum.ordinal()] = rng.nextInt(150) / 100;
                deposits[Metals.Silver.ordinal()] = rng.nextInt(180) / 100;
                deposits[Metals.Tin.ordinal()] = rng.nextInt(210) / 100;
                deposits[Metals.Zinc.ordinal()] = rng.nextInt(210) / 100;
                deposits[Metals.Iron.ordinal()] = rng.nextInt(250) / 100;
                deposits[Metals.Nickel.ordinal()] = rng.nextInt(250) / 100;
                deposits[Metals.Mercury.ordinal()] = rng.nextInt(110) / 100;
                deposits[Metals.Iridium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Osmium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Palladium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Rhodium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Ruthenium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Bismuth.ordinal()] = rng.nextInt(103) / 100;
                deposits[Metals.Indium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Tellurium.ordinal()] = rng.nextInt(101) / 100;
                break;
            }
            case CLOUD: {
                deposits[Metals.Chromium.ordinal()] = rng.nextInt(110) / 100;
                deposits[Metals.Copper.ordinal()] = rng.nextInt(200) / 100;
                deposits[Metals.Gold.ordinal()] = rng.nextInt(150) / 100;
                deposits[Metals.Lead.ordinal()] = rng.nextInt(150) / 100;
                deposits[Metals.Manganese.ordinal()] = rng.nextInt(200) / 100;
                deposits[Metals.Platinum.ordinal()] = rng.nextInt(150) / 100;
                deposits[Metals.Silver.ordinal()] = rng.nextInt(170) / 100;
                deposits[Metals.Tin.ordinal()] = rng.nextInt(150) / 100;
                deposits[Metals.Zinc.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Iron.ordinal()] = rng.nextInt(110) / 100;
                deposits[Metals.Nickel.ordinal()] = rng.nextInt(110) / 100;
                deposits[Metals.Mercury.ordinal()] = rng.nextInt(105) / 100;
                deposits[Metals.Iridium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Osmium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Palladium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Rhodium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Ruthenium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Bismuth.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Indium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Tellurium.ordinal()] = rng.nextInt(101) / 100;
                break;
            }
            case EARTH: {
                deposits[Metals.Chromium.ordinal()] = 0;
                deposits[Metals.Copper.ordinal()] = rng.nextInt(12) / 5;
                deposits[Metals.Gold.ordinal()] = rng.nextInt(6) / 5;
                deposits[Metals.Lead.ordinal()] = rng.nextInt(12) / 5;
                deposits[Metals.Manganese.ordinal()] = rng.nextInt(6) / 5;
                deposits[Metals.Platinum.ordinal()] = rng.nextInt(6) / 5;
                deposits[Metals.Silver.ordinal()] = rng.nextInt(8) / 5;
                deposits[Metals.Tin.ordinal()] = rng.nextInt(12) / 5;
                deposits[Metals.Iridium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Osmium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Palladium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Rhodium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Ruthenium.ordinal()] = rng.nextInt(101) / 100;
                deposits[Metals.Bismuth.ordinal()] = rng.nextInt(101) / 100;
                break;
            }
            case ICE: {
                deposits[Metals.Chromium.ordinal()] = rng.nextInt(21) / 20;
                deposits[Metals.Copper.ordinal()] = rng.nextInt(21) / 20;
                deposits[Metals.Gold.ordinal()] = rng.nextInt(21) / 20;
                deposits[Metals.Lead.ordinal()] = rng.nextInt(21) / 20;
                deposits[Metals.Manganese.ordinal()] = rng.nextInt(21) / 20;
                deposits[Metals.Platinum.ordinal()] = rng.nextInt(21) / 20;
                deposits[Metals.Silver.ordinal()] = rng.nextInt(21) / 20;
                deposits[Metals.Tin.ordinal()] = rng.nextInt(21) / 20;
                deposits[Metals.Iridium.ordinal()] = rng.nextInt(201) / 200;
                deposits[Metals.Osmium.ordinal()] = rng.nextInt(201) / 200;
                deposits[Metals.Palladium.ordinal()] = rng.nextInt(201) / 200;
                deposits[Metals.Rhodium.ordinal()] = rng.nextInt(201) / 200;
                deposits[Metals.Ruthenium.ordinal()] = rng.nextInt(201) / 200;
                deposits[Metals.Bismuth.ordinal()] = rng.nextInt(201) / 200;
                deposits[Metals.Indium.ordinal()] = rng.nextInt(201) / 200;
                deposits[Metals.Tellurium.ordinal()] = rng.nextInt(201) / 200;
                break;
            }
        }
        int promotionFactor = PlanetResources.calculateRichness(planet);
        for (i = 0; i < deposits.length; ++i) {
            if (deposits[i] == 0) continue;
            int rich = rng.nextInt(promotionFactor + 1);
            deposits[i] = rich += deposits[i] - 1;
        }
        for (i = 0; i < positions.length; ++i) {
            if (deposits[i] == 0) continue;
            positions[i] = rng.nextLong();
        }
    }

    public static int[] calculateAtmosphere(Solar planet, Random rng) {
        int[] weights = new int[Gases.values().length];
        switch (planet.ptype) {
            case BARE_ROCK: {
                break;
            }
            case ICE: {
                break;
            }
            case ATM_ROCK: {
                weights[Gases.Ammonia.ordinal()] = rng.nextInt(5);
                weights[Gases.CarbonDioxide.ordinal()] = rng.nextInt(5);
                weights[Gases.Helium.ordinal()] = rng.nextInt(1);
                weights[Gases.Hydrogen.ordinal()] = rng.nextInt(7);
                weights[Gases.Nitrogen.ordinal()] = rng.nextInt(5);
                weights[Gases.Oxygen.ordinal()] = rng.nextInt(1);
                weights[Gases.WaterVapor.ordinal()] = rng.nextInt(1);
                weights[Gases.Methane.ordinal()] = 2 + rng.nextInt(5);
                break;
            }
            case CLOUD: {
                weights[Gases.Ammonia.ordinal()] = 3 + rng.nextInt(15);
                weights[Gases.CarbonDioxide.ordinal()] = 30 + rng.nextInt(50);
                weights[Gases.Helium.ordinal()] = rng.nextInt(1);
                weights[Gases.Hydrogen.ordinal()] = rng.nextInt(7);
                weights[Gases.Nitrogen.ordinal()] = 30 + rng.nextInt(50);
                weights[Gases.Oxygen.ordinal()] = 1 + rng.nextInt(1);
                weights[Gases.WaterVapor.ordinal()] = 30 + rng.nextInt(50);
                weights[Gases.Methane.ordinal()] = 2 + rng.nextInt(5);
                break;
            }
            case EARTH: {
                weights[Gases.Ammonia.ordinal()] = rng.nextInt(2);
                weights[Gases.CarbonDioxide.ordinal()] = 1 + rng.nextInt(5);
                weights[Gases.Helium.ordinal()] = rng.nextInt(3);
                weights[Gases.Hydrogen.ordinal()] = rng.nextInt(1);
                weights[Gases.Nitrogen.ordinal()] = 60 + rng.nextInt(50);
                weights[Gases.Oxygen.ordinal()] = 12 + rng.nextInt(20);
                weights[Gases.WaterVapor.ordinal()] = 5 + rng.nextInt(10);
                weights[Gases.Methane.ordinal()] = 1 + rng.nextInt(2);
                break;
            }
            case RINGS: {
                weights[Gases.Ammonia.ordinal()] = 1 + rng.nextInt(3);
                weights[Gases.CarbonDioxide.ordinal()] = rng.nextInt(2);
                weights[Gases.Helium.ordinal()] = 2 + rng.nextInt(5);
                weights[Gases.Hydrogen.ordinal()] = 80 + rng.nextInt(20);
                weights[Gases.Nitrogen.ordinal()] = rng.nextInt(1);
                weights[Gases.Oxygen.ordinal()] = rng.nextInt(1);
                weights[Gases.WaterVapor.ordinal()] = 1 + rng.nextInt(3);
                weights[Gases.Methane.ordinal()] = 2 + rng.nextInt(8);
                break;
            }
            case SMALL_GAS: {
                weights[Gases.Ammonia.ordinal()] = rng.nextInt(5);
                weights[Gases.CarbonDioxide.ordinal()] = rng.nextInt(5);
                weights[Gases.Helium.ordinal()] = 12 + rng.nextInt(25);
                weights[Gases.Hydrogen.ordinal()] = 50 + rng.nextInt(50);
                weights[Gases.Nitrogen.ordinal()] = rng.nextInt(1);
                weights[Gases.Oxygen.ordinal()] = rng.nextInt(1);
                weights[Gases.WaterVapor.ordinal()] = 1 + rng.nextInt(8);
                weights[Gases.Methane.ordinal()] = 1 + rng.nextInt(8);
                break;
            }
            case BIG_GAS: {
                weights[Gases.Ammonia.ordinal()] = rng.nextInt(2);
                weights[Gases.CarbonDioxide.ordinal()] = rng.nextInt(2);
                weights[Gases.Helium.ordinal()] = 12 + rng.nextInt(25);
                weights[Gases.Hydrogen.ordinal()] = 50 + rng.nextInt(50);
                weights[Gases.Nitrogen.ordinal()] = rng.nextInt(1);
                weights[Gases.Oxygen.ordinal()] = rng.nextInt(1);
                weights[Gases.WaterVapor.ordinal()] = rng.nextInt(2);
                weights[Gases.Methane.ordinal()] = rng.nextInt(2);
                break;
            }
            case GRAPHITE_ROCK: {
                weights[Gases.Ammonia.ordinal()] = rng.nextInt(30);
                weights[Gases.CarbonDioxide.ordinal()] = rng.nextInt(50);
                weights[Gases.Helium.ordinal()] = rng.nextInt(40);
                weights[Gases.Hydrogen.ordinal()] = rng.nextInt(10);
                weights[Gases.Nitrogen.ordinal()] = rng.nextInt(50);
                weights[Gases.Oxygen.ordinal()] = rng.nextInt(1);
                weights[Gases.WaterVapor.ordinal()] = rng.nextInt(3);
                weights[Gases.Methane.ordinal()] = rng.nextInt(50);
                break;
            }
            default: {
                weights[Gases.Ammonia.ordinal()] = rng.nextInt(50);
                weights[Gases.CarbonDioxide.ordinal()] = rng.nextInt(50);
                weights[Gases.Helium.ordinal()] = rng.nextInt(50);
                weights[Gases.Hydrogen.ordinal()] = rng.nextInt(50);
                weights[Gases.Nitrogen.ordinal()] = rng.nextInt(50);
                weights[Gases.Oxygen.ordinal()] = rng.nextInt(2);
                weights[Gases.WaterVapor.ordinal()] = rng.nextInt(5);
                weights[Gases.Methane.ordinal()] = rng.nextInt(5);
            }
        }
        if (planet.eet < 270) {
            int n = Gases.WaterVapor.ordinal();
            weights[n] = weights[n] / 10;
        } else if (planet.eet < 300) {
            int n = Gases.WaterVapor.ordinal();
            weights[n] = weights[n] / 5;
        }
        return weights;
    }

    public static void calculateFluids(Solar planet, int[] atmosphere, Random rng, int[] deposits, long[] positions) {
        switch (planet.ptype) {
            case SMALL_GAS: {
                if (planet.eet > 100 && planet.eet < 1000) {
                    deposits[Fluids.Hydrocarbons.ordinal()] = (int)(rng.nextDouble() * 5.0);
                }
                if (planet.eet > 200 && planet.eet < 300) {
                    deposits[Fluids.Ammonia.ordinal()] = (int)(rng.nextDouble() * 5.0);
                }
                if (planet.eet <= 200 || planet.eet >= 270) break;
                deposits[Fluids.SulfurDioxide.ordinal()] = (int)(rng.nextDouble() * 1.2);
                break;
            }
            case GRAPHITE_ROCK: {
                deposits[Fluids.Hydrocarbons.ordinal()] = (int)(rng.nextDouble() * 5.0);
                if (atmosphere[Gases.Oxygen.ordinal()] != 0 || atmosphere[Gases.Hydrogen.ordinal()] <= 1) break;
                deposits[Fluids.Silicones.ordinal()] = (int)(rng.nextDouble() * 1.2);
                break;
            }
            case ICE: {
                if (planet.eet > 150) {
                    deposits[Fluids.Hydrocarbons.ordinal()] = (int)(rng.nextDouble() * 2.0);
                }
                if (planet.eet > 190 && planet.eet < 230) {
                    deposits[Fluids.Ammonia.ordinal()] = (int)(rng.nextDouble() * 3.0);
                }
                if (planet.eet <= 200 || planet.eet >= 260) break;
                deposits[Fluids.SulfurDioxide.ordinal()] = (int)(rng.nextDouble() * 2.0);
                break;
            }
            case EARTH: {
                deposits[Fluids.Water.ordinal()] = (int)(rng.nextDouble() * 5.0);
                deposits[Fluids.Hydrocarbons.ordinal()] = (int)(rng.nextDouble() * 1.5);
                break;
            }
            case CLOUD: {
                if (planet.eet > 150 && planet.eet < 400 && atmosphere[Gases.Oxygen.ordinal()] < 2 && atmosphere[Gases.Methane.ordinal()] > 0) {
                    deposits[Fluids.Hydrocarbons.ordinal()] = (int)(rng.nextDouble() * 2.0);
                }
                if (planet.eet > 190 && planet.eet < 230) {
                    deposits[Fluids.Ammonia.ordinal()] = (int)(rng.nextDouble() * 3.0);
                }
                if (planet.eet <= 200 || planet.eet >= 260) break;
                deposits[Fluids.SulfurDioxide.ordinal()] = (int)(rng.nextDouble() * 3.0);
                break;
            }
            case ATM_ROCK: {
                if (planet.eet > 274 && planet.eet < 340) {
                    deposits[Fluids.Water.ordinal()] = (int)(rng.nextDouble() * 1.5);
                }
                if (atmosphere[Gases.Oxygen.ordinal()] == 0 && atmosphere[Gases.Hydrogen.ordinal()] > 1) {
                    deposits[Fluids.Silicones.ordinal()] = (int)(rng.nextDouble() * 1.5);
                }
                if (deposits[Fluids.Water.ordinal()] == 0 && planet.eet > 190 && planet.eet < 230) {
                    deposits[Fluids.Ammonia.ordinal()] = (int)(rng.nextDouble() * 1.5);
                }
                if (deposits[Fluids.Water.ordinal()] != 0 || planet.eet <= 200 || planet.eet >= 260) break;
                deposits[Fluids.SulfurDioxide.ordinal()] = (int)(rng.nextDouble() * 1.5);
                break;
            }
            case BARE_ROCK: {
                if (planet.eet <= 274 || planet.eet >= 290) break;
                if (atmosphere[Gases.Oxygen.ordinal()] == 0 && atmosphere[Gases.Hydrogen.ordinal()] > 1) {
                    deposits[Fluids.Silicones.ordinal()] = (int)(rng.nextDouble() * 1.5);
                }
                deposits[Fluids.Water.ordinal()] = (int)(rng.nextDouble() * 1.2);
            }
        }
        for (int i = 0; i < positions.length; ++i) {
            if (deposits[i] == 0) continue;
            positions[i] = rng.nextLong();
        }
    }

    public static int[] calculateMinerals(Solar planet, Random rng) {
        int[] deposits = new int[Minerals.values().length];
        switch (planet.ptype) {
            case BARE_ROCK: {
                deposits[Minerals.CeramicMinerals.ordinal()] = (int)(rng.nextDouble() * 5.0);
                deposits[Minerals.Cerium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Dysprosium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Erbium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Europium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Gadolinium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Holmium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Lanthanum.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Lutetium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Neodymium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Praseodymium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Promethium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Samarium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Scandium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Terbium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Thulium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Ytterbium.ordinal()] = rng.nextInt(205) / 100;
                deposits[Minerals.Yttrium.ordinal()] = rng.nextInt(205) / 100;
                break;
            }
            case ATM_ROCK: {
                deposits[Minerals.CeramicMinerals.ordinal()] = (int)(rng.nextDouble() * 5.0);
                deposits[Minerals.Cerium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Dysprosium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Erbium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Europium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Gadolinium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Holmium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Lanthanum.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Lutetium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Neodymium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Praseodymium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Promethium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Samarium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Scandium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Terbium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Thulium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Ytterbium.ordinal()] = rng.nextInt(105) / 100;
                deposits[Minerals.Yttrium.ordinal()] = rng.nextInt(105) / 100;
                break;
            }
            case CLOUD: {
                deposits[Minerals.CeramicMinerals.ordinal()] = (int)(rng.nextDouble() * 2.5);
                deposits[Minerals.Cerium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Dysprosium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Erbium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Europium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Gadolinium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Holmium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Lanthanum.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Lutetium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Neodymium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Praseodymium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Promethium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Samarium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Scandium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Terbium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Thulium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Ytterbium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Yttrium.ordinal()] = rng.nextInt(103) / 100;
                break;
            }
            case EARTH: {
                deposits[Minerals.CeramicMinerals.ordinal()] = (int)(rng.nextDouble() * 4.0);
                deposits[Minerals.Cerium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Dysprosium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Erbium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Europium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Gadolinium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Holmium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Lanthanum.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Lutetium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Neodymium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Praseodymium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Promethium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Samarium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Scandium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Terbium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Thulium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Ytterbium.ordinal()] = rng.nextInt(103) / 100;
                deposits[Minerals.Yttrium.ordinal()] = rng.nextInt(103) / 100;
                break;
            }
            case ICE: {
                deposits[Minerals.CeramicMinerals.ordinal()] = (int)(rng.nextDouble() * 1.01);
                deposits[Minerals.Cerium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Dysprosium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Erbium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Europium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Gadolinium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Holmium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Lanthanum.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Lutetium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Neodymium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Praseodymium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Promethium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Samarium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Scandium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Terbium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Thulium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Ytterbium.ordinal()] = rng.nextInt(301) / 300;
                deposits[Minerals.Yttrium.ordinal()] = rng.nextInt(301) / 300;
                break;
            }
        }
        int promotionFactor = PlanetResources.calculateRichness(planet);
        for (int i = 0; i < deposits.length; ++i) {
            if (deposits[i] == 0) continue;
            int richness = rng.nextInt(promotionFactor + 1);
            deposits[i] = deposits[i] + richness - 1;
        }
        return deposits;
    }

    public static int[] calculateOtherResources(Solar planet, Random rng) {
        int[] resources = new int[OtherResource.values().length];
        Society society = planet.society;
        if (society == null) {
            System.err.println("calculateOtherResources: society=null");
        } else if (society.population == 0) {
            System.err.println("calculateOtherResources: population=zero");
            if (Society.totalPopulation == 0) {
                if (rng.nextDouble() < 0.01) {
                    resources[OtherResource.UnknownAlienArtefacts.ordinal()] = 1;
                }
            } else if (rng.nextDouble() < 0.01) {
                resources[OtherResource.AlienArtefacts.ordinal()] = 1;
            }
            if (rng.nextDouble() < 0.05) {
                resources[OtherResource.RareCrystals.ordinal()] = 1;
            }
            Solar.PlanetType ptype = planet.ptype;
            if (planet.calcSurfaceGravity() / 9.81 > 3.5 && (ptype == Solar.PlanetType.BARE_ROCK || ptype == Solar.PlanetType.ATM_ROCK || ptype == Solar.PlanetType.GRAPHITE_ROCK) && rng.nextDouble() < 0.1) {
                resources[OtherResource.Transuraniums.ordinal()] = 1;
            }
            if (planet.calcSurfaceGravity() / 9.81 > 2.5 && (ptype == Solar.PlanetType.BARE_ROCK || ptype == Solar.PlanetType.ATM_ROCK || ptype == Solar.PlanetType.GRAPHITE_ROCK) && rng.nextDouble() < 0.5) {
                resources[OtherResource.Ultrametals.ordinal()] = 1;
            }
        } else {
            System.err.println("calculateOtherResources: population=" + society.population);
        }
        return resources;
    }

    private static int calculateRichness(Solar planet) {
        int promotionFactor = 0;
        switch (planet.ptype) {
            case BARE_ROCK: {
                promotionFactor = planet.radius / 1500;
                break;
            }
            case ATM_ROCK: {
                promotionFactor = planet.radius / 3000;
                break;
            }
            case CLOUD: {
                promotionFactor = planet.radius / 5000;
                break;
            }
            case EARTH: {
                promotionFactor = planet.radius / 6000;
                break;
            }
            case ICE: {
                promotionFactor = planet.radius / 5000;
                break;
            }
            case RINGS: 
            case SMALL_GAS: {
                promotionFactor = planet.radius / 15000;
                break;
            }
            case BIG_GAS: {
                promotionFactor = planet.radius / 40000;
                break;
            }
        }
        return promotionFactor;
    }

    public static Random getPlanetRng(Solar planet) {
        Random rng = RandomHelper.createRNG(planet.seed + (long)(planet.radius * 1000) + (long)planet.orbit + (long)planet.eet + (long)(planet.name.hashCode() << 16));
        return rng;
    }

    public static void main(String[] args) {
        System.err.println(":" + (Object)((Object)Gases.Oxygen));
        System.err.println(":" + (Object)((Object)Gases.Nitrogen));
        System.err.println(":" + (Object)((Object)Gases.CarbonDioxide));
    }

    public static enum OtherResource {
        AlienArtefacts("Alien Artefacts", "#dddddd"),
        UnknownAlienArtefacts("Unknown Alien Artefacts", "#ff7777"),
        RareCrystals("Rare Crystals", "dd99dd"),
        Transuraniums("Stable Transuranium Elements", "#ff9900"),
        Ultrametals("Ultracondensed Metals", "#0099ff");

        public final String color;
        private String name;

        private OtherResource(String color) {
            this.name = this.name();
            this.color = color;
        }

        private OtherResource(String name, String color) {
            this.name = name;
            this.color = color;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Fluids {
        Water("Water", "#aabbff"),
        Hydrocarbons("Hydrocarbons", "#eebb88"),
        Silicones("Silicone fluids", "#88bbee"),
        SulfurDioxide("Sulfur dioxide", "#aabbee"),
        Ammonia("Ammonia", "#ccffff");

        public final String color;
        private String name;

        private Fluids(String name, String color) {
            this.name = name;
            this.color = color;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Minerals {
        Sulphur("#dddddd"),
        Phosphates,
        Fluorspar,
        CeramicMinerals("Ceramic minerals", "#dddddd"),
        Potash,
        Gypsum,
        IronOxides("Iron oxides", "#ffcc99"),
        Scandium,
        Yttrium,
        Lanthanum("#ffffff"),
        Cerium("#ffff00"),
        Praseodymium("#44dd00"),
        Neodymium("#dd00ee"),
        Promethium("#dd5500"),
        Samarium,
        Europium("#0066ff"),
        Gadolinium,
        Terbium("#55aa55"),
        Dysprosium("#aaaaaa"),
        Holmium("#bbccaa"),
        Erbium("#aaccbb"),
        Thulium("#5555aa"),
        Ytterbium("#aa5555"),
        Lutetium("#cc9955");

        public final String color;
        private String name;

        private Minerals() {
            this.name = this.name();
            this.color = "#cccccc";
        }

        private Minerals(String color) {
            this.name = this.name();
            this.color = color;
        }

        private Minerals(String name, String color) {
            this.name = name;
            this.color = color;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Metals {
        Chromium("#ddeeff"),
        Lead("#aaaaaa"),
        Manganese("#eedddd"),
        Tin("#cccccc"),
        Copper("#ffbb88"),
        Silver("#ffffcc"),
        Gold("#ffff77"),
        Platinum("#eeeeee"),
        Zinc("aaaadd"),
        Mercury("#ffffff"),
        Iron("#ddccbb"),
        Nickel("#ddddaa"),
        Iridium,
        Osmium,
        Palladium,
        Rhodium,
        Ruthenium,
        Bismuth,
        Indium,
        Tellurium;

        public final String color;

        private Metals() {
            this.color = "#eeeeee";
        }

        private Metals(String color) {
            this.color = color;
        }
    }

    public static enum Gases {
        Hydrogen("Hydrogen", "#eeeeee"),
        Helium("Helium", "#ffffcc"),
        Oxygen("Oxygen", "#ccccff"),
        Nitrogen("Nitrogen", "#ccffbb"),
        CarbonDioxide("Carbon dioxide", "#ffcccc"),
        Ammonia("Ammonia", "#ccffff"),
        WaterVapor("Water vapor", "#99bbff"),
        Methane("Methane", "#ffdd99");

        private String name;
        public String color;

        private Gases(String name, String color) {
            this.name = name;
            this.color = color;
        }

        public String toString() {
            return this.name;
        }
    }
}

