/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import solarex.evolution.World;
import solarex.galaxy.Galaxy;
import solarex.galaxy.SystemLocation;
import solarex.ship.Ship;
import solarex.system.Society;
import solarex.system.Solar;
import solarex.ui.ImageCache;
import solarex.ui.components.ImagedPanel;
import solarex.ui.interfaces.ShowPlanetCallback;
import solarex.ui.interfaces.ShowSystemCallback;
import solarex.ui.observables.ObservableToLabelConnector;
import solarex.ui.panels.GalaxyViewPanel;
import solarex.ui.panels.NavigationPanel;
import solarex.ui.panels.PlanetViewPanel;
import solarex.ui.panels.SetupPanel;
import solarex.ui.panels.ShipInfoPanel;
import solarex.ui.panels.SpaceStationPanel;
import solarex.ui.panels.TabularSystemPanel;
import solarex.ui.panels.TitlePanel;
import solarex.util.ClockCallback;
import solarex.util.ClockThread;
import solarex.util.ComponentFactory;

public class ApplicationFrame
extends JFrame
implements ShowSystemCallback,
ShowPlanetCallback {
    private static final Logger LOGGER = Logger.getLogger(ApplicationFrame.class.getName());
    private ClockThread clockThread;
    private TabularSystemPanel tabSys;
    private NavigationPanel navigationPanel;
    private GalaxyViewPanel galMap;
    private PlanetViewPanel planetView;
    private SpaceStationPanel stationView;
    private SetupPanel setupPanel;
    private JScrollPane systemScroller;
    private JButton homeButton;
    private JButton setupButton;
    private JButton galacticMapButton;
    private JButton tabSysButton;
    private JButton navigationButton;
    private ImagedPanel titleBorderPanel;
    private JPanel panelPanel;
    private Ship ship;
    private Solar system;
    private SystemLocation loca = new SystemLocation();
    private World world;
    private Galaxy galaxy;

    public void setExplorerMode(boolean yesno) {
        this.ship.player.setExplorerMode(yesno);
    }

    public void makeSystem(long seed) {
        this.loca.systemSeed = seed;
        this.makeSystemWithHome(this.loca);
        this.switchToSystemView();
    }

    @Override
    public Solar makeSystem(SystemLocation loca) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.system = new Solar(loca, true);
        Society.populate(this.system);
        this.tabSys.layoutSystem(this.system);
        this.systemScroller.getHorizontalScrollBar().setValue(0);
        this.navigationPanel.setSystem(this.system);
        this.setCursor(Cursor.getDefaultCursor());
        return this.system;
    }

    public Solar makeSystemWithHome(SystemLocation loca) {
        this.makeSystem(loca);
        Solar home = null;
        if (this.system != null) {
            ArrayList<Solar> list = new ArrayList<Solar>();
            this.system.listSettlements(list);
            for (Solar settlement : list) {
                if (!"Van Allen Habitat".equals(settlement.name) || 2024894555787792824L != settlement.seed) continue;
                this.ship.arrive(this.galaxy, settlement);
                home = settlement;
                break;
            }
        }
        return home;
    }

    @Override
    public void showSystem(SystemLocation loca) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Solar home = this.makeSystemWithHome(loca);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setupPanel.setSeed(loca.systemSeed);
        if (home != null) {
            this.switchToStationView(home);
        } else {
            this.switchToSystemView();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void showSpaceBody(Solar body) {
        if (body.btype == Solar.BodyType.PLANET) {
            this.switchToPlanetView(body);
        }
        if (body.btype == Solar.BodyType.STATION || body.btype == Solar.BodyType.SPACEPORT) {
            this.switchToStationView(body);
        }
    }

    private void removePanels() {
        this.panelPanel.removeAll();
    }

    private void switchToSystemView() {
        this.tabSys.layoutSystem(this.system);
        this.removePanels();
        this.galacticMapButton.setVisible(true);
        this.tabSysButton.setVisible(false);
        this.homeButton.setVisible(this.ship.getState() == Ship.State.DOCKED);
        this.panelPanel.add((Component)this.systemScroller, "Center");
        this.tabSys.revalidate();
        this.validate();
        this.repaint();
    }

    private void switchToNavigationView() {
        this.removePanels();
        this.galacticMapButton.setVisible(true);
        this.tabSysButton.setVisible(true);
        this.homeButton.setVisible(this.ship.getState() == Ship.State.DOCKED);
        this.navigationPanel.updateControls();
        this.panelPanel.add((Component)this.navigationPanel, "Center");
        this.validate();
        this.repaint();
    }

    private void switchToGalacticalView() {
        this.removePanels();
        this.homeButton.setVisible(this.ship.getState() == Ship.State.DOCKED);
        this.galacticMapButton.setVisible(false);
        this.tabSysButton.setVisible(true);
        this.panelPanel.add((Component)this.galMap, "Center");
        this.validate();
        this.repaint();
    }

    private void switchToPlanetView(Solar planet) {
        this.removePanels();
        this.galacticMapButton.setVisible(true);
        this.tabSysButton.setVisible(true);
        this.homeButton.setVisible(this.ship.getState() == Ship.State.DOCKED);
        this.planetView.update(planet);
        this.panelPanel.add((Component)this.planetView, "Center");
        this.validate();
        this.repaint();
    }

    private void switchToStationView(Solar station) {
        this.removePanels();
        this.galacticMapButton.setVisible(true);
        this.tabSysButton.setVisible(true);
        this.homeButton.setVisible(false);
        this.stationView.update(station);
        this.panelPanel.add((Component)this.stationView, "Center");
        this.validate();
        this.repaint();
    }

    private void switchToShipView() {
        this.removePanels();
        this.galacticMapButton.setVisible(true);
        this.tabSysButton.setVisible(true);
        this.homeButton.setVisible(this.ship.getState() == Ship.State.DOCKED);
        this.panelPanel.add((Component)new ShipInfoPanel(this.ship), "Center");
        this.validate();
        this.repaint();
    }

    private void switchToSetupView() {
        this.removePanels();
        this.tabSysButton.setVisible(true);
        this.homeButton.setVisible(this.ship.getState() == Ship.State.DOCKED);
        this.panelPanel.add((Component)this.setupPanel, "Center");
        this.validate();
        this.repaint();
    }

    private void setLookAndFeel() {
        try {
            String lfc = UIManager.getCrossPlatformLookAndFeelClassName();
            UIManager.setLookAndFeel(lfc);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public ApplicationFrame() {
        this.ship = new Ship();
        this.ship.cargo.money = 108.35;
        this.world = new World();
        ImageCache imageCache = new ImageCache();
        this.initUI(imageCache);
        this.ship.loca = this.loca;
        this.setIconImage(imageCache.planets[4].getImage());
        this.showTitleFrame(imageCache);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((size.width - this.getWidth()) / 2, (size.height - this.getHeight()) / 2 - 24);
        this.clockThread = new ClockThread();
        this.clockThread.addCallback(this.navigationPanel);
    }

    public void startClock() {
        this.clockThread.start();
    }

    private void initUI(ImageCache imageCache) {
        this.setLookAndFeel();
        ImagedPanel ipan = new ImagedPanel();
        ipan.setBackgroundImage(ImageCache.createImageIcon("/solarex/resources/backdrop/screen_bg.jpg", "").getImage());
        this.panelPanel = ipan;
        this.panelPanel.setLayout(new BorderLayout());
        this.galaxy = new Galaxy(imageCache.spiral.getImage());
        List<SystemLocation> list = this.galaxy.buildSector(-2, 0);
        this.loca = list.get(0);
        this.tabSys = new TabularSystemPanel(this.ship, imageCache);
        this.tabSys.setShowPlanetCallback(this);
        this.systemScroller = new JScrollPane(this.tabSys);
        ComponentFactory.customizeScrollpane(this.systemScroller);
        this.systemScroller.setVerticalScrollBarPolicy(21);
        this.adjustScrollbarUI(this.systemScroller.getHorizontalScrollBar());
        this.adjustScrollbarUI(this.systemScroller.getVerticalScrollBar());
        this.navigationPanel = new NavigationPanel(this.galaxy, this.ship, imageCache, this, this);
        this.galMap = new GalaxyViewPanel(this.galaxy, this.ship, imageCache);
        this.galMap.setShowSystemCallback(this);
        this.planetView = new PlanetViewPanel(this.ship, imageCache);
        this.stationView = new SpaceStationPanel(this.world, this.galaxy, this.ship, imageCache);
        this.setupPanel = new SetupPanel(this);
        this.getContentPane().add(this.panelPanel);
        this.setTitle("Solarex - Travel and Explore the Galaxy (v0.42)");
        this.setSize(1000, 740);
    }

    private void adjustScrollbarUI(JScrollBar bar) {
        bar.setBackground(Color.DARK_GRAY);
    }

    private void showTitleFrame(ImageCache imageCache) {
        TitlePanel titlePanel = new TitlePanel(imageCache);
        this.titleBorderPanel = new ImagedPanel();
        this.titleBorderPanel.setLayout(new GridBagLayout());
        this.titleBorderPanel.setBackgroundImage(imageCache.backdrops[4].getImage());
        this.titleBorderPanel.setOpaque(false);
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new BorderLayout());
        borderPanel.setBorder(new LineBorder(Color.DARK_GRAY));
        borderPanel.add(titlePanel);
        this.titleBorderPanel.add(borderPanel);
        this.panelPanel.add(this.titleBorderPanel);
        this.titleBorderPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ApplicationFrame.this.endTitleFrame();
            }
        });
        this.titleBorderPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ApplicationFrame.this.endTitleFrame();
            }
        });
    }

    private void endTitleFrame() {
        this.removePanels();
        JPanel panel = this.createButtonPanel();
        this.setupPanel.setSeed(this.loca.systemSeed);
        this.showSystem(this.loca);
        this.getContentPane().add((Component)panel, "South");
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    private JPanel createButtonPanel() {
        FlowLayout flow = new FlowLayout(1, 10, 5);
        ImagedPanel panel = new ImagedPanel();
        panel.setLayout(flow);
        panel.setBackgroundImage(ImageCache.createImageIcon("/solarex/resources/backdrop/metal_band.png", "").getImage());
        final JLabel shipStateLabel = new JLabel("");
        shipStateLabel.setForeground(Color.GREEN);
        shipStateLabel.setBackground(Color.BLACK);
        shipStateLabel.setPreferredSize(new Dimension(280, 28));
        shipStateLabel.setOpaque(true);
        shipStateLabel.setHorizontalAlignment(0);
        shipStateLabel.setBorder(new LineBorder(Color.GRAY));
        panel.add(shipStateLabel);
        new ObservableToLabelConnector(this.ship.stateString, shipStateLabel){

            @Override
            public void update(Observable o, Object arg) {
                String s = o.toString();
                StringBuilder text = new StringBuilder("<html>Ship state:&nbsp;&nbsp;");
                text.append("<font color=#FFFFFF>");
                if (ApplicationFrame.this.ship.getState() == Ship.State.DOCKED) {
                    text.append("Docked at ").append(((ApplicationFrame)ApplicationFrame.this).ship.loca.name);
                } else if (ApplicationFrame.this.ship.getState() == Ship.State.ORBIT) {
                    text.append("Orbiting ").append(((ApplicationFrame)ApplicationFrame.this).ship.loca.name);
                } else if (ApplicationFrame.this.ship.getState() == Ship.State.FLIGHT) {
                    text.append("In flight");
                } else {
                    text.append(s);
                }
                text.append("</html>");
                shipStateLabel.setText(text.toString());
            }
        };
        this.homeButton = new JButton("Home");
        ComponentFactory.customizeButton(this.homeButton, "bt_home.png");
        panel.add(this.homeButton);
        this.galacticMapButton = new JButton("Galactic Map");
        ComponentFactory.customizeButton(this.galacticMapButton, "bt_galmap.png");
        panel.add(this.galacticMapButton);
        this.tabSysButton = new JButton("System Info");
        panel.add(this.tabSysButton);
        this.tabSysButton.setVisible(false);
        ComponentFactory.customizeButton(this.tabSysButton, "bt_sysinfo.png");
        this.navigationButton = new JButton("Navigation Map");
        ComponentFactory.customizeButton(this.navigationButton, "bt_navi.png");
        panel.add(this.navigationButton);
        JButton shipButton = new JButton("Ship");
        ComponentFactory.customizeButton(shipButton, "bt_ship.png");
        panel.add(shipButton);
        JPanel timePanel = this.createTimePanel();
        panel.add(timePanel);
        this.setupButton = new JButton("Options");
        ComponentFactory.customizeButton(this.setupButton, "bt_options.png");
        panel.add(this.setupButton);
        this.homeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ApplicationFrame.this.ship.getState() == Ship.State.DOCKED) {
                    ArrayList<Solar> list = new ArrayList<Solar>();
                    ApplicationFrame.this.system.listSettlements(list);
                    for (Solar settlement : list) {
                        if (settlement.seed != ((ApplicationFrame)ApplicationFrame.this).ship.spaceBodySeed) continue;
                        ApplicationFrame.this.switchToStationView(settlement);
                        break;
                    }
                }
            }
        });
        this.navigationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationFrame.this.switchToNavigationView();
            }
        });
        this.galacticMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationFrame.this.switchToGalacticalView();
            }
        });
        this.tabSysButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationFrame.this.switchToSystemView();
            }
        });
        shipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationFrame.this.switchToShipView();
            }
        });
        this.setupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationFrame.this.switchToSetupView();
            }
        });
        return panel;
    }

    private static String format10(int v) {
        return v < 10 ? "0" + v : "" + v;
    }

    private JPanel createTimePanel() {
        JPanel timePanel = new JPanel();
        final JLabel timeLabel = new JLabel("00:00 2060/01/01");
        timeLabel.setFont(new Font("Monospaced", 1, 14));
        timeLabel.setForeground(Color.GREEN);
        timeLabel.setPreferredSize(new Dimension(155, 16));
        timeLabel.setHorizontalAlignment(0);
        timePanel.add(timeLabel);
        timePanel.setBorder(new LineBorder(Color.GRAY, 1));
        timePanel.setBackground(Color.BLACK);
        this.clockThread.addCallback(new ClockCallback(){
            private int counter = 0;

            @Override
            public void ping100(int deltaT) {
                ++this.counter;
                if (this.counter > 8) {
                    this.counter = 0;
                    int year = ClockThread.getYear();
                    int month = ClockThread.getMonthOfYear() + 1;
                    int day = ClockThread.getDayOfMonth() + 1;
                    int hour = ClockThread.getHourOfDay();
                    int minute = ClockThread.getMinuteOfHour();
                    String label = "" + ApplicationFrame.format10(hour) + ":" + ApplicationFrame.format10(minute) + "  " + year + "/" + ApplicationFrame.format10(month) + "/" + ApplicationFrame.format10(day);
                    timeLabel.setText(label);
                }
            }
        });
        return timePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveGame() {
        boolean ok = true;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String userHome = System.getProperty("user.home") + File.separator;
            System.err.println("User home: " + userHome);
            File file = new File(userHome + ".solarex");
            file.mkdirs();
            file = new File(file.getAbsolutePath() + File.separator + "save.xml");
            System.err.println("Saving to: " + file.getAbsolutePath());
            FileWriter writer = new FileWriter(file);
            this.ship.save(writer);
            writer.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            ok = false;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return ok;
    }

    public boolean loadGame() {
        boolean ok = true;
        try {
            String userHome = System.getProperty("user.home") + File.separator;
            System.err.println("User home: " + userHome);
            File file = new File(userHome + ".solarex" + File.separator + "save.xml");
            System.err.println("Loading from: " + file.getAbsolutePath());
            BufferedReader reader = new BufferedReader(new FileReader(file));
            this.ship.load(reader);
            reader.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            ok = false;
        }
        if (ok) {
            long seed = this.ship.spaceBodySeed;
            this.loca = this.ship.loca;
            this.makeSystemWithHome(this.loca);
            if (this.ship.getState() == Ship.State.DOCKED || this.ship.getState() == Ship.State.ORBIT) {
                Solar station = this.findBodyBySeed(this.system, seed);
                this.ship.arrive(this.galaxy, station);
                this.showSpaceBody(station);
            } else {
                this.switchToSystemView();
            }
        }
        this.repaint();
        return ok;
    }

    private Solar findBodyBySeed(Solar sys, long seed) {
        if (sys.seed == seed) {
            System.err.println("Found body for seed=" + seed + " name=" + sys.name + " btype=" + (Object)((Object)sys.btype));
            return sys;
        }
        Solar result = null;
        for (int i = 0; i < sys.children.size() && result == null; ++i) {
            result = this.findBodyBySeed(sys.children.get(i), seed);
        }
        return result;
    }
}

