/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import solarex.ship.Ship;
import solarex.ship.components.ShipComponent;
import solarex.system.PlanetMiningData;
import solarex.system.PlanetResources;
import solarex.system.Solar;
import solarex.ui.ImageCache;
import solarex.ui.components.PlanetMiningGridPanel;
import solarex.ui.panels.PlanetViewPanel;
import solarex.util.ComponentFactory;

public class MiningPanel
extends JPanel
implements Observer {
    private PlanetMiningGridPanel panel;
    private PlanetViewPanel planetViewPanel;
    private Ship ship;
    private final ShipComponent drone;
    private JButton dronePanelButton;
    private JLabel droneReportLabel;
    private JPanel innerPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel left;
    private JButton miningButton;
    private JPanel miningControlPanel;
    private JPanel north;
    private JLabel quadrantInfoLabel;
    private JPanel right;
    private JPanel south;

    public MiningPanel(Solar planet, Ship ship, ImageCache imageCache, ShipComponent drone, PlanetViewPanel planetViewPanel) {
        this.planetViewPanel = planetViewPanel;
        this.ship = ship;
        this.drone = drone;
        this.initComponents();
        this.panel = new PlanetMiningGridPanel(planet, ship, imageCache, drone, this);
        Dimension size = new Dimension(800, 310);
        this.panel.setPreferredSize(size);
        this.panel.setMaximumSize(size);
        this.panel.setMaximumSize(size);
        this.miningControlPanel.add((Component)this.panel, "Center");
        ComponentFactory.customizeButton(this.dronePanelButton);
        ComponentFactory.customizeButton(this.miningButton);
    }

    private void initComponents() {
        this.innerPanel = new JPanel();
        this.miningControlPanel = new JPanel();
        this.left = new JPanel();
        this.right = new JPanel();
        this.south = new JPanel();
        this.jPanel1 = new JPanel();
        this.quadrantInfoLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.droneReportLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.dronePanelButton = new JButton();
        this.miningButton = new JButton();
        this.north = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.setBackground(Color.black);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.innerPanel.setBackground(Color.black);
        this.innerPanel.setPreferredSize(new Dimension(822, 619));
        this.innerPanel.setLayout(new BorderLayout());
        this.miningControlPanel.setBackground(new Color(0, 0, 0));
        this.miningControlPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.miningControlPanel.setForeground(Color.green);
        this.miningControlPanel.setPreferredSize(new Dimension(802, 602));
        this.miningControlPanel.setLayout(new BorderLayout());
        this.innerPanel.add((Component)this.miningControlPanel, "Center");
        this.left.setBackground(new Color(0, 0, 51));
        this.left.setOpaque(false);
        this.left.setPreferredSize(new Dimension(32, 200));
        this.left.setLayout(new GridBagLayout());
        this.innerPanel.add((Component)this.left, "West");
        this.right.setBackground(new Color(0, 0, 51));
        this.right.setOpaque(false);
        this.right.setPreferredSize(new Dimension(32, 200));
        this.right.setLayout(new GridBagLayout());
        this.innerPanel.add((Component)this.right, "East");
        this.south.setBackground(new Color(0, 0, 51));
        this.south.setOpaque(false);
        this.south.setLayout(new GridBagLayout());
        this.jPanel1.setBackground(Color.darkGray);
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128)));
        this.jPanel1.setLayout(new GridBagLayout());
        this.quadrantInfoLabel.setFont(new Font("SansSerif", 0, 12));
        this.quadrantInfoLabel.setForeground(Color.lightGray);
        this.quadrantInfoLabel.setVerticalAlignment(1);
        this.quadrantInfoLabel.setPreferredSize(new Dimension(300, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.quadrantInfoLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 32, 10, 5);
        this.south.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setBackground(Color.darkGray);
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128)));
        this.jPanel2.setLayout(new GridBagLayout());
        this.droneReportLabel.setFont(new Font("SansSerif", 0, 12));
        this.droneReportLabel.setForeground(Color.lightGray);
        this.droneReportLabel.setVerticalAlignment(1);
        this.droneReportLabel.setPreferredSize(new Dimension(300, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel2.add((Component)this.droneReportLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 10, 32);
        this.south.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new FlowLayout(0));
        this.dronePanelButton.setText("Drone Selection");
        this.dronePanelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiningPanel.this.dronePanelButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.dronePanelButton);
        this.miningButton.setText("Activate Drone");
        this.miningButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MiningPanel.this.miningButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.miningButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.south.add((Component)this.jPanel3, gridBagConstraints);
        this.innerPanel.add((Component)this.south, "South");
        this.north.setBackground(new Color(0, 0, 51));
        this.north.setOpaque(false);
        this.north.setLayout(new FlowLayout(0));
        this.jLabel1.setFont(new Font("SansSerif", 0, 18));
        this.jLabel1.setForeground(Color.green);
        this.jLabel1.setText("  Drone Status:");
        this.north.add(this.jLabel1);
        this.jLabel2.setFont(new Font("SansSerif", 0, 18));
        this.jLabel2.setForeground(Color.yellow);
        this.jLabel2.setText("92/100 Durability, 54% Fuel");
        this.north.add(this.jLabel2);
        this.innerPanel.add((Component)this.north, "North");
        this.add((Component)this.innerPanel, new GridBagConstraints());
    }

    private void dronePanelButtonActionPerformed(ActionEvent evt) {
        this.planetViewPanel.switchToPlanetView();
    }

    private void miningButtonActionPerformed(ActionEvent evt) {
        this.panel.doMining();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof PlanetMiningData.Surface) {
            String text;
            PlanetMiningData.Surface surface = (PlanetMiningData.Surface)((Object)arg);
            switch (surface) {
                case FLUID: {
                    text = "<html> Current Quadrant:<br><br> Fluid covered surface.</html>";
                    break;
                }
                case FLUID_ICE: {
                    text = "<html> Current Quadrant:<br><br> Surface is a mix of fluids and ice.</html>";
                    break;
                }
                case FLUID_ROCKS: {
                    text = "<html> Current Quadrant:<br><br> Fluid covered surface with rocky islands.</html>";
                    break;
                }
                case FLUID_ICE_ROCKS: {
                    text = "<html> Current Quadrant:<br><br> Fluid covered surface with icy and rocky areas.</html>";
                    break;
                }
                case ICE: {
                    text = "<html> Current Quadrant:<br><br> Ice covered surface.</html>";
                    break;
                }
                case ICE_ROCKS: {
                    text = "<html> Current Quadrant:<br><br> Rocky surface with ice covered areas.</html>";
                    break;
                }
                case ROCKS: {
                    text = "<html> Current Quadrant:<br><br> Solid rocky surface.</html>";
                    break;
                }
                default: {
                    text = "<html> Current Quadrant:<br><br> Nothing known.</html>";
                }
            }
            this.quadrantInfoLabel.setText(text);
        }
        if (arg instanceof String) {
            this.droneReportLabel.setText((String)arg);
        }
        if (arg instanceof int[]) {
            if (this.drone.getName().contains("Gas Filtration Drone")) {
                this.droneGasFiltrationResult((int[])arg);
            } else if (this.drone.getName().contains("Fluid Distillation Drone")) {
                this.droneFluidDistillationResult((int[])arg);
            } else {
                this.droneMiningResult((int[])arg);
            }
        }
    }

    private void droneMiningResult(int[] deposits) {
        String text = "<html>Drone Mining Report:<br><br>";
        PlanetResources.Metals[] values = PlanetResources.Metals.values();
        boolean found = false;
        for (int i = 0; i < deposits.length; ++i) {
            if (deposits[i] == 0) continue;
            text = text + "" + deposits[i] + " units of <font color=" + values[i].color + ">" + values[i].name().toLowerCase() + "</font> mined.<br>";
            found = true;
            int n = PlanetResources.metalToGood(i);
            this.ship.cargo.goods[n].units += deposits[i];
        }
        if (!found) {
            text = "<html>Drone Mining Report:<br><br>Could not mine any metals.";
        }
        text = text + "<html>";
        this.droneReportLabel.setText(text);
    }

    private void droneGasFiltrationResult(int[] deposits) {
        String text = "<html>Drone Gas Filtration Report:<br><br>";
        PlanetResources.Gases[] values = PlanetResources.Gases.values();
        boolean found = false;
        for (int i = 0; i < deposits.length; ++i) {
            if (deposits[i] == 0) continue;
            text = text + "" + deposits[i] + " units of <font color=" + values[i].color + ">" + values[i].name().toLowerCase() + "</font> harvested.<br>";
            found = true;
            int n = PlanetResources.gasToGood(i);
            this.ship.cargo.goods[n].units += deposits[i];
        }
        if (!found) {
            text = "<html>Drone Mining Report:<br><br>Could not filtrate any gases.";
        }
        text = text + "<html>";
        this.droneReportLabel.setText(text);
    }

    private void droneFluidDistillationResult(int[] deposits) {
        String text = "<html>Drone Fluid Distillation Report:<br><br>";
        PlanetResources.Fluids[] values = PlanetResources.Fluids.values();
        boolean found = false;
        for (int i = 0; i < deposits.length; ++i) {
            if (deposits[i] == 0) continue;
            text = text + "" + deposits[i] + " units of <font color=" + values[i].color + ">" + values[i].name().toLowerCase() + "</font> distilled.<br>";
            found = true;
            int n = PlanetResources.fluidToGood(i);
            this.ship.cargo.goods[n].units += deposits[i];
        }
        if (!found) {
            text = "<html>Drone Mining Report:<br><br>Could not distill any fluids.";
        }
        text = text + "<html>";
        this.droneReportLabel.setText(text);
    }
}

