/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.entity;

import com.bradmcevoy.http.CompressedResource;
import com.bradmcevoy.http.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedResourceEntity
implements Response.Entity {
    private static final Logger log = LoggerFactory.getLogger(CompressedResourceEntity.class);
    private CompressedResource resource;
    private Map<String, String> params;
    private String contentType;
    private String contentEncoding;

    public CompressedResourceEntity(CompressedResource resource, Map<String, String> params, String contentType, String contentEncoding) {
        this.resource = resource;
        this.params = params;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
    }

    public CompressedResource getResource() {
        return this.resource;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public void write(Response response, OutputStream outputStream) throws Exception {
        try {
            this.resource.sendCompressedContent(this.contentEncoding, outputStream, null, this.params, this.contentType);
        }
        catch (IOException ex) {
            log.warn("IOException sending compressed content", (Throwable)ex);
        }
    }
}

