/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.entity;

import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.io.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialEntity
implements Response.Entity {
    private static final Logger log = LoggerFactory.getLogger(PartialEntity.class);
    private List<Range> ranges;
    private File temp;

    public PartialEntity(List<Range> ranges, File temp) {
        this.ranges = ranges;
        this.temp = temp;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public File getTemp() {
        return this.temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Response response, OutputStream outputStream) throws Exception {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(this.temp);
            PartialEntity.writeRanges(fin, this.ranges, outputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.close(fin);
            throw throwable;
        }
        StreamUtils.close(fin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRanges(InputStream in, List<Range> ranges, OutputStream responseOut) throws IOException {
        try {
            InputStream bufIn = in;
            long pos = 0L;
            for (Range r : ranges) {
                long skip = r.getStart() - pos;
                bufIn.skip(skip);
                long length = r.getFinish() - r.getStart();
                PartialEntity.sendBytes(bufIn, responseOut, length);
                pos = r.getFinish();
            }
        }
        finally {
            StreamUtils.close(in);
        }
    }

    public static void sendBytes(InputStream in, OutputStream out, long length) throws IOException {
        long remainingBytes;
        int maxLength;
        int s;
        log.trace("sendBytes: " + length);
        byte[] b = new byte[1024];
        for (long numRead = 0L; numRead < length && (s = in.read(b, 0, maxLength = (remainingBytes = length - numRead) > 1024L ? 1024 : (int)remainingBytes)) >= 0; numRead += (long)s) {
            out.write(b, 0, s);
        }
    }

    public static void writeRange(InputStream in, Range r, OutputStream responseOut) throws IOException {
        long skip = r.getStart();
        in.skip(skip);
        long length = r.getFinish() - r.getStart();
        PartialEntity.sendBytes(in, responseOut, length);
    }
}

