/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.Utils;
import com.bradmcevoy.http.XmlWriter;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockWriterHelper {
    private static final Logger log = LoggerFactory.getLogger(LockWriterHelper.class);
    private static String D = "d";
    private boolean stripHrefOnOwner = true;

    public void appendDepth(XmlWriter writer, LockInfo.LockDepth depthType) {
        String s = "Infinity";
        if (depthType != null && depthType.equals((Object)LockInfo.LockDepth.INFINITY)) {
            s = depthType.name().toUpperCase();
        }
        writer.writeProperty(null, D + ":depth", s);
    }

    public void appendOwner(XmlWriter writer, String owner) {
        boolean validHref;
        if (owner == null) {
            log.warn("owner is null");
            validHref = false;
        } else {
            validHref = this.isValidHref(owner);
        }
        log.debug("appendOwner: " + validHref + " - " + this.stripHrefOnOwner);
        if (!validHref && this.stripHrefOnOwner) {
            writer.writeProperty(null, D + ":owner", owner);
        } else {
            XmlWriter.Element el = writer.begin(D + ":owner").open();
            XmlWriter.Element el2 = writer.begin(D + ":href").open();
            if (owner != null) {
                el2.writeText(owner);
            }
            el2.close();
            el.close();
        }
    }

    public void appendScope(XmlWriter writer, LockInfo.LockScope scope) {
        writer.writeProperty(null, D + ":lockscope", "<" + D + ":" + scope.toString().toLowerCase() + "/>");
    }

    public void appendTimeout(XmlWriter writer, Long seconds) {
        if (seconds != null && seconds > 0L) {
            writer.writeProperty(null, D + ":timeout", "Second-" + Utils.withMax(seconds, 0xFFFFFFFFL));
        }
    }

    public void appendTokenId(XmlWriter writer, String tokenId) {
        XmlWriter.Element el = writer.begin(D + ":locktoken").open();
        writer.writeProperty(null, D + ":href", "opaquelocktoken:" + tokenId);
        el.close();
    }

    public void appendType(XmlWriter writer, LockInfo.LockType type) {
        writer.writeProperty(null, D + ":locktype", "<" + D + ":" + type.toString().toLowerCase() + "/>");
    }

    public void appendRoot(XmlWriter writer, String lockRoot) {
        XmlWriter.Element el = writer.begin(D + ":lockroot").open();
        writer.writeProperty(null, D + ":href", lockRoot);
        el.close();
    }

    public boolean isStripHrefOnOwner() {
        return this.stripHrefOnOwner;
    }

    public void setStripHrefOnOwner(boolean stripHrefOnOwner) {
        this.stripHrefOnOwner = stripHrefOnOwner;
    }

    private boolean isValidHref(String owner) {
        log.debug("isValidHref: " + owner);
        if (owner.startsWith("http")) {
            try {
                URI u = new URI(owner);
                log.debug("uri: " + u);
                return true;
            }
            catch (URISyntaxException ex) {
                log.debug("ex: " + ex);
                return false;
            }
        }
        return false;
    }
}

