/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.property;

import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.property.BeanPropertyAccess;
import com.bradmcevoy.property.BeanPropertyResource;
import com.bradmcevoy.property.PropertySource;
import com.ettrema.common.LogUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPropertySource
implements PropertySource {
    private static final Logger log = LoggerFactory.getLogger(BeanPropertySource.class);
    private static final Object[] NOARGS = new Object[0];

    @Override
    public Object getProperty(QName name, Resource r) throws NotAuthorizedException {
        PropertyDescriptor pd = this.getPropertyDescriptor(r, name.getLocalPart());
        if (pd == null) {
            throw new IllegalArgumentException("no prop: " + name.getLocalPart() + " on " + r.getClass());
        }
        try {
            return pd.getReadMethod().invoke((Object)r, NOARGS);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof NotAuthorizedException) {
                NotAuthorizedException na = (NotAuthorizedException)ex.getCause();
                throw na;
            }
            throw new RuntimeException(name.toString(), ex);
        }
    }

    @Override
    public void setProperty(QName name, Object value, Resource r) throws NotAuthorizedException, PropertySource.PropertySetException {
        log.debug("setProperty: " + name + " = " + value);
        PropertyDescriptor pd = this.getPropertyDescriptor(r, name.getLocalPart());
        try {
            pd.getWriteMethod().invoke((Object)r, value);
        }
        catch (PropertySource.PropertySetException e) {
            throw e;
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof NotAuthorizedException) {
                NotAuthorizedException na = (NotAuthorizedException)ex.getCause();
                throw na;
            }
            if (ex.getCause() instanceof PropertySource.PropertySetException) {
                PropertySource.PropertySetException na = (PropertySource.PropertySetException)ex.getCause();
                throw na;
            }
            if (value == null) {
                log.error("Exception setting property: " + name.toString() + " to null");
            } else {
                log.error("Exception setting property: " + name.toString() + " to value: " + value + " class:" + value.getClass());
            }
            throw new RuntimeException(name.toString(), ex);
        }
    }

    @Override
    public PropertySource.PropertyMetaData getPropertyMetaData(QName name, Resource r) {
        boolean writable;
        log.debug("getPropertyMetaData");
        BeanPropertyResource anno = this.getAnnotation(r);
        if (anno == null) {
            log.debug(" no annotation: ", (Object)r.getClass().getCanonicalName());
            return PropertySource.PropertyMetaData.UNKNOWN;
        }
        if (!name.getNamespaceURI().equals(anno.value())) {
            log.debug("different namespace", (Object)anno.value(), (Object)name.getNamespaceURI());
            return PropertySource.PropertyMetaData.UNKNOWN;
        }
        PropertyDescriptor pd = this.getPropertyDescriptor(r, name.getLocalPart());
        if (pd == null || pd.getReadMethod() == null) {
            LogUtils.debug(log, "getPropertyMetaData: no read method:", name.getLocalPart(), r.getClass());
            return PropertySource.PropertyMetaData.UNKNOWN;
        }
        BeanPropertyAccess propAnno = pd.getReadMethod().getAnnotation(BeanPropertyAccess.class);
        if (propAnno != null) {
            if (!propAnno.value()) {
                log.trace("getPropertyMetaData: property is annotated and value is false, so do not allow access");
                return PropertySource.PropertyMetaData.UNKNOWN;
            }
            log.trace("getPropertyMetaData: property is annotated and value is true, so allow access");
        } else if (anno.enableByDefault()) {
            log.trace("getPropertyMetaData: no property annotation, property annotation is enable by default so allow access");
        } else {
            log.trace("getPropertyMetaData:no property annotation, class annotation says disable by default, decline access");
            return PropertySource.PropertyMetaData.UNKNOWN;
        }
        if (log.isDebugEnabled()) {
            log.debug("writable: " + anno.writable() + " - " + (pd.getWriteMethod() != null));
        }
        boolean bl = writable = anno.writable() && pd.getWriteMethod() != null;
        if (writable) {
            return new PropertySource.PropertyMetaData(PropertySource.PropertyAccessibility.WRITABLE, pd.getPropertyType());
        }
        return new PropertySource.PropertyMetaData(PropertySource.PropertyAccessibility.READ_ONLY, pd.getPropertyType());
    }

    @Override
    public void clearProperty(QName name, Resource r) throws NotAuthorizedException {
        this.setProperty(name, null, r);
    }

    @Override
    public List<QName> getAllPropertyNames(Resource r) {
        BeanPropertyResource anno = this.getAnnotation(r);
        if (anno == null) {
            return null;
        }
        PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)r);
        ArrayList<QName> list = new ArrayList<QName>();
        for (PropertyDescriptor pd : pds) {
            if (pd.getReadMethod() == null) continue;
            list.add(new QName(anno.value(), pd.getName()));
        }
        return list;
    }

    private BeanPropertyResource getAnnotation(Resource r) {
        return r.getClass().getAnnotation(BeanPropertyResource.class);
    }

    private PropertyDescriptor getPropertyDescriptor(Resource r, String name) {
        try {
            PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)r, (String)name);
            return pd;
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }
}

