/*
 * Decompiled with CFR 0.152.
 */
package com.ettrema.http.fs;

import com.bradmcevoy.common.ContentTypeUtils;
import com.bradmcevoy.common.Path;
import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.DigestResource;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.PostableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import com.bradmcevoy.http.SecurityManager;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.http11.auth.DigestResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResourceFactory
implements ResourceFactory {
    private static final Logger log = LoggerFactory.getLogger(ClassPathResourceFactory.class);
    private String basePath;
    private Long maxAgeSeconds = 604800L;
    private SecurityManager securityManager;
    private Date modifiedDate = new Date();

    @Override
    public Resource getResource(String host, String path) {
        InputStream content;
        Path p = Path.path(path);
        if (this.basePath != null) {
            if (p.getFirst().equals(this.basePath)) {
                p = p.getStripFirst();
            } else {
                return null;
            }
        }
        if ((content = this.getClass().getResourceAsStream(p.toString())) == null) {
            return null;
        }
        log.trace("return class path resource");
        return new ClassPathResource(host, p, content);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public Long getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public void setMaxAgeSeconds(Long maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public class ClassPathResource
    implements GetableResource,
    DigestResource,
    PostableResource {
        private final String host;
        private final Path path;
        private final InputStream content;

        public ClassPathResource(String host, Path path, InputStream content) {
            this.host = host;
            this.path = path;
            this.content = content;
            if (content == null) {
                throw new IllegalArgumentException("content cannot be null");
            }
        }

        @Override
        public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
            try {
                IOUtils.copy((InputStream)this.content, (OutputStream)out);
            }
            catch (NullPointerException npe) {
                log.debug("NullPointerException, this is often expected");
            }
        }

        @Override
        public Long getMaxAgeSeconds(Auth auth) {
            return ClassPathResourceFactory.this.maxAgeSeconds;
        }

        @Override
        public String getContentType(String preferredList) {
            String mime = ContentTypeUtils.findContentTypes(this.path.getName());
            String s = ContentTypeUtils.findAcceptableContentType(mime, preferredList);
            if (log.isTraceEnabled()) {
                log.trace("getContentType: preferred: {} mime: {} selected: {}", new Object[]{preferredList, mime, s});
            }
            return s;
        }

        @Override
        public Long getContentLength() {
            return null;
        }

        @Override
        public String getUniqueId() {
            return null;
        }

        @Override
        public String getName() {
            return this.path.getName();
        }

        @Override
        public Object authenticate(String user, String password) {
            if (ClassPathResourceFactory.this.securityManager != null) {
                return ClassPathResourceFactory.this.securityManager.authenticate(user, password);
            }
            return "ok";
        }

        @Override
        public boolean authorise(Request request, Request.Method method, Auth auth) {
            if (ClassPathResourceFactory.this.securityManager != null) {
                return ClassPathResourceFactory.this.securityManager.authorise(request, method, auth, this);
            }
            return true;
        }

        @Override
        public String getRealm() {
            if (ClassPathResourceFactory.this.securityManager != null) {
                return ClassPathResourceFactory.this.securityManager.getRealm(this.host);
            }
            return this.host;
        }

        @Override
        public Date getModifiedDate() {
            return ClassPathResourceFactory.this.modifiedDate;
        }

        @Override
        public String checkRedirect(Request request) {
            return null;
        }

        @Override
        public Object authenticate(DigestResponse digestRequest) {
            if (ClassPathResourceFactory.this.securityManager != null) {
                return ClassPathResourceFactory.this.securityManager.authenticate(digestRequest);
            }
            return false;
        }

        @Override
        public boolean isDigestAllowed() {
            return true;
        }

        @Override
        public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException, ConflictException {
            return null;
        }
    }
}

