/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.io.IOException;
import java.lang.reflect.Field;
import org.basex.api.xmldb.BXCollectionManagementService;
import org.basex.api.xmldb.BXDatabase;
import org.basex.api.xmldb.BXQueryService;
import org.basex.api.xmldb.BXXMLDBText;
import org.basex.api.xmldb.BXXMLResource;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.xml.DOMWrapper;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.MetaData;
import org.basex.data.atomic.DataClip;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.w3c.dom.Document;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;

public final class BXCollection
implements Collection,
BXXMLDBText {
    final BXDatabase db;
    Context ctx;

    public BXCollection(String name, boolean open, Database d) throws XMLDBException {
        this.db = (BXDatabase)d;
        this.ctx = this.db.ctx;
        try {
            this.ctx.openDB(open ? Open.open((String)name, (Context)this.ctx) : CreateDB.create((String)name, (Parser)Parser.emptyParser((MainOptions)this.ctx.options), (Context)this.ctx));
        }
        catch (IOException ex) {
            throw new XMLDBException(1, ex.getMessage());
        }
    }

    public String getName() {
        return this.ctx.data().meta.name;
    }

    public Service[] getServices() throws XMLDBException {
        this.check();
        return new Service[]{this.getService("XPathQueryService", "1.0"), this.getService("XQueryQueryService", "1.0"), this.getService("CollectionManagementService", "1.0")};
    }

    public Service getService(String nm, String ver) throws XMLDBException {
        this.check();
        if ("1.0".equals(ver)) {
            if (Token.eq((String)nm, (String[])new String[]{"XPathQueryService", "XQueryQueryService"})) {
                return new BXQueryService(this, nm, ver);
            }
            if (nm.equals("CollectionManagementService")) {
                return new BXCollectionManagementService(this);
            }
        }
        return null;
    }

    public Collection getParentCollection() throws XMLDBException {
        this.check();
        return null;
    }

    public Collection getChildCollection(String name) throws XMLDBException {
        this.check();
        return null;
    }

    public int getChildCollectionCount() throws XMLDBException {
        this.check();
        return 0;
    }

    public String[] listChildCollections() throws XMLDBException {
        this.check();
        return new String[0];
    }

    public int getResourceCount() throws XMLDBException {
        this.check();
        return this.ctx.data().resources.docs().size();
    }

    public String[] listResources() throws XMLDBException {
        this.check();
        StringList sl = new StringList();
        Data data = this.ctx.data();
        IntList il = data.resources.docs();
        int is = il.size();
        for (int i = 0; i < is; ++i) {
            sl.add(Token.string((byte[])data.text(il.get(i), true)));
        }
        return sl.toArray();
    }

    public BXXMLResource createResource(String id, String type) throws XMLDBException {
        this.check();
        if (type.equals("XMLResource")) {
            String uid = id == null || id.isEmpty() ? this.createId() : id;
            return new BXXMLResource(null, 0, uid, this);
        }
        throw type.equals("BinaryResource") ? new XMLDBException(1, "Binary resources not supported.") : new XMLDBException(302, "Resource type is unknown: " + type);
    }

    public void removeResource(Resource res) throws XMLDBException {
        this.check();
        BXXMLResource del = BXCollection.checkXML(res);
        Data data = this.ctx.data();
        if (del.data != data && del.data != null) {
            throw new XMLDBException(300, "Unknown Resource: " + data.meta.name);
        }
        if (!data.startUpdate()) {
            throw new XMLDBException(1, "Database cannot be marked as 'updating'.");
        }
        data.delete(this.getResource((String)del.getId()).pos);
        this.ctx.update();
        data.finishUpdate();
    }

    public void storeResource(Resource res) throws XMLDBException {
        MemData md;
        this.check();
        BXXMLResource xml = BXCollection.checkXML(res);
        if (res.getContent() == null) {
            throw new XMLDBException(301, "Resource has no contents.");
        }
        String id = res.getId();
        if (id == null) {
            throw new XMLDBException(301, "Resource has no ID.");
        }
        BXXMLResource old = this.getResource(id);
        if (old != null) {
            this.removeResource((Resource)this.getResource(id));
        }
        Object cont = xml.content;
        try {
            DOMWrapper p = cont instanceof Document ? new DOMWrapper((Document)cont, id, this.ctx.options) : Parser.singleParser((IO)new IOContent((byte[])cont, id), (MainOptions)this.ctx.options, (String)"");
            md = MemBuilder.build((String)id, (Parser)p);
        }
        catch (IOException ex) {
            throw new XMLDBException(301, ex.getMessage());
        }
        Data data = this.ctx.data();
        if (!data.startUpdate()) {
            throw new XMLDBException(1, "Database cannot be marked as 'updating'.");
        }
        data.insert(data.meta.size, -1, new DataClip((Data)md));
        this.ctx.update();
        data.finishUpdate();
    }

    public BXXMLResource getResource(String id) throws XMLDBException {
        this.check();
        if (id == null) {
            return null;
        }
        Data data = this.ctx.data();
        int pre = data.resources.doc(id);
        return pre == -1 ? null : new BXXMLResource(data, pre, id, this);
    }

    public String createId() throws XMLDBException {
        String id;
        String[] res = this.listResources();
        while (BXCollection.exists(res, id = Long.toString(System.currentTimeMillis()))) {
        }
        return id;
    }

    public boolean isOpen() {
        return this.ctx != null;
    }

    public void close() {
        if (this.ctx != null) {
            this.ctx.close();
        }
        this.ctx = null;
    }

    public String getProperty(String key) throws XMLDBException {
        this.check();
        try {
            return MetaData.class.getField(key).get(this.ctx.data().meta).toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setProperty(String key, String val) throws XMLDBException {
        this.check();
        try {
            MetaData md = this.ctx.data().meta;
            Field f = MetaData.class.getField(key);
            Object k = f.get(md);
            if (k instanceof Boolean) {
                boolean b = val == null ? !((Boolean)k).booleanValue() : val.equalsIgnoreCase("true");
                f.setBoolean(md, b);
            } else if (k instanceof Integer) {
                f.setInt(md, Integer.parseInt(val));
            } else {
                f.set(md, val);
            }
        }
        catch (Exception ex) {
            throw new XMLDBException(1, "Property could not be set: " + key);
        }
    }

    private static boolean exists(String[] list, String id) {
        for (String l : list) {
            if (!l.equals(id)) continue;
            return true;
        }
        return false;
    }

    private void check() throws XMLDBException {
        if (this.ctx == null) {
            throw new XMLDBException(202);
        }
    }

    private static BXXMLResource checkXML(Resource res) throws XMLDBException {
        if (!(res instanceof BXXMLResource)) {
            throw new XMLDBException(300, "Unknown Resource: " + res);
        }
        return (BXXMLResource)res;
    }
}

