/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.util.Locale;
import org.basex.api.xmldb.BXCollection;
import org.basex.api.xmldb.BXXMLDBText;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.core.cmd.Get;
import org.basex.core.cmd.Set;
import org.basex.util.Prop;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.XMLDBException;

public final class BXDatabase
implements Database,
BXXMLDBText {
    public final Context ctx = new Context();

    public boolean acceptsURI(String uri) throws XMLDBException {
        this.getCollectionName(uri);
        return true;
    }

    public Collection getCollection(String uri, String user, String password) throws XMLDBException {
        String name = this.getCollectionName(uri);
        boolean exists = this.ctx.globalopts.dbexists(name);
        return exists ? new BXCollection(name, true, this) : null;
    }

    public String getConformanceLevel() {
        return "0";
    }

    public String getName() {
        return Prop.PROJECT_NAME;
    }

    public String getProperty(String key) {
        try {
            return Get.get((String)key.toUpperCase(Locale.ENGLISH), (Context)this.ctx);
        }
        catch (BaseXException ex) {
            return null;
        }
    }

    public void setProperty(String key, String value) throws XMLDBException {
        try {
            new Set(key, (Object)value).execute(this.ctx);
        }
        catch (BaseXException ex) {
            throw new XMLDBException(1, "Property could not be set: " + key);
        }
    }

    private String getCollectionName(String uri) throws XMLDBException {
        if (uri != null) {
            String localhost;
            String host;
            String main;
            String string = main = uri.startsWith("xmldb:") ? uri : "xmldb:" + uri;
            if (main.startsWith(XMLDBURI) && (host = main.substring(XMLDBURI.length())).startsWith(localhost = "localhost:" + this.ctx.globalopts.get(GlobalOptions.SERVERPORT) + '/')) {
                return host.substring(localhost.length());
            }
        }
        throw new XMLDBException(5, "Invalid URI: " + uri);
    }
}

