/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import org.basex.build.JsonOptions;
import org.basex.build.JsonParserOptions;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Replace;
import org.basex.core.cmd.Store;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPContext;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTExec;
import org.basex.http.rest.RESTSession;
import org.basex.io.MimeTypes;
import org.basex.util.options.Options;

final class RESTPut {
    private RESTPut() {
    }

    public static RESTExec get(RESTSession rs) throws IOException {
        HTTPContext http = rs.http;
        if (http.depth() == 0) {
            throw HTTPCode.NO_PATH.get(new Object[0]);
        }
        RESTCmd.parseOptions(rs);
        boolean xml = true;
        ServletInputStream is = http.req.getInputStream();
        String ct = http.contentType();
        MainOptions.MainParser parser = null;
        if (MimeTypes.isJSON((String)ct)) {
            parser = MainOptions.MainParser.JSON;
            if ("application/jsonml+json".equals(ct)) {
                JsonParserOptions jopts = new JsonParserOptions();
                jopts.set(JsonOptions.FORMAT, (Enum)JsonOptions.JsonFormat.JSONML);
                rs.context.options.set(MainOptions.JSONPARSER, (Options)jopts);
            }
        } else if ("text/comma-separated-values".equals(ct)) {
            parser = MainOptions.MainParser.CSV;
        } else if ("text/html".equals(ct)) {
            parser = MainOptions.MainParser.HTML;
        } else if (ct != null && MimeTypes.isText((String)ct)) {
            parser = MainOptions.MainParser.TEXT;
        } else if (ct != null && !MimeTypes.isXML((String)ct)) {
            xml = false;
        }
        if (parser != null) {
            rs.context.options.set(MainOptions.PARSER, (Enum)parser);
        }
        String db = http.db();
        if (http.depth() == 1) {
            if (xml) {
                rs.add((Command)new CreateDB(db), (InputStream)is);
            } else {
                rs.add((Command)new CreateDB(db));
                rs.add((Command)new Store(db), (InputStream)is);
            }
        } else {
            rs.add((Command)new Open(db));
            String path = http.dbpath();
            if (xml) {
                rs.add((Command)new Replace(path), (InputStream)is);
            } else {
                rs.add((Command)new Delete(path));
                rs.add((Command)new Store(path), (InputStream)is);
            }
        }
        RESTExec cmd = new RESTExec(rs);
        cmd.code = HTTPCode.CREATED_X;
        return cmd;
    }
}

