/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.http.HTTPContext;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqResponse;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StaticFunc;
import org.basex.query.util.Err;
import org.basex.util.Token;

final class RestXqModule {
    private final ArrayList<RestXqFunction> functions = new ArrayList();
    private final IOFile file;
    private long time;

    RestXqModule(IOFile in) {
        this.file = in;
        this.time = in.timeStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean parse(HTTPContext http) throws Exception {
        this.functions.clear();
        QueryContext qc = this.parseModule(http);
        try {
            for (StaticFunc uf : qc.funcs.funcs()) {
                RestXqFunction rxf;
                if (!this.file.name().equals(new IOFile(uf.info.path()).name()) || !(rxf = new RestXqFunction(uf, qc, this)).parse()) continue;
                this.functions.add(rxf);
            }
        }
        finally {
            qc.close();
        }
        return !this.functions.isEmpty();
    }

    boolean uptodate() {
        return this.time == this.file.timeStamp();
    }

    void touch() {
        this.time = this.file.timeStamp();
    }

    ArrayList<RestXqFunction> functions() {
        return this.functions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(HTTPContext http, RestXqFunction func, QueryException error) throws Exception {
        QueryContext qc = this.parseModule(http);
        try {
            for (StaticFunc uf : qc.funcs.funcs()) {
                if (!func.function.info.equals((Object)uf.info)) continue;
                RestXqFunction rxf = new RestXqFunction(uf, qc, this);
                rxf.parse();
                new RestXqResponse(rxf, qc, http, error).create();
                break;
            }
        }
        finally {
            qc.close();
        }
    }

    private QueryContext parseModule(HTTPContext http) throws QueryException {
        QueryContext qc = new QueryContext(http.context());
        try {
            qc.parse(Token.string((byte[])this.file.read()), this.file.path(), null);
            return qc;
        }
        catch (IOException ex) {
            throw Err.IOERR.get(null, new Object[]{ex});
        }
    }
}

