/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.basex.core.GlobalOptions;
import org.basex.http.HTTPContext;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqModule;
import org.basex.http.restxq.RestXqWadl;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.util.Prop;
import org.basex.util.TokenBuilder;

public final class RestXqModules {
    private static final RestXqModules INSTANCE = new RestXqModules();
    private HashMap<String, RestXqModule> modules = new HashMap();
    private IOFile restxq;

    private RestXqModules() {
    }

    public static RestXqModules get() {
        return INSTANCE;
    }

    public FElem wadl(HTTPContext http) {
        return new RestXqWadl(http).create(this.modules);
    }

    RestXqFunction find(HTTPContext http, QNm error) throws Exception {
        this.cache(http);
        ArrayList<RestXqFunction> list = new ArrayList<RestXqFunction>();
        for (RestXqModule mod : this.modules.values()) {
            for (RestXqFunction rxf : mod.functions()) {
                if (!rxf.matches(http, error)) continue;
                list.add(rxf);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        RestXqFunction first = (RestXqFunction)list.get(0);
        if (list.size() > 1) {
            Collections.sort(list);
            first = (RestXqFunction)list.get(0);
            if (first.compareTo((RestXqFunction)list.get(1)) == 0) {
                TokenBuilder tb = new TokenBuilder();
                for (RestXqFunction rxf : list) {
                    if (first.compareTo(rxf) != 0) break;
                    tb.add(Prop.NL).add(rxf.function.info.toString());
                }
                throw first.path == null ? first.error("Error \"%\" matched by several functions:%", error, tb) : first.error("Path \"%\" assigned to several functions:%", first.path, tb);
            }
        }
        return first;
    }

    private synchronized void cache(HTTPContext http) throws Exception {
        if (this.restxq == null) {
            File fl = new File(http.context().globalopts.get(GlobalOptions.RESTXQPATH));
            this.restxq = fl.isAbsolute() ? new IOFile(fl) : new IOFile(http.context().globalopts.get(GlobalOptions.WEBPATH), fl.getPath());
        }
        HashMap<String, RestXqModule> cache = new HashMap<String, RestXqModule>();
        this.cache(http, this.restxq, cache);
        this.modules = cache;
    }

    private synchronized void cache(HTTPContext http, IOFile root, HashMap<String, RestXqModule> cache) throws Exception {
        for (IOFile file : root.children()) {
            if (file.isDir()) {
                this.cache(http, file, cache);
                continue;
            }
            String path = file.path();
            if (!file.hasSuffix(IO.XQSUFFIXES)) continue;
            RestXqModule module = this.modules.get(path);
            boolean parsed = false;
            if (module != null) {
                parsed = module.uptodate();
            } else {
                module = new RestXqModule(file);
            }
            if (!parsed && !module.parse(http)) continue;
            module.touch();
            cache.put(path, module);
        }
    }
}

