/*
 * Decompiled with CFR 0.152.
 */
package org.expath.ns;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.io.gml2.GMLReader;
import com.vividsolutions.jts.io.gml2.GMLWriter;
import java.io.IOException;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.xml.XMLParser;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.util.Err;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.expath.ns.GeoErrors;

public final class Geo
extends QueryModule {
    private static final byte[] URI = Token.token((String)"http://www.opengis.net/gml");
    private static final String GML = "gml";
    private static final QNm Q_GML_POINT = QNm.get((String)"gml", (String)"Point", (byte[])URI);
    private static final QNm Q_GML_MULTIPOINT = QNm.get((String)"gml", (String)"MultiPoint", (byte[])URI);
    private static final QNm Q_GML_LINESTRING = QNm.get((String)"gml", (String)"LineString", (byte[])URI);
    private static final QNm Q_GML_LINEARRING = QNm.get((String)"gml", (String)"LinearRing", (byte[])URI);
    private static final QNm Q_GML_POLYGON = QNm.get((String)"gml", (String)"Polygon", (byte[])URI);
    private static final QNm Q_GML_MULTIPOLYGON = QNm.get((String)"gml", (String)"MultiPolygon", (byte[])URI);
    private static final QNm Q_GML_MULTILINESTRING = QNm.get((String)"gml", (String)"MultiLineString", (byte[])URI);
    private static final QNm[] QNAMES = new QNm[]{Q_GML_POINT, Q_GML_LINESTRING, Q_GML_POLYGON, Q_GML_MULTIPOINT, Q_GML_MULTILINESTRING, Q_GML_MULTIPOLYGON, Q_GML_LINEARRING};

    @QueryModule.Deterministic
    public Int dimension(ANode node) throws QueryException {
        return Int.get((long)this.checkGeo(node).getDimension());
    }

    @QueryModule.Deterministic
    public QNm geometryType(ANode node) throws QueryException {
        return new QNm("gml:" + this.checkGeo(node).getGeometryType(), URI);
    }

    @QueryModule.Deterministic
    public Uri srid(ANode node) throws QueryException {
        return Uri.uri((byte[])Token.token((int)this.checkGeo(node).getSRID()));
    }

    @QueryModule.Deterministic
    public ANode envelope(ANode node) throws QueryException {
        return this.gmlWriter(this.checkGeo(node).getEnvelope());
    }

    @QueryModule.Deterministic
    public Str asText(ANode node) throws QueryException {
        return Str.get((String)new WKTWriter().write(this.checkGeo(node)));
    }

    @QueryModule.Deterministic
    public B64 asBinary(ANode node) throws QueryException {
        return new B64(new WKBWriter().write(this.checkGeo(node)));
    }

    @QueryModule.Deterministic
    public Bln isEmpty(ANode node) throws QueryException {
        return Bln.get((node != null && this.checkGeo(node) != null ? 1 : 0) != 0);
    }

    @QueryModule.Deterministic
    public Bln isSimple(ANode node) throws QueryException {
        return Bln.get((boolean)this.checkGeo(node).isSimple());
    }

    @QueryModule.Deterministic
    public ANode boundary(ANode node) throws QueryException {
        return this.gmlWriter(this.checkGeo(node).getBoundary());
    }

    @QueryModule.Deterministic
    public Bln equals(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return Bln.get((boolean)geo1.equals(geo2));
    }

    @QueryModule.Deterministic
    public Bln disjoint(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return Bln.get((boolean)geo1.disjoint(geo2));
    }

    @QueryModule.Deterministic
    public Bln intersects(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return Bln.get((boolean)geo1.intersects(geo2));
    }

    @QueryModule.Deterministic
    public Bln touches(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return Bln.get((boolean)geo1.touches(geo2));
    }

    @QueryModule.Deterministic
    public Bln crosses(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return Bln.get((boolean)geo1.crosses(geo2));
    }

    @QueryModule.Deterministic
    public Bln within(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return Bln.get((boolean)geo1.within(geo2));
    }

    @QueryModule.Deterministic
    public Bln contains(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return Bln.get((boolean)geo1.contains(geo2));
    }

    @QueryModule.Deterministic
    public Bln overlaps(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return Bln.get((boolean)geo1.overlaps(geo2));
    }

    @QueryModule.Deterministic
    public Bln relate(ANode node1, ANode node2, Str intersectionMatrix) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return Bln.get((boolean)geo1.relate(geo2, intersectionMatrix.toJava()));
    }

    @QueryModule.Deterministic
    public Dbl distance(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return Dbl.get((double)geo1.distance(geo2));
    }

    @QueryModule.Deterministic
    public ANode buffer(ANode node, Dbl distance) throws QueryException {
        return this.gmlWriter(this.checkGeo(node).buffer(distance.dbl()));
    }

    @QueryModule.Deterministic
    public ANode convexHull(ANode node) throws QueryException {
        return this.gmlWriter(this.checkGeo(node).convexHull());
    }

    @QueryModule.Deterministic
    public ANode intersection(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return this.gmlWriter(geo1.intersection(geo2));
    }

    @QueryModule.Deterministic
    public ANode union(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return this.gmlWriter(geo1.union(geo2));
    }

    @QueryModule.Deterministic
    public ANode difference(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return this.gmlWriter(geo1.difference(geo2));
    }

    @QueryModule.Deterministic
    public ANode symDifference(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = this.checkGeo(node1);
        Geometry geo2 = this.checkGeo(node2);
        return this.gmlWriter(geo1.symDifference(geo2));
    }

    @QueryModule.Deterministic
    public Int numGeometries(ANode node) throws QueryException {
        return Int.get((long)this.checkGeo(node).getNumGeometries());
    }

    @QueryModule.Deterministic
    public ANode geometryN(ANode node, Int number) throws QueryException {
        Geometry geo = this.checkGeo(node);
        long n = number.itr();
        if (n < 1L || n > (long)geo.getNumGeometries()) {
            throw GeoErrors.outOfRangeIdx(number);
        }
        return this.gmlWriter(geo.getGeometryN((int)n - 1));
    }

    @QueryModule.Deterministic
    public Dbl x(ANode node) throws QueryException {
        Geometry geo = this.geo(node, Q_GML_POINT);
        if (geo == null && this.checkGeo(node) != null) {
            throw GeoErrors.geoType(node.qname().local(), "Point");
        }
        return Dbl.get((double)geo.getCoordinate().x);
    }

    @QueryModule.Deterministic
    public Dbl y(ANode node) throws QueryException {
        Geometry geo = this.geo(node, Q_GML_POINT);
        if (geo == null && this.checkGeo(node) != null) {
            throw GeoErrors.geoType(node.qname().local(), "Point");
        }
        return Dbl.get((double)geo.getCoordinate().y);
    }

    @QueryModule.Deterministic
    public Dbl z(ANode node) throws QueryException {
        Geometry geo = this.geo(node, Q_GML_POINT);
        if (geo == null && this.checkGeo(node) != null) {
            throw GeoErrors.geoType(node.qname().local(), "Line");
        }
        return Dbl.get((double)geo.getCoordinate().z);
    }

    @QueryModule.Deterministic
    public Dbl length(ANode node) throws QueryException {
        return Dbl.get((double)this.checkGeo(node).getLength());
    }

    @QueryModule.Deterministic
    public ANode startPoint(ANode node) throws QueryException {
        Geometry geo = this.geo(node, Q_GML_LINEARRING, Q_GML_LINESTRING);
        if (geo == null && this.checkGeo(node) != null) {
            throw GeoErrors.geoType(node.qname().local(), "Line");
        }
        return this.gmlWriter((Geometry)((LineString)geo).getStartPoint());
    }

    @QueryModule.Deterministic
    public ANode endPoint(ANode node) throws QueryException {
        Geometry geo = this.geo(node, Q_GML_LINEARRING, Q_GML_LINESTRING);
        if (geo == null && this.checkGeo(node) != null) {
            throw GeoErrors.geoType(node.qname().local(), "Line");
        }
        return this.gmlWriter((Geometry)((LineString)geo).getEndPoint());
    }

    @QueryModule.Deterministic
    public Bln isClosed(ANode node) throws QueryException {
        Geometry geo = this.geo(node, Q_GML_LINEARRING, Q_GML_LINESTRING, Q_GML_MULTILINESTRING);
        if (geo == null && this.checkGeo(node) != null) {
            throw GeoErrors.geoType(node.qname().local(), "Line");
        }
        return Bln.get((boolean)(geo instanceof LineString ? ((LineString)geo).isClosed() : ((MultiLineString)geo).isClosed()));
    }

    @QueryModule.Deterministic
    public Bln isRing(ANode node) throws QueryException {
        Geometry geo = this.geo(node, Q_GML_LINEARRING, Q_GML_LINESTRING);
        if (geo == null && this.checkGeo(node) != null) {
            throw GeoErrors.geoType(node.qname().local(), "Line");
        }
        return Bln.get((boolean)((LineString)geo).isRing());
    }

    @QueryModule.Deterministic
    public Int numPoints(ANode node) throws QueryException {
        return Int.get((long)this.checkGeo(node).getNumPoints());
    }

    @QueryModule.Deterministic
    public ANode pointN(ANode node, Int number) throws QueryException {
        Geometry geo = this.geo(node, Q_GML_LINEARRING, Q_GML_LINESTRING);
        if (geo == null && this.checkGeo(node) != null) {
            throw GeoErrors.geoType(node.qname().local(), "Line");
        }
        int max = geo.getNumPoints();
        long n = number.itr();
        if (n < 1L || n > (long)max) {
            throw GeoErrors.outOfRangeIdx(number);
        }
        return this.gmlWriter((Geometry)((LineString)geo).getPointN((int)n - 1));
    }

    @QueryModule.Deterministic
    public Dbl area(ANode node) throws QueryException {
        return Dbl.get((double)this.checkGeo(node).getArea());
    }

    @QueryModule.Deterministic
    public ANode centroid(ANode node) throws QueryException {
        return this.gmlWriter((Geometry)this.checkGeo(node).getCentroid());
    }

    @QueryModule.Deterministic
    public ANode pointOnSurface(ANode node) throws QueryException {
        return this.gmlWriter((Geometry)this.checkGeo(node).getInteriorPoint());
    }

    @QueryModule.Deterministic
    public ANode exteriorRing(ANode node) throws QueryException {
        Geometry geo = this.geo(node, Q_GML_POLYGON);
        if (geo == null && this.checkGeo(node) != null) {
            throw GeoErrors.geoType(node.qname().local(), "Polygon");
        }
        return this.gmlWriter((Geometry)((Polygon)geo).getExteriorRing());
    }

    @QueryModule.Deterministic
    public Int numInteriorRing(ANode node) throws QueryException {
        Geometry geo = this.geo(node, Q_GML_POLYGON);
        if (geo == null && this.checkGeo(node) != null) {
            throw GeoErrors.geoType(node.qname().local(), "Polygon");
        }
        return Int.get((long)((Polygon)geo).getNumInteriorRing());
    }

    @QueryModule.Deterministic
    public ANode interiorRingN(ANode node, Int number) throws QueryException {
        Geometry geo = this.geo(node, Q_GML_POLYGON);
        if (geo == null && this.checkGeo(node) != null) {
            throw GeoErrors.geoType(node.qname().local(), "Polygon");
        }
        long n = number.itr();
        int max = ((Polygon)geo).getNumInteriorRing();
        if (n < 1L || n > (long)max) {
            throw GeoErrors.outOfRangeIdx(number);
        }
        return this.gmlWriter((Geometry)((Polygon)geo).getInteriorRingN((int)n - 1));
    }

    private Geometry checkGeo(ANode node) throws QueryException {
        Geometry geo = this.geo(node, QNAMES);
        if (geo == null) {
            throw GeoErrors.unrecognizedGeo(node.qname().local());
        }
        return geo;
    }

    private Geometry geo(ANode node, QNm ... names) throws QueryException {
        if (node.type != NodeType.ELM) {
            throw Err.FUNCMP.get(null, new Object[]{this, NodeType.ELM, node.type});
        }
        QNm qname = node.qname();
        for (QNm geo : names) {
            if (!qname.eq(geo)) continue;
            try {
                String input = node.serialize().toString();
                GMLReader gmlReader = new GMLReader();
                GeometryFactory geoFactory = new GeometryFactory();
                return gmlReader.read(input, geoFactory);
            }
            catch (Throwable ex) {
                throw GeoErrors.gmlReaderErr(ex);
            }
        }
        return null;
    }

    private DBNode gmlWriter(Geometry geometry) throws QueryException {
        String geo;
        try {
            geo = new GMLWriter().write(geometry).replaceAll("^<gml:(.*?)>", "<gml:$1 xmlns:gml='" + Token.string((byte[])URI) + "'>");
        }
        catch (Exception ex) {
            throw GeoErrors.gmlWriterErr(ex);
        }
        try {
            IOContent io = new IOContent(geo);
            return new DBNode((Data)MemBuilder.build((Parser)new XMLParser((IO)io, this.queryContext.context.options)));
        }
        catch (IOException ex) {
            throw Err.IOERR.get(null, new Object[]{ex});
        }
    }
}

