/*
 * Decompiled with CFR 0.152.
 */
package org.expath.ns;

import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.QNm;
import org.basex.util.TokenBuilder;

final class GeoErrors {
    private static final byte[] NS = QueryText.EXPERROR;
    private static final String PREFIX = new TokenBuilder(QueryText.EXPERR).add(":GEO").toString();

    private GeoErrors() {
    }

    static QueryException unrecognizedGeo(byte[] name) {
        return GeoErrors.thrw(1, "Unrecognized Geo type: %", new Object[]{name});
    }

    static QueryException gmlReaderErr(Throwable th) {
        return GeoErrors.thrw(2, "Parsing GML 2.0: %", th);
    }

    static QueryException geoType(byte[] name, String geo) {
        return GeoErrors.thrw(3, "% is not an appropiate geometry for this function. The input geometry should be a %.", name, geo);
    }

    static QueryException outOfRangeIdx(Int geoNumber) {
        return GeoErrors.thrw(4, "Out of range input index: %", geoNumber);
    }

    static QueryException gmlWriterErr(Throwable th) {
        return GeoErrors.thrw(5, "%", th);
    }

    static QNm qname(int code) {
        return new QNm(String.format("%s:GEO%04d", PREFIX, code), NS);
    }

    private static QueryException thrw(int code, String msg, Object ... ext) {
        return new QueryException(null, GeoErrors.qname(code), msg, ext);
    }
}

