/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.BuildException;
import org.basex.build.Parser;
import org.basex.core.Proc;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Namespaces;
import org.basex.index.name.Names;
import org.basex.index.path.PathSummary;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public abstract class Builder
extends Proc {
    final PathSummary path = new PathSummary();
    final Namespaces ns = new Namespaces();
    final Parser parser;
    final String dbname;
    int ssize;
    int spos;
    MetaData meta;
    Names tags;
    Names atts;
    private final IntList pstack = new IntList();
    private final IntList tstack = new IntList();
    private int level;

    Builder(String name, Parser parse) {
        this.parser = parse;
        this.dbname = name;
    }

    final void parse() throws IOException {
        this.parser.parse(this);
        this.meta.lastid = this.meta.size - 1;
    }

    public final void openDoc(byte[] value) throws IOException {
        this.path.put(0, (byte)0, this.level);
        this.pstack.set(this.level++, this.meta.size);
        this.addDoc(value);
        this.ns.prepare();
    }

    public final void closeDoc() throws IOException {
        int pre = this.pstack.get(--this.level);
        this.setSize(pre, this.meta.size - pre);
        ++this.meta.ndocs;
        this.ns.close(this.meta.size);
    }

    public final void openElem(byte[] nm, Atts att, Atts nsp) throws IOException {
        this.addElem(nm, att, nsp);
        ++this.level;
    }

    public final void emptyElem(byte[] nm, Atts att, Atts nsp) throws IOException {
        this.addElem(nm, att, nsp);
        int pre = this.pstack.get(this.level);
        this.ns.close(pre);
        if (att.size() > 31) {
            this.setSize(pre, this.meta.size - pre);
        }
    }

    public final void closeElem() throws IOException {
        this.checkStop();
        --this.level;
        int pre = this.pstack.get(this.level);
        this.setSize(pre, this.meta.size - pre);
        this.ns.close(pre);
    }

    public final void text(byte[] value) throws IOException {
        if (value.length != 0) {
            this.addText(value, (byte)2);
        }
    }

    public final void comment(byte[] value) throws IOException {
        this.addText(value, (byte)4);
    }

    public final void pi(byte[] pi) throws IOException {
        this.addText(pi, (byte)5);
    }

    public final void encoding(String enc) {
        this.meta.encoding = Token.normEncoding(enc);
    }

    @Override
    protected final String tit() {
        return Text.CREATING_DB;
    }

    @Override
    public final String det() {
        return this.spos == 0 ? this.parser.detail() : Text.FINISHING_D;
    }

    @Override
    public final double prog() {
        return this.spos == 0 ? this.parser.progress() : (double)this.spos / (double)this.ssize;
    }

    public abstract Data build() throws IOException;

    public abstract void close() throws IOException;

    protected abstract void addDoc(byte[] var1) throws IOException;

    protected abstract void addElem(int var1, int var2, int var3, int var4, boolean var5) throws IOException;

    protected abstract void addAttr(int var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void addText(byte[] var1, int var2, byte var3) throws IOException;

    protected abstract void setSize(int var1, int var2) throws IOException;

    private void addElem(byte[] name, Atts att, Atts nsp) throws IOException {
        int n = this.tags.index(name, null, true);
        this.path.put(n, (byte)1, this.level);
        int pre = this.meta.size;
        this.tstack.set(this.level, n);
        this.pstack.set(this.level, pre);
        this.ns.prepare();
        int nl = nsp.size();
        for (int nx = 0; nx < nl; ++nx) {
            this.ns.add(nsp.name(nx), nsp.value(nx), this.meta.size);
        }
        int dis = this.level == 0 ? 1 : pre - this.pstack.get(this.level - 1);
        int as = att.size();
        int u = this.ns.uri(name, true);
        if (u == 0 && Token.indexOf(name, 58) != -1 && !Token.eq(Token.prefix(name), Token.XML)) {
            throw new BuildException("%: Undeclared namespace prefix '%'.", this.parser.detail(), Token.prefix(name));
        }
        this.addElem(dis, n, Math.min(31, as + 1), u, nl != 0);
        for (int a = 0; a < as; ++a) {
            byte[] av = att.value(a);
            byte[] an = att.name(a);
            n = this.atts.index(an, av, true);
            u = this.ns.uri(an, false);
            if (u == 0 && Token.indexOf(an, 58) != -1 && !Token.eq(Token.prefix(an), Token.XML)) {
                throw new BuildException("%: Undeclared namespace prefix '%'.", this.parser.detail(), an);
            }
            this.path.put(n, (byte)3, this.level + 1, av, this.meta);
            this.addAttr(n, av, Math.min(31, a + 1), u);
        }
        if (this.level > 1) {
            this.tags.stat(this.tstack.get(this.level - 1)).setLeaf(false);
        }
        this.limit(this.tags.size(), 32768, "%: Too many different element names (limit: %).");
        this.limit(this.atts.size(), 32768, "%: Too many different attribute names (limit: %).");
        this.limit(this.ns.size(), 256, "%: Too many different namespaces (limit: %).");
        if (this.meta.size < 0) {
            this.limit(0, 0, "%: Input is too large for a single database.");
        }
    }

    private void limit(int value, int limit, String msg) throws IOException {
        if (value >= limit) {
            throw new BuildException(msg, this.parser.detail(), limit);
        }
    }

    private void addText(byte[] value, byte kind) throws IOException {
        int l = this.level;
        if (l > 1) {
            int tag = this.tstack.get(l - 1);
            if (kind == 2) {
                this.tags.index(tag, value);
            } else {
                this.tags.stat(tag).setLeaf(false);
            }
        }
        this.path.put(0, kind, l, value, this.meta);
        this.addText(value, l == 0 ? 1 : this.meta.size - this.pstack.get(l - 1), kind);
    }
}

