/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.util.Locale;
import org.basex.core.BaseXException;
import org.basex.util.XMLToken;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.EnumOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public class CsvOptions
extends Options {
    public static final StringOption SEPARATOR = new StringOption("separator", CsvSep.COMMA.toString());
    public static final EnumOption<CsvFormat> FORMAT = new EnumOption<CsvFormat>("format", CsvFormat.DIRECT);
    public static final BooleanOption HEADER = new BooleanOption("header", false);
    public static final BooleanOption LAX = new BooleanOption("lax", true);
    public static final BooleanOption QUOTES = new BooleanOption("quotes", true);

    @Override
    public synchronized void assign(String name, String value) throws BaseXException {
        super.assign(name, value);
        if (this.options.get(name) == SEPARATOR && this.separator() == -1) {
            throw new BaseXException("Separator must be single character; '%' found", value);
        }
    }

    public int separator() {
        char ch;
        String sep = this.get(SEPARATOR);
        for (CsvSep s : CsvSep.values()) {
            if (!sep.equals(s.toString())) continue;
            return s.sep;
        }
        if (sep.length() == 1 && XMLToken.valid(ch = sep.charAt(0))) {
            return ch;
        }
        return -1;
    }

    public static enum CsvSep {
        COMMA(','),
        SEMICOLON(';'),
        COLON(':'),
        TAB('\t'),
        SPACE(' ');

        public final char sep;

        private CsvSep(char sp) {
            this.sep = sp;
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum CsvFormat {
        DIRECT,
        ATTRIBUTES,
        MAP;


        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }
    }
}

