/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.SingleParser;
import org.basex.build.TextOptions;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public final class TextParser
extends SingleParser {
    private static final byte[] TEXT = Token.token("text");
    private static final byte[] LINE = Token.token("line");
    private final boolean lines;
    private final String encoding;

    public TextParser(IO source, MainOptions opts) {
        super(source, opts);
        TextOptions tp = opts.get(MainOptions.TEXTPARSER);
        this.lines = tp.get(TextOptions.LINES);
        this.encoding = tp.get(TextOptions.ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse() throws IOException {
        this.builder.openElem(TEXT, this.atts, this.nsp);
        TokenBuilder tb = new TokenBuilder();
        NewlineInput nli = new NewlineInput(this.src).encoding(this.encoding);
        try {
            int ch;
            while ((ch = nli.read()) != -1) {
                if (ch == 10 && this.lines) {
                    this.builder.openElem(LINE, this.atts, this.nsp);
                    this.builder.text(tb.finish());
                    this.builder.closeElem();
                    tb.reset();
                    continue;
                }
                tb.add(XMLToken.valid(ch) ? ch : 63);
            }
        }
        finally {
            nli.close();
        }
        if (!this.lines) {
            this.builder.text(tb.finish());
        }
        this.builder.closeElem();
    }
}

