/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Exit;
import org.basex.core.cmd.XQuery;
import org.basex.core.parse.CommandParser;
import org.basex.core.parse.PasswordReader;
import org.basex.query.QueryException;
import org.basex.server.LocalSession;
import org.basex.server.Session;
import org.basex.util.Main;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class CLI
extends Main {
    public final Context context;
    protected OutputStream out = System.out;
    protected boolean verbose;
    protected boolean newline;
    private final PasswordReader pwReader = new PasswordReader(){

        @Override
        public String password() {
            Util.out(Text.PASSWORD + ": ", new Object[0]);
            return Token.md5(Util.password());
        }
    };
    private Session session;

    protected CLI(String[] args) throws IOException {
        this(args, null);
    }

    protected CLI(String[] args, Context ctx) throws IOException {
        super(args);
        this.context = ctx != null ? ctx : new Context();
        this.parseArgs();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public synchronized void run() {
                CLI.this.context.close();
            }
        });
    }

    protected final void execute(String in) throws IOException {
        this.execute(new CommandParser(in, this.context).pwReader(this.pwReader));
    }

    protected final boolean execute(CommandParser parser) throws IOException {
        try {
            for (Command cmd : parser.parse()) {
                if (cmd instanceof Exit) {
                    return false;
                }
                this.execute(cmd, this.verbose);
            }
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
        return true;
    }

    protected final void execute(Command cmd, boolean info) throws IOException {
        Session ss = this.session();
        ss.execute(cmd);
        if (this.newline && cmd instanceof XQuery) {
            this.out.write(Token.token(Text.NL));
        }
        if (info) {
            Util.out(ss.info(), new Object[0]);
        }
    }

    protected final Session session() throws IOException {
        if (this.session == null) {
            this.session = this.init();
        }
        this.session.setOutputStream(this.out);
        return this.session;
    }

    protected Session init() throws IOException {
        return new LocalSession(this.context, this.out);
    }
}

