/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.LockResult;
import org.basex.core.Perm;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Open;
import org.basex.data.MetaData;
import org.basex.util.QueryInput;

public final class Check
extends Command {
    public Check(String path) {
        super(Perm.NONE, path);
    }

    @Override
    protected boolean run() {
        new Close().run(this.context);
        QueryInput qi = new QueryInput(this.args[0]);
        qi.db = qi.input.dbname();
        Command cmd = this.open(qi) ? new Open(qi.db) : new CreateDB(qi.db, qi.input.exists() ? qi.original : null);
        this.proc(cmd);
        boolean ok = cmd.run(this.context);
        String msg = cmd.info().trim();
        return ok ? this.info(msg, new Object[0]) : this.error(msg, new Object[0]);
    }

    private boolean open(QueryInput qi) {
        if (!this.context.user.has(Perm.CREATE)) {
            return true;
        }
        if (!this.goptions.dbpath(qi.db).exists()) {
            return false;
        }
        if (!qi.input.exists()) {
            return true;
        }
        MetaData meta = new MetaData(qi.db, this.context);
        try {
            meta.read();
            return meta.time == qi.input.timeStamp();
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    public boolean stoppable() {
        return true;
    }

    @Override
    public void databases(LockResult lr) {
        lr.read.add("%CTX").add(new QueryInput((String)this.args[0]).input.dbname());
    }

    @Override
    public boolean newData(Context ctx) {
        return new Close().run(ctx);
    }
}

