/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.util.Util;
import org.basex.util.ft.Language;

public final class CreateIndex
extends ACreate {
    public CreateIndex(Object type) {
        super(Perm.WRITE, true, type != null ? type.toString() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean run() {
        IndexType index;
        Data data = this.context.data();
        if (data.inMemory()) {
            return this.error(Text.NO_MAINMEM, new Object[0]);
        }
        Commands.CmdIndex ci = this.getOption(Commands.CmdIndex.class);
        if (ci == null) {
            return this.error(Text.UNKNOWN_CMD_X, this);
        }
        switch (ci) {
            case TEXT: {
                data.meta.createtext = true;
                index = IndexType.TEXT;
                break;
            }
            case ATTRIBUTE: {
                data.meta.createattr = true;
                index = IndexType.ATTRIBUTE;
                break;
            }
            case FULLTEXT: {
                data.meta.createftxt = true;
                data.meta.stemming = this.options.get(MainOptions.STEMMING);
                data.meta.casesens = this.options.get(MainOptions.CASESENS);
                data.meta.diacritics = this.options.get(MainOptions.DIACRITICS);
                data.meta.language = Language.get(this.options);
                data.meta.stopwords = this.options.get(MainOptions.STOPWORDS);
                index = IndexType.FULLTEXT;
                break;
            }
            default: {
                return this.error(Text.UNKNOWN_CMD_X, this);
            }
        }
        if (!data.startUpdate()) {
            return this.error(Text.DB_PINNED_X, data.meta.name);
        }
        try {
            CreateIndex.create(index, data, this);
            boolean bl = this.info(Text.INDEX_CREATED_X_X, new Object[]{index, this.perf});
            return bl;
        }
        catch (IOException ex) {
            boolean bl = this.error(Util.message(ex), new Object[0]);
            return bl;
        }
        finally {
            data.finishUpdate();
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.CREATE) + " " + (Object)((Object)Commands.CmdCreate.INDEX)).args();
    }
}

