/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.HashSet;
import org.basex.core.Command;
import org.basex.core.LockResult;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class Export
extends Command {
    private IO progFile;
    private int progPos;
    private int progSize;

    public Export(String path) {
        super(Perm.CREATE, true, path);
    }

    @Override
    protected boolean run() {
        try {
            Data data = this.context.data();
            Export.export(data, this.args[0], this);
            return this.info(Text.DB_EXPORTED_X, data.meta.name, this.perf);
        }
        catch (IOException ex) {
            return this.error(Util.message(ex), new Object[0]);
        }
    }

    @Override
    public void databases(LockResult lr) {
        lr.read.add("%CTX");
    }

    public static void export(Data data, String path, Export export) throws IOException {
        Export.export(data, path, data.meta.options.get(MainOptions.EXPORTER), export);
    }

    public static void export(Data data, String path, SerializerOptions sopts, Export export) throws IOException {
        IO f;
        StringList desc;
        IOFile bin;
        IOFile root = new IOFile(path);
        root.md();
        HashSet<String> exported = new HashSet<String>();
        IntList il = data.resources.docs();
        if (data.inMemory()) {
            bin = null;
            desc = new StringList();
        } else {
            bin = data.meta.binaries();
            desc = bin.descendants();
        }
        if (export != null) {
            export.progPos = 0;
            export.progSize = il.size() + desc.size();
        }
        int is = il.size();
        for (int i = 0; i < is; ++i) {
            IOFile dir;
            int pre = il.get(i);
            f = root.merge(Token.string(data.text(pre, true)));
            if (export != null) {
                export.checkStop();
                export.progFile = f;
                ++export.progPos;
            }
            if (!(dir = new IOFile(f.dirPath())).exists()) {
                dir.md();
            }
            PrintOutput po = new PrintOutput(Export.unique(exported, f.path()));
            Serializer ser = Serializer.get(po, sopts);
            ser.serialize((Item)new DBNode(data, pre));
            ser.close();
            po.close();
        }
        for (String s : desc) {
            f = new IOFile(root.path(), s);
            if (export != null) {
                export.checkStop();
                export.progFile = f;
                ++export.progPos;
            }
            String u = Export.unique(exported, f.path());
            new IOFile(bin, s).copyTo(new IOFile(u));
        }
    }

    @Override
    public double prog() {
        return this.progSize == 0 ? 0.0 : (double)this.progPos / (double)this.progSize;
    }

    @Override
    public boolean stoppable() {
        return true;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    public String det() {
        return this.progFile == null ? Text.EXPORT : this.progFile.path();
    }

    private static String unique(HashSet<String> exp, String fp) {
        int c = 1;
        String path = fp;
        while (exp.contains(path)) {
            path = fp.indexOf(46) == -1 ? fp + '(' + ++c + ')' : fp.replaceAll("(.*)\\.(.*)", "$1(" + ++c + ").$2");
        }
        exp.add(path);
        return path;
    }
}

