/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.data.NSNode;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class Namespaces {
    private final IntList defaults = new IntList(2);
    private final TokenSet prefs;
    private final TokenSet uris;
    private final NSNode root;
    private boolean newns;
    private int level = 1;
    private NSNode current;

    public Namespaces() {
        this.prefs = new TokenSet();
        this.uris = new TokenSet();
        this.current = this.root = new NSNode(-1);
    }

    Namespaces(DataInput in) throws IOException {
        this.prefs = new TokenSet(in);
        this.uris = new TokenSet(in);
        this.current = this.root = new NSNode(in, null);
    }

    void write(DataOutput out) throws IOException {
        this.prefs.write(out);
        this.uris.write(out);
        this.root.write(out);
    }

    public void prepare() {
        int nu = this.defaults.get(this.level);
        this.defaults.set(++this.level, nu);
        this.newns = false;
    }

    public NSNode add(byte[] pref, byte[] uri, int pre) {
        NSNode node = null;
        if (!this.newns) {
            node = new NSNode(pre);
            this.current.add(node);
            this.current = node;
            this.newns = true;
        }
        int k = this.prefs.put(pref);
        int v = this.uris.put(uri);
        this.current.add(k, v);
        if (pref.length == 0) {
            this.defaults.set(this.level, v);
        }
        return node;
    }

    public void close(int pre) {
        while (this.current.pre >= pre && this.current.parent != null) {
            this.current = this.current.parent;
        }
        --this.level;
    }

    public int size() {
        return this.uris.size();
    }

    public byte[] globalNS() {
        if (this.root.size == 0) {
            return Token.EMPTY;
        }
        if (this.root.size > 1) {
            return null;
        }
        NSNode n = this.root.children[0];
        if (n.size != 0 || n.pre != 1 || n.values.length != 2) {
            return null;
        }
        return this.prefix(n.values[0]).length == 0 ? this.uri(n.values[1]) : null;
    }

    public byte[] uri(int id) {
        return this.uris.key(id);
    }

    public int uri(byte[] name, int pre, Data data) {
        return this.uri(Token.prefix(name), this.current.find(pre, data));
    }

    public int uri(byte[] uri) {
        return uri.length == 0 ? 0 : this.uris.id(uri);
    }

    public int uri(byte[] name, boolean elem) {
        int nu;
        if (this.uris.isEmpty()) {
            return 0;
        }
        byte[] pref = Token.prefix(name);
        int n = nu = elem ? this.defaults.get(this.level) : 0;
        if (pref.length != 0) {
            nu = this.uri(pref, this.current);
        }
        return nu;
    }

    NSNode getCurrent() {
        return this.current;
    }

    byte[] prefix(int id) {
        return this.prefs.key(id);
    }

    int[] get(int pre, Data data) {
        return this.current.find((int)pre, (Data)data).values;
    }

    TokenMap scope(int pre, Data data) {
        TokenMap nsScope = new TokenMap();
        NSNode node = this.current;
        do {
            for (int i = 0; i < node.values.length; i += 2) {
                nsScope.put(this.prefix(node.values[i]), this.uri(node.values[i + 1]));
            }
            int pos = node.find(pre);
            if (pos < 0) break;
            node = node.children[pos];
        } while (node.pre <= pre && pre < node.pre + data.size(node.pre, 1));
        return nsScope;
    }

    void root(int pre, Data data) {
        int p;
        LinkedList<NSNode> cand = new LinkedList<NSNode>();
        NSNode node = this.root;
        cand.add(node);
        while ((p = node.find(pre)) > -1) {
            node = node.children[p];
            cand.add(0, node);
        }
        node = this.root;
        if (cand.size() > 1) {
            int ancPre = pre;
            NSNode curr = (NSNode)cand.remove(0);
            while (ancPre > -1 && node == this.root) {
                if (curr.pre == ancPre) {
                    node = curr;
                } else if (curr.pre < ancPre) {
                    while ((ancPre = data.parent(ancPre, data.kind(ancPre))) > curr.pre) {
                    }
                    if (curr.pre == ancPre) {
                        node = curr;
                    }
                }
                if (cand.isEmpty()) continue;
                curr = (NSNode)cand.remove(0);
            }
        }
        int uri = this.uri(Token.EMPTY, pre, data);
        this.defaults.set(this.level, uri);
        this.defaults.set(this.level - 1, uri);
        this.current = node;
    }

    private int uri(byte[] pref, NSNode node) {
        int id = this.prefs.id(pref);
        if (id == 0) {
            return 0;
        }
        NSNode n = node;
        while (n != null) {
            int u = n.uri(id);
            if (u != 0) {
                return u;
            }
            n = n.parent;
        }
        return 0;
    }

    List<NSNode> getNSNodes(int pre) {
        ArrayList<NSNode> l = new ArrayList<NSNode>();
        Namespaces.addNSNodes(this.root, l, pre);
        return l;
    }

    private static List<NSNode> addNSNodes(NSNode curr, List<NSNode> l, int pre) {
        for (int i = 0; i < curr.size; ++i) {
            NSNode ch = curr.children[i];
            if (ch.pre >= pre) {
                l.add(ch);
            }
            Namespaces.addNSNodes(ch, l, pre);
        }
        return l;
    }

    public void delete(byte[] uri) {
        int id = this.uris.id(uri);
        if (id != 0) {
            this.current.delete(id);
        }
    }

    void delete(int pre, int size, Data data) {
        NSNode nd = this.current.find(pre, data);
        if (nd.pre == pre) {
            nd = nd.parent;
        }
        while (nd != null) {
            nd.delete(pre, size);
            nd = nd.parent;
        }
        Namespaces.decrementPre(this.root, pre, size);
    }

    private static void decrementPre(NSNode node, int pre, int size) {
        if (node.pre >= pre + size) {
            node.pre -= size;
        }
        for (int c = 0; c < node.size; ++c) {
            Namespaces.decrementPre(node.children[c], pre, size);
        }
    }

    static void incrementPre(List<NSNode> l, int s) {
        for (NSNode n : l) {
            n.pre += s;
        }
    }

    public int add(int pre, int par, byte[] pref, byte[] uri, Data data) {
        if (Token.eq(pref, Token.XML)) {
            return 0;
        }
        NSNode nd = this.current.find(par, data);
        NSNode t = new NSNode(pre);
        int k = this.prefs.put(pref);
        int v = this.uris.put(uri);
        if (nd.pre == pre) {
            nd.add(k, v);
        } else {
            t.add(k, v);
            nd.add(t);
        }
        return v;
    }

    void setCurrent(NSNode node) {
        this.current = node;
    }

    public byte[] table(int s, int e) {
        if (this.root.size == 0) {
            return Token.EMPTY;
        }
        Table t = new Table();
        t.header.add(DataText.TABLEID);
        t.header.add(DataText.TABLEPRE);
        t.header.add(DataText.TABLEDIST);
        t.header.add(DataText.TABLEPREF);
        t.header.add(DataText.TABLEURI);
        for (int i = 0; i < 3; ++i) {
            t.align.add(true);
        }
        this.table(t, this.root, s, e);
        return t.contents.isEmpty() ? Token.EMPTY : t.finish();
    }

    private void table(Table t, NSNode n, int s, int e) {
        int i;
        for (i = 0; i < n.values.length; i += 2) {
            if (n.pre < s || n.pre > e) continue;
            TokenList tl = new TokenList();
            tl.add(n.values[i + 1]);
            tl.add(n.pre);
            tl.add(n.pre - n.parent.pre);
            tl.add(this.prefs.key(n.values[i]));
            tl.add(this.uris.key(n.values[i + 1]));
            t.contents.add(tl);
        }
        for (i = 0; i < n.size; ++i) {
            this.table(t, n.children[i], s, e);
        }
    }

    public byte[] info() {
        TokenObjMap<TokenList> map = new TokenObjMap<TokenList>();
        this.info(map, this.root);
        TokenBuilder tb = new TokenBuilder();
        for (byte[] key : map) {
            tb.add("  ");
            TokenList values = map.get(key);
            values.sort(false);
            int ks = values.size();
            if (ks > 1 || values.get(0).length != 0) {
                if (values.size() != 1) {
                    tb.add("(");
                }
                for (int k = 0; k < ks; ++k) {
                    if (k != 0) {
                        tb.add(", ");
                    }
                    tb.add(values.get(k));
                }
                if (ks != 1) {
                    tb.add(")");
                }
                tb.add(" = ");
            }
            tb.addExt("\"%\"" + Text.NL, new Object[]{key});
        }
        return tb.finish();
    }

    private void info(TokenObjMap<TokenList> map, NSNode n) {
        for (int i = 0; i < n.values.length; i += 2) {
            byte[] key = this.uris.key(n.values[i + 1]);
            byte[] val = this.prefs.key(n.values[i]);
            TokenList old = map.get(key);
            if (old == null) {
                old = new TokenList();
                map.put(key, old);
            }
            if (old.contains(val)) continue;
            old.add(val);
        }
        for (NSNode c : n.children) {
            this.info(map, c);
        }
    }

    public String toString(int s, int e) {
        return this.root.print(this, s, e);
    }

    public String toString() {
        return this.toString(0, Integer.MAX_VALUE);
    }
}

