/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import java.util.Arrays;
import org.basex.data.Data;
import org.basex.data.FTPosData;
import org.basex.data.Result;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FTPosNode;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class Nodes
implements Result {
    public final FTPosData ftpos;
    public boolean root;
    public Data data;
    public int[] pres;
    public int[] sorted;

    public Nodes(Data d) {
        this(new int[0], d);
    }

    public Nodes(int n, Data d) {
        this(new int[]{n}, d);
    }

    public Nodes(int[] n, Data d) {
        this(n, d, Prop.gui ? new FTPosData() : null);
    }

    public Nodes(int[] n, Data d, FTPosData ft) {
        this.data = d;
        this.ftpos = ft;
        this.set(n);
        if (d == null) {
            throw Util.notExpected("No data available");
        }
    }

    public Nodes(int[] n) {
        this.pres = n;
        this.ftpos = null;
    }

    public Nodes(Nodes nds) {
        this((int[])nds.pres.clone(), nds.data, nds.ftpos == null ? null : nds.ftpos.copy());
        this.root = nds.root;
        if (nds.sorted != null) {
            this.sorted = (int[])nds.sorted.clone();
        }
    }

    @Override
    public long size() {
        return this.pres.length;
    }

    @Override
    public boolean sameAs(Result r) {
        int s = this.pres.length;
        if (!(r instanceof Nodes) || r.size() != (long)s) {
            return false;
        }
        Nodes n = (Nodes)r;
        if (this.data != n.data) {
            return false;
        }
        for (int c = 0; c < s; ++c) {
            if (n.pres[c] == this.pres[c]) continue;
            return false;
        }
        return this.ftpos == null || this.ftpos.sameAs(n.ftpos);
    }

    public Nodes checkRoot() {
        int[] ps = this.pres;
        int pl = ps.length;
        IntList docs = this.data.resources.docs();
        if (pl != docs.size()) {
            return this;
        }
        int c = -1;
        while (++c < pl && ps[c] == docs.get(c)) {
        }
        return c < pl ? this : null;
    }

    public boolean contains(int p) {
        return this.find(p) >= 0;
    }

    public int find(int p) {
        this.sort();
        return Arrays.binarySearch(this.sorted, p);
    }

    public void toggle(int p) {
        int[] n = new int[]{p};
        this.set(this.contains(p) ? Nodes.except(this.pres, n) : Nodes.union(this.pres, n));
    }

    public void union(int[] p) {
        this.set(Nodes.union(this.pres, p));
    }

    private static int[] union(int[] ai, int[] bi) {
        int al = ai.length;
        int bl = bi.length;
        IntList c = new IntList();
        int a = 0;
        int b = 0;
        while (a != al && b != bl) {
            int d = ai[a] - bi[b];
            c.add(d <= 0 ? ai[a++] : bi[b++]);
            if (d != 0) continue;
            ++b;
        }
        while (a != al) {
            c.add(ai[a++]);
        }
        while (b != bl) {
            c.add(bi[b++]);
        }
        return c.toArray();
    }

    private static int[] except(int[] ai, int[] bi) {
        int al = ai.length;
        int bl = bi.length;
        IntList c = new IntList();
        int a = 0;
        int b = 0;
        while (a != al && b != bl) {
            int d = ai[a] - bi[b];
            if (d < 0) {
                c.add(ai[a]);
            } else {
                ++b;
            }
            if (d > 0) continue;
            ++a;
        }
        while (a != al) {
            c.add(ai[a++]);
        }
        return c.toArray();
    }

    private void set(int[] n) {
        this.pres = n;
        this.sorted = null;
    }

    private void sort() {
        if (this.sorted != null) {
            return;
        }
        int i = Integer.MIN_VALUE;
        for (int n : this.pres) {
            if (i > n) {
                this.sorted = Arrays.copyOf(this.pres, this.pres.length);
                Arrays.sort(this.sorted);
                return;
            }
            i = n;
        }
        this.sorted = this.pres;
    }

    @Override
    public void serialize(Serializer ser) throws IOException {
        for (int c = 0; c < this.pres.length && !ser.finished(); ++c) {
            this.serialize(ser, c);
        }
    }

    @Override
    public void serialize(Serializer ser, int n) throws IOException {
        ser.serialize((Item)new FTPosNode(this.data, this.pres[n], this.ftpos));
    }

    @Override
    public ArrayOutput serialize() throws IOException {
        ArrayOutput ao = new ArrayOutput();
        this.serialize(Serializer.get(ao));
        return ao;
    }

    public String toString() {
        try {
            return this.serialize().toString();
        }
        catch (IOException ex) {
            throw Util.notExpected(ex);
        }
    }
}

