/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import org.basex.core.parse.CommandParser;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXHistory;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXTextField;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QuerySuggest;
import org.basex.util.list.StringList;
import org.basex.util.options.StringsOption;

public final class GUIInput
extends BaseXTextField {
    private final GUI gui;
    private final BaseXCombo box;
    private ComboPopup pop;
    private String pre = "";

    GUIInput(final GUI main) {
        super(main);
        this.gui = main;
        Font f = this.getFont();
        this.setFont(f.deriveFont((float)f.getSize() + 2.0f));
        this.box = new BaseXCombo((Window)main, new String[0]);
        this.box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getModifiers() == 16) {
                    GUIInput.this.completeInput();
                }
            }
        });
        this.pop = new ComboPopup((JComboBox)this.box);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int count = GUIInput.this.box.getItemCount();
                if (BaseXKeys.ENTER.is(e)) {
                    if (GUIInput.this.pop.isVisible()) {
                        GUIInput.this.completeInput();
                    } else {
                        int i;
                        Data data = main.context.data();
                        int n = i = data == null ? 2 : ((GUIInput)GUIInput.this).gui.gopts.get(GUIOptions.SEARCHMODE);
                        StringsOption options = i == 0 ? GUIOptions.SEARCH : (i == 1 ? GUIOptions.XQUERY : GUIOptions.COMMANDS);
                        new BaseXHistory(main, options).store(GUIInput.this.getText());
                        if (e.getModifiers() == 0) {
                            main.execute();
                        }
                    }
                    return;
                }
                if (count == 0) {
                    return;
                }
                int bi = GUIInput.this.box.getSelectedIndex();
                if (BaseXKeys.NEXTLINE.is(e)) {
                    if (GUIInput.this.pop.isVisible()) {
                        if (++bi == count) {
                            bi = 0;
                        }
                    } else {
                        GUIInput.this.showPopup();
                    }
                } else if (BaseXKeys.PREVLINE.is(e)) {
                    if (GUIInput.this.pop.isVisible()) {
                        if (--bi < 0) {
                            bi = count - 1;
                        }
                    } else {
                        GUIInput.this.showPopup();
                    }
                }
                if (bi != GUIInput.this.box.getSelectedIndex()) {
                    GUIInput.this.box.setSelectedIndex(bi);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (BaseXKeys.ESCAPE.is(e)) {
                    GUIInput.this.pop.setVisible(false);
                } else if (BaseXKeys.ENTER.is(e)) {
                    GUIInput.this.pop.hide();
                } else if (!BaseXKeys.NEXTLINE.is(e) && !BaseXKeys.PREVLINE.is(e)) {
                    if (BaseXKeys.modifier(e) || BaseXKeys.control(e)) {
                        return;
                    }
                    GUIInput.this.showPopup();
                    if (((GUIInput)GUIInput.this).gui.gopts.get(GUIOptions.EXECRT).booleanValue() && !GUIInput.this.cmdMode()) {
                        main.execute();
                    }
                }
            }
        });
    }

    @Override
    public void setText(String txt) {
        super.setText(txt);
        this.box.removeAllItems();
        this.pop.setVisible(false);
    }

    void mode(String mode) {
        this.setText("");
        this.hint(mode + "...");
    }

    private boolean cmdMode() {
        return this.gui.gopts.get(GUIOptions.SEARCHMODE) == 2 || this.gui.context.data() == null || this.getText().startsWith("!");
    }

    private void completeInput() {
        int ll;
        String suf = this.box.getSelectedItem();
        if (suf == null) {
            return;
        }
        int pl = this.pre.length();
        int n = ll = pl > 0 ? (int)this.pre.charAt(pl - 1) : 32;
        if (Character.isLetter(ll) && Character.isLetter(suf.charAt(0))) {
            this.pre = this.pre + " ";
        }
        this.setText(this.pre + suf);
        this.showPopup();
        if (this.gui.gopts.get(GUIOptions.EXECRT).booleanValue() && !this.cmdMode()) {
            this.gui.execute();
        }
    }

    private void showPopup() {
        String query = this.getText();
        int mode = this.gui.gopts.get(GUIOptions.SEARCHMODE);
        if (this.cmdMode()) {
            this.cmdPopup(query);
        } else if (mode == 1 || mode == 0 && query.startsWith("/")) {
            this.queryPopup(query);
        } else {
            this.pop.setVisible(false);
        }
    }

    private void cmdPopup(String query) {
        StringList sl;
        block2: {
            sl = null;
            boolean excl = query.startsWith("!");
            try {
                this.pre = excl ? "!" : "";
                String suf = this.getText().substring(this.pre.length());
                new CommandParser(suf, this.gui.context).suggest();
            }
            catch (QueryException ex) {
                sl = ex.suggest();
                int marked = ex.markedColumn() + (excl ? 2 : 1);
                if (ex.markedColumn() <= -1 || marked > query.length()) break block2;
                this.pre = query.substring(0, marked);
            }
        }
        this.createCombo(sl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryPopup(String query) {
        StringList sl;
        Data data = this.gui.context.data();
        if (data == null) {
            return;
        }
        QueryContext qc = new QueryContext(this.gui.context);
        try {
            QuerySuggest qs = new QuerySuggest(query, qc, data);
            qs.parseMain();
            sl = qs.complete();
            this.pre = query.substring(0, qs.mark);
        }
        catch (QueryException ex) {
            sl = ex.suggest();
            this.pre = query.substring(0, ex.column() - 1);
        }
        finally {
            qc.close();
        }
        if (this.getCaretPosition() < this.pre.length()) {
            sl = null;
        }
        this.createCombo(sl);
    }

    private void createCombo(StringList sl) {
        if (sl == null || sl.isEmpty()) {
            this.pop.setVisible(false);
            return;
        }
        if (this.comboChanged(sl)) {
            this.box.setModel(new DefaultComboBoxModel<String>(sl.toArray()));
            this.box.setSelectedIndex(-1);
            this.pop = new ComboPopup((JComboBox)this.box);
        }
        int w = this.getFontMetrics(this.getFont()).stringWidth(this.pre);
        this.pop.show(this, Math.min(this.getWidth(), w), this.getHeight());
    }

    private boolean comboChanged(StringList sl) {
        if (sl.size() != this.box.getItemCount()) {
            return true;
        }
        int is = sl.size();
        for (int i = 0; i < is; ++i) {
            if (sl.get(i).equals(this.box.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    private static final class ComboPopup
    extends BasicComboPopup {
        ComboPopup(JComboBox combo) {
            super(combo);
            int h = combo.getMaximumRowCount();
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPopupHeightForRowCount(h) + 2));
        }
    }
}

