/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import org.basex.build.CsvOptions;
import org.basex.build.CsvParser;
import org.basex.build.CsvParserOptions;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.dialog.DialogExport;
import org.basex.gui.dialog.DialogParser;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.TextPanel;
import org.basex.io.IOContent;
import org.basex.query.value.node.DBNode;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

final class DialogCsvParser
extends DialogParser {
    private static final String EXAMPLE = "Name,Born?_\n\"John, Adam\",1984";
    private final CsvParserOptions copts;
    private final TextPanel example;
    private final BaseXCombo encoding;
    private final BaseXCheckBox header;
    private final BaseXCombo format;
    private final BaseXCombo seps;
    private final BaseXTextField sepchar;
    private final BaseXCheckBox lax;
    private final BaseXCheckBox quotes;

    DialogCsvParser(BaseXDialog d, MainOptions opts) {
        super(d);
        this.copts = opts.get(MainOptions.CSVPARSER);
        BaseXBack pp = new BaseXBack(new TableLayout(2, 1, 0, 8));
        BaseXBack p = new BaseXBack(new TableLayout(4, 2, 8, 4));
        p.add(new BaseXLabel(Text.ENCODING + ":", true, true));
        this.encoding = DialogExport.encoding(d, this.copts.get(CsvParserOptions.ENCODING));
        p.add(this.encoding);
        BaseXBack sep = new BaseXBack().layout(new TableLayout(1, 2, 6, 0));
        StringList sl = new StringList();
        for (CsvOptions.CsvSep cs : CsvOptions.CsvSep.values()) {
            sl.add(cs.toString());
        }
        String[] sa = sl.toArray();
        this.seps = new BaseXCombo((Window)d, sl.add("").toArray());
        sep.add(this.seps);
        String s = this.copts.get(CsvOptions.SEPARATOR);
        if (Token.eq(s, sa)) {
            this.seps.setSelectedItem(s);
        } else {
            this.seps.setSelectedIndex(sa.length);
        }
        this.sepchar = new BaseXTextField(s, d);
        sep.add(this.sepchar);
        BaseXLayout.setWidth(this.sepchar, 35);
        p.add(new BaseXLabel(Text.SEPARATOR, true, true));
        p.add(sep);
        p.add(new BaseXLabel(Text.FORMAT + ":", true, true));
        sl.reset();
        CsvOptions.CsvFormat[] formats = CsvOptions.CsvFormat.values();
        int fl = formats.length - 1;
        for (int f = 0; f < fl; ++f) {
            sl.add(formats[f].toString());
        }
        this.format = new BaseXCombo((Window)d, sl.toArray());
        this.format.setSelectedItem((Object)this.copts.get(CsvOptions.FORMAT));
        p.add(this.format);
        pp.add(p);
        p = new BaseXBack(new TableLayout(3, 1));
        this.header = new BaseXCheckBox(Text.FIRST_LINE_HEADER, CsvOptions.HEADER, this.copts, d);
        p.add(this.header);
        this.quotes = new BaseXCheckBox(Text.PARSE_QUOTES, CsvOptions.QUOTES, this.copts, d);
        p.add(this.quotes);
        this.lax = new BaseXCheckBox(Text.LAX_NAME_CONVERSION, CsvOptions.LAX, this.copts, d);
        p.add(this.lax);
        pp.add(p);
        this.add((Component)pp, "West");
        this.example = new TextPanel(false, d);
        this.add((Component)this.example, "Center");
        this.action(true);
    }

    @Override
    boolean action(boolean active) {
        try {
            boolean head = this.header.isSelected();
            this.format.setEnabled(head);
            this.lax.setEnabled(head && this.copts.get(CsvOptions.FORMAT) == CsvOptions.CsvFormat.DIRECT);
            IOContent io = CsvParser.toXML(new IOContent(EXAMPLE), this.copts);
            DBNode node = new DBNode(io, this.dialog.gui.context.options);
            this.example.setText(DialogCsvParser.example(MainOptions.MainParser.CSV.name(), EXAMPLE, node.serialize().toString()));
        }
        catch (IOException ex) {
            this.example.setText(DialogCsvParser.error(ex));
        }
        boolean fixedsep = this.seps.getSelectedIndex() < CsvOptions.CsvSep.values().length;
        this.sepchar.setEnabled(!fixedsep);
        if (fixedsep) {
            this.sepchar.setText(new TokenBuilder().add(this.copts.separator()).toString());
        }
        return fixedsep || this.sepchar.getText().length() == 1;
    }

    @Override
    void update() {
        String sep;
        String enc = this.encoding.getSelectedItem();
        this.copts.set(CsvParserOptions.ENCODING, enc.equals("UTF-8") ? null : enc);
        this.copts.set(CsvOptions.HEADER, this.header.isSelected());
        this.copts.set(CsvOptions.FORMAT, this.format.getSelectedItem());
        this.copts.set(CsvOptions.LAX, this.lax.isSelected());
        this.copts.set(CsvOptions.QUOTES, this.quotes.isSelected());
        if (this.seps.getSelectedIndex() < CsvOptions.CsvSep.values().length) {
            sep = this.seps.getSelectedItem();
        } else {
            sep = this.sepchar.getText();
            for (CsvOptions.CsvSep cs : CsvOptions.CsvSep.values()) {
                if (!String.valueOf(cs.sep).equals(sep)) continue;
                sep = cs.toString();
            }
        }
        this.copts.set(CsvOptions.SEPARATOR, sep);
    }

    @Override
    void setOptions(GUI gui) {
        gui.set(MainOptions.CSVPARSER, this.copts);
    }
}

