/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import org.basex.core.Text;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.util.options.Options;

final class DialogEditorPrefs
extends BaseXBack {
    private final BaseXCheckBox showmargin;
    private final BaseXTextField margin;
    private final BaseXCheckBox spaces;
    private final BaseXTextField indent;
    private final BaseXCheckBox invisible;
    private final BaseXCheckBox shownl;
    private final BaseXCheckBox numbers;
    private final BaseXCheckBox markline;
    private final BaseXCheckBox saverun;
    private final BaseXCheckBox auto;
    private final BaseXTextField files;

    DialogEditorPrefs(BaseXDialog d) {
        this.border(8).setLayout(new TableLayout(1, 2, 40, 0));
        GUIOptions gopts = d.gui.gopts;
        this.showmargin = new BaseXCheckBox(Text.SHOW_LINE_MARGIN + ":", GUIOptions.SHOWMARGIN, gopts, d);
        this.margin = new BaseXTextField(GUIOptions.MARGIN, (Options)gopts, d);
        this.invisible = new BaseXCheckBox(Text.SHOW_INVISIBLE, GUIOptions.SHOWINVISIBLE, gopts, d);
        this.shownl = new BaseXCheckBox(Text.SHOW_NEWLINES, GUIOptions.SHOWNL, gopts, d);
        this.numbers = new BaseXCheckBox(Text.SHOW_LINE_NUMBERS, GUIOptions.SHOWLINES, gopts, d);
        this.markline = new BaseXCheckBox(Text.MARK_EDITED_LINE, GUIOptions.MARKLINE, gopts, d);
        this.spaces = new BaseXCheckBox(Text.TABS_AS_SPACES, GUIOptions.TABSPACES, gopts, d);
        this.indent = new BaseXTextField(GUIOptions.INDENT, (Options)gopts, d);
        this.auto = new BaseXCheckBox(Text.AUTO_ADD_CHARS, GUIOptions.AUTO, gopts, d);
        this.saverun = new BaseXCheckBox(Text.SAVE_BEFORE_EXECUTE, GUIOptions.SAVERUN, gopts, d);
        this.files = new BaseXTextField(GUIOptions.FILES, (Options)gopts, d);
        BaseXLayout.setWidth(this.margin, 30);
        BaseXLayout.setWidth(this.indent, 30);
        BaseXLayout.setWidth(this.files, 150);
        BaseXBack p = new BaseXBack().layout(new TableLayout(8, 1));
        p.add(new BaseXLabel(Text.VIEW + ":", true, true));
        BaseXBack pp = new BaseXBack().layout(new TableLayout(1, 2, 8, 0));
        pp.add(this.showmargin);
        pp.add(this.margin);
        p.add(pp);
        p.add(this.invisible);
        p.add(this.shownl);
        p.add(this.numbers);
        p.add(this.markline);
        p.add(new BaseXLabel(Text.FILE_FILTER + ":", true, true).border(6, 0, 6, 0));
        p.add(this.files);
        this.add(p);
        BaseXBack pv = new BaseXBack().layout(new TableLayout(2, 1, 0, 8));
        p = new BaseXBack().layout(new TableLayout(4, 1));
        p.add(new BaseXLabel(Text.EDIT + ":", true, true));
        pp = new BaseXBack().layout(new TableLayout(1, 2, 8, 0));
        pp.add(new BaseXLabel(Text.INDENTATION_SIZE + ":"));
        pp.add(this.indent);
        p.add(pp);
        p.add(this.spaces);
        p.add(this.auto);
        pv.add(p);
        p = new BaseXBack().layout(new TableLayout(2, 1));
        p.add(new BaseXLabel(Text.EVALUATING + ":", true, true));
        p.add(this.saverun);
        pv.add(p);
        this.add(pv);
    }

    void action() {
        this.margin.setEnabled(this.showmargin.isSelected());
        this.indent.setEnabled(this.spaces.isSelected());
        this.showmargin.assign();
        this.invisible.assign();
        this.shownl.assign();
        this.numbers.assign();
        this.markline.assign();
        this.files.assign();
        this.margin.assign();
        this.spaces.assign();
        this.indent.assign();
        this.auto.assign();
        this.saverun.assign();
    }
}

