/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Component;
import java.io.IOException;
import org.basex.build.HtmlOptions;
import org.basex.build.HtmlParser;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogParser;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.util.options.Option;

final class DialogHtmlParser
extends DialogParser {
    private final HtmlOptions hopts;
    private final BaseXTextField options;
    private final BaseXLabel info;

    DialogHtmlParser(BaseXDialog d, MainOptions opts) {
        super(d);
        this.hopts = opts.get(MainOptions.HTMLPARSER);
        boolean avl = HtmlParser.available();
        BaseXBack pp = new BaseXBack(new TableLayout(3, 1, 0, 8));
        pp.add(new BaseXLabel(avl ? Text.H_HTML_PARSER : Text.H_NO_HTML_PARSER));
        this.options = new BaseXTextField(opts.get(MainOptions.HTMLPARSER).toString(), d);
        this.options.setToolTipText(DialogHtmlParser.tooltip(this.hopts));
        if (avl) {
            BaseXBack p = new BaseXBack(new TableLayout(1, 2, 8, 0));
            p.add(new BaseXLabel(Text.PARAMETERS + ":", true, true));
            p.add(this.options);
            pp.add(p);
        }
        this.info = new BaseXLabel(" ").border(12, 0, 6, 0);
        pp.add(this.info);
        this.add((Component)pp, "West");
    }

    @Override
    boolean action(boolean active) {
        try {
            this.hopts.parse(this.options.getText());
            this.info.setText(null, null);
            return true;
        }
        catch (IOException ex) {
            this.info.setText(ex.getMessage(), GUIConstants.Msg.ERROR);
            return false;
        }
    }

    @Override
    void update() {
    }

    @Override
    void setOptions(GUI gui) {
        gui.set(MainOptions.HTMLPARSER, this.hopts);
    }

    private static String tooltip(HtmlOptions opts) {
        StringBuilder sb = new StringBuilder("<html><b>").append(Text.PARAMETERS).append(":</b><br>");
        for (Option<?> so : opts) {
            sb.append("\u2022 ").append(so).append("<br/>");
        }
        return sb.append("</html>").toString();
    }
}

