/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.dialog.DialogCsvParser;
import org.basex.gui.dialog.DialogHtmlParser;
import org.basex.gui.dialog.DialogJsonParser;
import org.basex.gui.dialog.DialogParser;
import org.basex.gui.dialog.DialogTextParser;
import org.basex.gui.dialog.DialogXmlParser;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTabs;
import org.basex.util.Util;

final class DialogParsing
extends BaseXBack {
    private final DialogParser[] parsers;
    private final BaseXLabel label;
    private final BaseXTabs tabs;
    private final GUI gui;
    private MainOptions.MainParser parser;
    private BaseXBack panel;

    DialogParsing(BaseXDialog d, BaseXTabs t) {
        this.border(8);
        this.gui = d.gui;
        this.tabs = t;
        this.label = new BaseXLabel().border(0, 0, 12, 0).large();
        MainOptions opts = this.gui.context.options;
        this.parsers = new DialogParser[]{new DialogXmlParser(d, opts), new DialogHtmlParser(d, opts), new DialogJsonParser(d, opts), new DialogCsvParser(d, opts), new DialogTextParser(d, opts)};
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                DialogParsing.this.removeAll();
                DialogParsing.this.label.setText(Util.info(Text.PARSER_X, DialogParsing.this.parser.name()));
                DialogParsing.this.add((Component)DialogParsing.this.label, "North");
                DialogParsing.this.add((Component)DialogParsing.this.panel, "Center");
                DialogParsing.this.revalidate();
                DialogParsing.this.repaint();
            }
        });
    }

    void setType(MainOptions.MainParser mp) {
        this.parser = mp;
        if (mp == MainOptions.MainParser.RAW) {
            this.tabs.setEnabledAt(1, false);
        } else {
            this.tabs.setEnabledAt(1, true);
            MainOptions.MainParser[] mps = MainOptions.MainParser.values();
            for (int t = 0; t < mps.length; ++t) {
                if (mps[t] != mp) continue;
                this.panel = this.parsers[t];
            }
        }
    }

    boolean action() {
        this.update();
        boolean ok = true;
        for (DialogParser dp : this.parsers) {
            ok &= dp.action(this.panel == dp);
        }
        return ok;
    }

    private void update() {
        for (DialogParser dp : this.parsers) {
            dp.update();
        }
    }

    public void setOptions() {
        this.update();
        for (DialogParser dp : this.parsers) {
            dp.setOptions(this.gui);
        }
    }
}

