/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import org.basex.gui.GUIConstants;
import org.basex.util.Prop;

public enum BaseXKeys {
    PREVCHAR(37),
    NEXTCHAR(39),
    PREVWORD(Prop.MAC ? 8 : GUIConstants.META, 37),
    NEXTWORD(Prop.MAC ? 8 : GUIConstants.META, 39),
    LINESTART(Prop.MAC ? GUIConstants.META : 0, Prop.MAC ? 37 : 36),
    LINEEND(Prop.MAC ? GUIConstants.META : 0, Prop.MAC ? 39 : 35),
    PREVLINE(38),
    NEXTLINE(40),
    PREVPAGE(33),
    NEXTPAGE(34),
    TEXTSTART(GUIConstants.META, Prop.MAC ? 38 : 36),
    TEXTEND(GUIConstants.META, Prop.MAC ? 40 : 35),
    SCROLLUP(Prop.MAC ? 8 : GUIConstants.META, 38, true),
    SCROLLDOWN(Prop.MAC ? 8 : GUIConstants.META, 40, true),
    TAB(9),
    PREVPAGE_RO(1, 32, true),
    NEXTPAGE_RO(32, true),
    DELPREV(8),
    DELNEXT(127),
    UNDOSTEP(GUIConstants.META, 90, true),
    REDOSTEP(Prop.MAC ? GUIConstants.META | 1 : GUIConstants.META, Prop.MAC ? 90 : 89, true),
    CUT1(GUIConstants.META, 88, true),
    CUT2(1, 127, true),
    COPY1(GUIConstants.META, 67, true),
    COPY2(GUIConstants.META, 155, true),
    PASTE1(GUIConstants.META, 86, true),
    PASTE2(1, 155, true),
    SELECTALL(GUIConstants.META, 65, true),
    MOVEDOWN(Prop.MAC ? 9 : 8, 40, true),
    MOVEUP(Prop.MAC ? 9 : 8, 38, true),
    COMPLETE(2, 32, true),
    DELPREVWORD(Prop.MAC ? 8 : GUIConstants.META, 8, true),
    DELNEXTWORD(Prop.MAC ? 8 : GUIConstants.META, 127, true),
    DELLINESTART(GUIConstants.META | (Prop.MAC ? 0 : 1), 8, true),
    DELLINEEND(GUIConstants.META | (Prop.MAC ? 0 : 1), 127, true),
    DELLINE(GUIConstants.META | 1, 68, true),
    INPUTBAR(Prop.MAC ? GUIConstants.META : 0, 117, true),
    NEXTTAB(2, 9, true),
    PREVTAB(3, 9, true),
    CLOSETAB(GUIConstants.META, 115, true),
    GOBACK(Prop.MAC ? GUIConstants.META : 8, 37, true),
    GOBACK2(8, true),
    GOFORWARD(Prop.MAC ? GUIConstants.META : 8, 39, true),
    GOUP(Prop.MAC ? GUIConstants.META : 8, 38, true),
    GOHOME(Prop.MAC ? GUIConstants.META : 8, 36, true),
    GOTOLINE(GUIConstants.META, 76, true),
    FIND(GUIConstants.META, 70, true),
    FINDNEXT1(Prop.MAC ? GUIConstants.META : 0, 114, true),
    FINDNEXT2(GUIConstants.META, 71, true),
    FINDPREV1(Prop.MAC ? GUIConstants.META | 1 : 1, 114, true),
    FINDPREV2(GUIConstants.META | 1, 71, true),
    INCFONT1(GUIConstants.META, 521, true),
    INCFONT2(GUIConstants.META, 61, true),
    DECFONT(GUIConstants.META, 45, true),
    NORMFONT(GUIConstants.META, 48, true),
    EXEC1(GUIConstants.META, 10, true),
    EXEC2(GUIConstants.META, 122, true),
    UNIT(GUIConstants.META | 1, 10, true),
    ESCAPE(27, true),
    CONTEXT(525, true),
    COPYPATH(GUIConstants.META | 1, 67, true),
    REFRESH(116, true),
    RENAME(113, true),
    NEWDIR(GUIConstants.META | 1, 78, true),
    SPACE(32, true),
    ENTER(10, true),
    OPEN(1, 10, true);

    private final int mod;
    private final int key;
    private final boolean excl;

    private BaseXKeys(int m, int k, boolean ex) {
        this.mod = m;
        this.key = k;
        this.excl = ex;
    }

    private BaseXKeys(int m, int k) {
        this(m, k, false);
    }

    private BaseXKeys(int k, boolean ig) {
        this(0, k, ig);
    }

    private BaseXKeys(int k) {
        this(0, k);
    }

    public boolean is(KeyEvent e) {
        int c = e.getKeyCode();
        int m = e.getModifiers();
        if (!this.excl) {
            m &= this.mod;
        }
        return m == this.mod && (c == 0 ? (int)e.getKeyChar() : c) == this.key;
    }

    public static boolean sc(InputEvent e) {
        return (GUIConstants.META & e.getModifiers()) == GUIConstants.META;
    }

    public static boolean control(KeyEvent e) {
        return e.isControlDown() || e.isMetaDown() || !Prop.MAC && e.isAltDown();
    }

    public static boolean modifier(KeyEvent e) {
        int c = e.getKeyCode();
        return c == 18 || c == 16 || c == 157 || c == 17 || c == 19 || c == 20 || c == 27 || c == 9 && e.isAltDown();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(KeyEvent.getKeyModifiersText(this.mod));
        if (sb.length() != 0) {
            sb.append('+');
        }
        return sb.append(KeyEvent.getKeyText(this.key)).toString();
    }

    public String shortCut() {
        StringBuilder sb = new StringBuilder();
        if ((this.mod & 4) != 0) {
            sb.append("meta").append(' ');
        }
        if ((this.mod & 2) != 0) {
            sb.append("ctrl").append(' ');
        }
        if ((this.mod & 8) != 0) {
            sb.append("alt").append(' ');
        }
        if ((this.mod & 1) != 0) {
            sb.append("shift").append(' ');
        }
        if (this.key == 10) {
            sb.append("ENTER");
        } else if (this.key == 127) {
            sb.append("DELETE");
        } else if (this.key == 46) {
            sb.append("PERIOD");
        } else {
            sb.append(KeyEvent.getKeyText(this.key));
        }
        return sb.toString();
    }
}

