/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogMem;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;
import org.basex.util.Performance;

public final class BaseXMem
extends BaseXPanel {
    private static final int DWIDTH = 70;
    private static DialogMem mem;

    public BaseXMem(Window win, boolean mouse) {
        super(win);
        BaseXLayout.setWidth(this, 70);
        BaseXLayout.setHeight(this, this.getFont().getSize() + 6);
        if (mouse) {
            this.setCursor(GUIConstants.CURSORHAND);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    BaseXMem.this.repaint();
                    Performance.sleep(5000L);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Runtime rt = Runtime.getRuntime();
        long max = rt.maxMemory();
        long total = rt.totalMemory();
        long used = total - rt.freeMemory();
        int ww = this.getWidth();
        int hh = this.getHeight();
        g.setColor(Color.white);
        g.fillRect(0, 0, ww - 3, hh - 3);
        g.setColor(GUIConstants.GRAY);
        g.drawLine(0, 0, ww - 4, 0);
        g.drawLine(0, 0, 0, hh - 4);
        g.drawLine(ww - 3, 0, ww - 3, hh - 3);
        g.drawLine(0, hh - 3, ww - 3, hh - 3);
        g.setColor(GUIConstants.color1);
        g.fillRect(2, 2, Math.max(1, (int)(total * (long)(ww - 6) / max)), hh - 6);
        boolean full = used * 6L / 5L > max;
        g.setColor(full ? GUIConstants.colormark4 : GUIConstants.color3);
        g.fillRect(2, 2, Math.max(1, (int)(used * (long)(ww - 6) / max)), hh - 6);
        FontMetrics fm = g.getFontMetrics();
        String sz = Performance.format(used, true);
        int fw = (ww - fm.stringWidth(sz)) / 2;
        int h = fm.getHeight() - 3;
        g.setColor(full ? GUIConstants.colormark3 : GUIConstants.DGRAY);
        g.drawString(sz, fw, h);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (mem == null) {
            mem = new DialogMem(this.gui);
        } else {
            mem.setVisible(true);
        }
        this.repaint();
    }
}

