/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultTreeModel;
import org.basex.data.Data;
import org.basex.gui.layout.BaseXTree;
import org.basex.gui.layout.TreeLeaf;
import org.basex.gui.layout.TreeNode;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.hash.TokenBoolMap;
import org.basex.util.list.TokenList;

public class TreeFolder
extends TreeNode {
    private boolean loaded;
    public static final int MAXC = 10000;

    public TreeFolder(byte[] nm, byte[] pth, BaseXTree t, Data d) {
        super(nm, pth, t, d);
    }

    @Override
    void load() {
        if (this.loaded || this.updating) {
            return;
        }
        this.updating = true;
        int cmax = 10000;
        byte[] sub = this.subfolder();
        TokenBoolMap set = this.data.resources.children(this.subfolder(), true);
        for (byte[] f : new TokenList(set).sort(Prop.CASE)) {
            this.add(new TreeFolder(f, sub, this.tree, this.data));
            if (--cmax != 0) continue;
            break;
        }
        if ((cmax = this.addLeaves(Token.EMPTY, cmax, this)) <= 0) {
            this.add(new TreeLeaf(Token.token("..."), sub, false, true, this.tree, this.data));
        }
        this.loaded = true;
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this);
        this.updating = false;
    }

    public int addLeaves(byte[] filter, int cmax, TreeFolder target) {
        TokenBoolMap tbm = this.data.resources.children(this.subfolder(), false);
        ArrayList<byte[]> keys = new ArrayList<byte[]>(tbm.size());
        for (byte[] b : tbm) {
            if (filter.length != 0 && !Token.eq(b, filter)) continue;
            keys.add(b);
        }
        Collections.sort(keys, new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                return Prop.CASE ? Token.diff(o1, o2) : Token.diff(Token.lc(o1), Token.lc(o2));
            }
        });
        byte[] sub = this.subfolder();
        int i = 0;
        int m = cmax;
        while (i < keys.size() && m-- > 0) {
            byte[] nm = (byte[])keys.get(i++);
            target.add(new TreeLeaf(nm, sub, tbm.get(nm), false, this.tree, this.data));
        }
        return m;
    }

    byte[] subfolder() {
        return this.path.length > 1 ? Token.concat(Token.concat(this.path, Token.SLASH), this.name) : Token.concat(this.path, this.name);
    }

    public static byte[] name(byte[] path) {
        byte[][] s = Token.split(path, 47);
        if (s.length == 0) {
            return Token.EMPTY;
        }
        return s[s.length - 1];
    }

    public static byte[] path(byte[] path) {
        if (path.length == 0) {
            return path;
        }
        byte[] r = Token.substring(path, 0, Token.lastIndexOf(path, 47));
        return r.length == 0 ? Token.SLASH : r;
    }

    public void removeChildren() {
        this.removeAllChildren();
        this.loaded = false;
    }

    public void reload() {
        this.removeChildren();
        this.load();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }
}

