/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.gui.layout.BaseXTree;
import org.basex.util.Token;

public abstract class TreeNode
extends DefaultMutableTreeNode
implements TreeWillExpandListener {
    public final byte[] name;
    final byte[] path;
    final BaseXTree tree;
    final Data data;
    boolean updating;

    TreeNode(byte[] nm, byte[] pth, BaseXTree bxt, Data d) {
        this.name = nm;
        this.path = pth;
        this.tree = bxt;
        this.data = d;
        this.tree.addTreeWillExpandListener(this);
    }

    public static byte[] preparePath(byte[] path) {
        String p = MetaData.normPath(Token.string(path));
        if (p.endsWith("/")) {
            p = p.substring(0, p.length() - 1);
        }
        return Token.concat(Token.SLASH, Token.token(p));
    }

    public String path() {
        return Token.string(TreeNode.preparePath(Token.concat(this.path, Token.SLASH, this.name)));
    }

    abstract void load();

    @Override
    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        if (this.equals(e.getPath().getLastPathComponent())) {
            this.load();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
    }

    @Override
    public String toString() {
        return Token.string(this.name);
    }
}

