/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.text.ReplaceContext;
import org.basex.gui.text.SearchContext;
import org.basex.gui.text.Syntax;
import org.basex.gui.text.TextPanel;
import org.basex.io.MimeTypes;
import org.basex.io.in.NewlineInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.ByteList;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class TextEditor {
    private static final String OPENING = "{([";
    private static final String CLOSING = "})]";
    IntList[] searchPos;
    int start = -1;
    int end = -1;
    int error = -1;
    private final GUIOptions gopts;
    private SearchContext search;
    private byte[] text = Token.EMPTY;
    private int lines = -1;
    private int pos;
    private static final StringList REPLACE;

    TextEditor(GUI gui) {
        this.gopts = gui.gopts;
    }

    boolean text(byte[] txt) {
        if (Token.eq(txt, this.text)) {
            return false;
        }
        this.text = txt;
        this.lines = -1;
        this.noSelect();
        if (this.search != null) {
            this.searchPos = this.search.search(txt);
        }
        return true;
    }

    void search(SearchContext sc) {
        if (sc.equals(this.search)) {
            sc.nr = this.search.nr;
            sc.bar.refresh(sc);
        } else {
            this.searchPos = sc.search(this.text);
            this.search = sc;
        }
    }

    int[] replace(ReplaceContext rc) {
        int ts = this.size();
        int s = Math.min(this.start, this.end);
        int e = Math.max(this.start, this.end);
        boolean sel = this.selected();
        if (sel) {
            int p = s - 1;
            while (++p < e && this.text[p] != 10) {
            }
            boolean bl = sel = p < e;
        }
        if (!sel) {
            s = 0;
            e = ts;
        }
        return rc.replace(this.search, this.text, s, e);
    }

    int lines() {
        if (this.lines == -1) {
            int c = 1;
            for (byte ch : this.text) {
                if (ch != 10) continue;
                ++c;
            }
            this.lines = c;
        }
        return this.lines;
    }

    private void forward(boolean select) {
        if (select || !this.selected()) {
            this.next();
        } else {
            this.pos(Math.max(this.start, this.end));
        }
    }

    void next(boolean select) {
        if (select && !this.selected()) {
            this.startSelect();
        }
        this.forward(select);
        if (select) {
            this.endSelection();
        }
    }

    void previous(boolean select) {
        if (select && !this.selected()) {
            this.startSelect();
        }
        this.back(select);
        if (select) {
            this.endSelection();
        }
    }

    void nextWord(boolean select) {
        if (select && !this.selected()) {
            this.startSelect();
        }
        int ch = this.curr();
        this.forward(select);
        if (ch != 10) {
            if (Character.isLetterOrDigit(ch)) {
                while (Character.isLetterOrDigit(ch)) {
                    ch = this.next();
                }
                while (ch != 10 && Character.isWhitespace(ch)) {
                    ch = this.next();
                }
            } else if (Character.isWhitespace(ch)) {
                while (ch != 10 && Character.isWhitespace(ch)) {
                    ch = this.next();
                }
            } else {
                while (ch != 10 && !Character.isLetterOrDigit(ch) && !Character.isWhitespace(ch)) {
                    ch = this.next();
                }
                while (ch != 10 && Character.isWhitespace(ch)) {
                    ch = this.next();
                }
            }
            if (this.pos != this.size()) {
                this.prev();
            }
        }
        if (select) {
            this.endSelection();
        }
    }

    void prevWord(boolean select) {
        int ch;
        if (select && !this.selected()) {
            this.startSelect();
        }
        if ((ch = this.back(select)) != 10) {
            if (Character.isLetterOrDigit(ch)) {
                while (Character.isLetterOrDigit(ch)) {
                    ch = this.prev();
                }
            } else if (Character.isWhitespace(ch)) {
                while (ch != 10 && Character.isWhitespace(ch)) {
                    ch = this.prev();
                }
                while (Character.isLetterOrDigit(ch)) {
                    ch = this.prev();
                }
            } else {
                while (ch != 10 && !Character.isLetterOrDigit(ch) && !Character.isWhitespace(ch)) {
                    ch = this.prev();
                }
            }
            if (this.pos != 0) {
                this.next();
            }
        }
        if (select) {
            this.endSelection();
        }
    }

    void textStart(boolean select) {
        this.startSelection(select);
        this.pos = 0;
        if (select) {
            this.endSelection();
        }
    }

    void textEnd(boolean select) {
        this.startSelection(select);
        this.pos = this.size();
        if (select) {
            this.endSelection();
        }
    }

    public byte[] text() {
        return this.text;
    }

    private int indent() {
        return Math.max(1, this.gopts.get(GUIOptions.INDENT));
    }

    private byte[] spaces() {
        byte[] spaces;
        if (this.gopts.get(GUIOptions.TABSPACES).booleanValue()) {
            spaces = new byte[this.indent()];
            Arrays.fill(spaces, (byte)32);
        } else {
            spaces = new byte[]{9};
        }
        return spaces;
    }

    private int bol(boolean select) {
        if (this.pos == 0) {
            if (!select) {
                this.noSelect();
            }
            return 0;
        }
        int ind = this.indent();
        int c = 0;
        do {
            c += this.curr() == 9 ? ind : 1;
        } while (this.back(select) != 10);
        if (this.pos != 0 || this.curr() == 10) {
            this.forward(select);
        }
        return c;
    }

    void lineStart(boolean select) {
        if (select && !this.selected()) {
            this.startSelect();
        }
        int p = this.pos;
        boolean s = true;
        while (this.back(select) != 10) {
            s &= Character.isWhitespace(this.curr());
        }
        if (this.pos != 0 || this.curr() == 10) {
            this.forward(select);
        }
        if (p == this.pos || !s) {
            while (Character.isWhitespace(this.curr()) && this.curr() != 10) {
                this.forward(select);
            }
        }
        if (select) {
            this.endSelection();
        }
    }

    void lineEnd(boolean select) {
        this.startSelection(select);
        this.forward(Integer.MAX_VALUE, select);
        if (select) {
            this.endSelection();
        }
    }

    private int back(boolean select) {
        if (select || !this.selected()) {
            return this.prev();
        }
        this.pos(Math.min(this.start, this.end));
        return this.curr();
    }

    private int prev() {
        if (this.pos == 0) {
            return 10;
        }
        while (--this.pos > 0 && this.text[this.pos] < -64 && this.text[this.pos] >= -128) {
        }
        return this.curr();
    }

    private void forward(int p, boolean select) {
        int ind = this.indent();
        int nc = 0;
        while (this.curr() != 10) {
            if ((nc += this.curr() == 9 ? ind : 1) >= p) {
                return;
            }
            this.forward(select);
        }
    }

    int linesUp(int l, boolean select, int lastCol) {
        this.startSelection(select);
        int col = this.bol(select);
        if (this.pos() == 0) {
            col = -1;
        } else {
            if (lastCol != -1) {
                col = lastCol;
            }
            for (int i = 0; i < l; ++i) {
                this.back(select);
                this.bol(select);
            }
            this.forward(col, select);
        }
        if (select) {
            this.endSelection();
        }
        return col;
    }

    int linesDown(int l, boolean select, int lastCol) {
        this.startSelection(select);
        int lc = lastCol == -1 ? this.bol(select) : lastCol;
        for (int i = 0; i < l; ++i) {
            this.forward(Integer.MAX_VALUE, select);
            this.forward(select);
        }
        this.forward(lc, select);
        if (this.pos() == this.size()) {
            lc = -1;
        }
        if (select) {
            this.endSelection();
        }
        return lc;
    }

    void add(String str) {
        int cl = str.length();
        TokenBuilder tb = new TokenBuilder(cl);
        for (int c = 0; c < cl; ++c) {
            int ch = str.charAt(c);
            if (ch == 13 || ch < 32 && !Token.ws(ch)) continue;
            if (Character.isHighSurrogate((char)ch) && c + 1 < cl) {
                ch = Character.toCodePoint((char)ch, str.charAt(++c));
            }
            tb.add(ch);
        }
        this.insert(tb.finish(), this.pos, this.pos);
        this.pos += tb.size();
    }

    boolean comment(Syntax syntax) {
        int off;
        byte[] st = syntax.commentOpen();
        byte[] en = syntax.commentEnd();
        byte[] ste = Token.concat(st, Token.SPACE);
        byte[] ene = Token.concat(Token.SPACE, en);
        int sl = st.length;
        int el = en.length;
        int sle = ste.length;
        int ele = ene.length;
        if (!this.selected()) {
            this.start = this.pos;
            this.end = this.pos;
            while (this.start > 0 && this.text[this.start - 1] != 10) {
                --this.start;
            }
            while (this.end < this.size() && this.text[this.end] != 10) {
                ++this.end;
            }
        }
        int min = Math.min(this.start, this.end);
        int max = Math.max(this.start, this.end);
        if (this.selected() && this.text[max - 1] == 10) {
            --max;
        }
        TokenBuilder tb = new TokenBuilder();
        int mx = Math.max(min + sl, max - el);
        int mxe = Math.max(min + sle, max - ele);
        if (Token.indexOf(this.text, ste, min) == min && Token.indexOf(this.text, ene, mxe) == mxe) {
            tb.add(this.text, min + sle, max - ele);
            off = -sle - ele;
        } else if (Token.indexOf(this.text, st, min) == min && Token.indexOf(this.text, en, mx) == mx) {
            tb.add(this.text, min + sl, max - el);
            off = -sl - el;
        } else {
            tb.add(ste).add(this.text, min, max).add(ene);
            off = sle + ele;
        }
        boolean added = this.insert(tb.finish(), min, max);
        this.select(min, max + off);
        return added;
    }

    private boolean insert(byte[] string, int offset, int rem) {
        int ts = this.size();
        int al = string.length;
        byte[] tmp = new byte[offset + al + ts - rem];
        System.arraycopy(this.text, 0, tmp, 0, offset);
        System.arraycopy(string, 0, tmp, offset, al);
        System.arraycopy(this.text, rem, tmp, offset + al, ts - rem);
        return this.text(tmp);
    }

    void move(boolean down) {
        if (!this.extend()) {
            return;
        }
        int s = this.start;
        int e = this.end;
        int ts = this.size();
        byte[] tmp = Arrays.copyOf(this.text, ts);
        if (down) {
            int i;
            if (e == ts) {
                return;
            }
            this.pos = e;
            this.lineEnd(true);
            int c = s;
            for (i = e; i < this.pos; ++i) {
                tmp[c++] = this.text[i];
            }
            tmp[c++] = 10;
            for (i = s; i < e - 1; ++i) {
                tmp[c++] = this.text[i];
            }
            this.text(tmp);
            this.select(s + this.pos - e + 1, Math.min(ts, this.pos + 1));
        } else {
            int i;
            if (s == 0) {
                return;
            }
            this.pos = s - 1;
            this.bol(true);
            int c = this.pos;
            for (i = s; i < e; ++i) {
                tmp[c++] = this.text[i];
            }
            if (tmp[c - 1] != 10) {
                tmp[c++] = 10;
            }
            for (i = this.pos; i < s && c < ts; ++i) {
                tmp[c++] = this.text[i];
            }
            this.text(tmp);
            this.select(this.pos, this.pos + e - s);
        }
    }

    void complete() {
        Object value;
        String key;
        boolean space;
        if (this.selected()) {
            return;
        }
        boolean bl = space = this.pos > 0 && Token.ws(this.text[this.pos - 1]);
        if (space) {
            --this.pos;
        }
        for (int s = 0; s < REPLACE.size(); s += 2) {
            int ind;
            key = REPLACE.get(s);
            if (!this.find(key)) continue;
            value = REPLACE.get(s + 1);
            int p = this.pos - key.length();
            int car = ((String)value).indexOf(95);
            if (car != -1) {
                value = ((String)value).replace("_", "");
            }
            if ((ind = this.open()) != 0) {
                StringBuilder spaces = new StringBuilder();
                for (int i = 0; i < ind; ++i) {
                    spaces.append(' ');
                }
                value = new TokenBuilder().addSep(((String)value).split("\n"), "\n" + spaces).toString();
            }
            this.replace(p, this.pos + (space ? 1 : 0), (String)value);
            if (car == -1) continue;
            this.pos = p + car;
        }
        int p = this.pos;
        while (--p >= 0 && XMLToken.isChar(this.text[p])) {
        }
        if ((value = (Object)XMLToken.getEntity(Token.token(key = Token.string(this.text, ++p, this.pos - p)))) != null) {
            this.replace(p, this.pos + (space ? 1 : 0), Token.string((byte[])value));
            return;
        }
        if (space) {
            ++this.pos;
        }
    }

    boolean format(Syntax syntax) {
        boolean sel = this.selected();
        int s = sel ? Math.min(this.start, this.end) : 0;
        int e = sel ? Math.max(this.start, this.end) : this.size();
        byte[] format = syntax.format(Arrays.copyOfRange(this.text, s, e), this.spaces());
        boolean changed = this.insert(format, s, e);
        this.select(s, s + format.length);
        return changed;
    }

    boolean sort() {
        int i;
        if (!this.extend()) {
            return false;
        }
        int s = this.start;
        int e = this.end;
        int ts = this.size();
        byte[] tmp = Arrays.copyOf(this.text, ts);
        TokenList tl = new TokenList();
        ByteList bl = new ByteList();
        for (i = s; i < e; ++i) {
            byte ch = tmp[i];
            if (ch == 10) {
                tl.add(bl.toArray());
                bl.reset();
                continue;
            }
            bl.add(ch);
        }
        if (!bl.isEmpty()) {
            tl.add(bl.toArray());
        }
        tl.sort(this.gopts.get(GUIOptions.CASESORT), this.gopts.get(GUIOptions.ASCSORT));
        if (this.gopts.get(GUIOptions.MERGEDUPL).booleanValue()) {
            tl.unique();
        }
        i = s;
        for (byte[] line : tl) {
            int ll = line.length;
            System.arraycopy(line, 0, tmp, i, ll);
            if ((i += ll) >= e) continue;
            tmp[i++] = 10;
        }
        if (i < e) {
            System.arraycopy(tmp, e, tmp, i, ts - e);
        }
        boolean changed = this.text(i == e ? tmp : Arrays.copyOf(tmp, ts - e + i));
        this.select(s, i);
        return changed;
    }

    boolean indent(StringBuilder sb, boolean shift) {
        if (!this.selected() && shift && this.size() != 0) {
            this.selectLine();
        }
        if (this.selected()) {
            this.indent(shift);
            sb.setLength(0);
            return this.selected();
        }
        if (shift) {
            sb.setLength(0);
        } else {
            boolean c = this.pos > 0;
            for (int p = this.pos - 1; p >= 0 && c; --p) {
                byte b = this.text[p];
                if (!Token.ws(b)) {
                    return false;
                }
                if (b == 10) break;
            }
            sb.setLength(0);
            sb.append(Token.string(this.spaces()));
        }
        return false;
    }

    int enter(StringBuilder sb) {
        int p;
        boolean opening = this.pos > 0 && OPENING.indexOf(this.text[this.pos - 1]) != -1;
        boolean closing = this.pos < this.size() && CLOSING.indexOf(this.text[this.pos]) != -1;
        int ind = this.indent();
        int indent = this.open();
        int move = 0;
        if (opening) {
            if (closing) {
                for (p = 0; p < indent + ind; ++p) {
                    sb.append(' ');
                }
                move = indent + ind + 1;
                sb.append('\n');
            } else {
                indent += ind;
            }
        } else if (closing) {
            indent -= ind;
        }
        for (p = 0; p < indent; ++p) {
            sb.append(' ');
        }
        this.add(sb, false);
        return move;
    }

    int add(StringBuilder sb, boolean selected) {
        if (sb.length() == 0) {
            return 0;
        }
        int move = 0;
        if (!selected && this.gopts.get(GUIOptions.AUTO).booleanValue()) {
            char ch = sb.charAt(0);
            byte next = this.pos + 1 < this.size() ? this.text[this.pos + 1] : (byte)0;
            byte curr = this.pos < this.size() ? this.text[this.pos] : (byte)0;
            byte prev = this.pos > 0 ? this.text[this.pos - 1] : (byte)0;
            byte pprv = this.pos > 1 ? this.text[this.pos - 2] : (byte)0;
            int opening = OPENING.indexOf(ch);
            if (opening != -1) {
                if (CLOSING.indexOf(curr) != -1 || curr == 0 || Token.ws(curr) || curr == 60) {
                    sb.append(CLOSING.charAt(opening));
                    move = 1;
                }
            } else if (CLOSING.indexOf(ch) != -1) {
                if (ch == curr) {
                    sb.setLength(0);
                    move = 1;
                }
                this.close();
            } else if (ch == '\"' || ch == '\'') {
                if (ch == curr) {
                    sb.setLength(0);
                } else if (!XMLToken.isNCChar(prev)) {
                    sb.append(ch);
                }
                move = 1;
            } else if (ch == '>') {
                this.closeElem(sb);
                move = 1;
            } else if (ch == ':') {
                if (prev == 40) {
                    sb.append(':');
                    if (curr != 41) {
                        sb.append(')');
                    }
                    move = 1;
                }
            } else if (ch == '~') {
                if (prev == 58 && pprv == 40) {
                    sb.append("\n : \n ");
                    if (curr != 58) {
                        sb.append(':');
                        if (curr != 41) {
                            sb.append(')');
                        }
                    } else if (next != 41) {
                        sb.append(')');
                    }
                    move = 5;
                }
            } else if (ch == '-') {
                if (prev == 45 && pprv == 33 && this.pos > 2 && this.text[this.pos - 3] == 60) {
                    sb.append("  -->\n");
                    move = 2;
                }
            } else if (ch == '?' && prev == 60) {
                sb.append(" ?>\n");
                move = 1;
            }
        }
        this.add(sb.toString());
        return move;
    }

    private void close() {
        byte b;
        int p;
        for (p = this.pos - 1; p >= 0 && (b = this.text[p]) != 10; --p) {
            if (Token.ws(b)) continue;
            return;
        }
        if (++p >= this.pos) {
            return;
        }
        this.start = Math.max(this.pos - this.indent(), p);
        this.end = Math.max(this.pos, p);
        if (this.start != this.end) {
            this.delete();
        }
    }

    private void closeElem(StringBuilder sb) {
        for (int p = this.pos - 1; p >= 0; --p) {
            byte b = this.text[p];
            if (XMLToken.isNCChar(b) || b == 58) continue;
            if (b == 60 && p < this.pos - 1) {
                sb.append("</");
                while (++p < this.pos) {
                    sb.append((char)this.text[p]);
                }
                sb.append('>');
                break;
            }
            return;
        }
    }

    void deletePrev() {
        if (!this.selected()) {
            if (this.pos == 0) {
                return;
            }
            this.startSelect();
            int curr = this.curr();
            int prev = this.prev();
            this.endSelection();
            if (this.gopts.get(GUIOptions.AUTO).booleanValue()) {
                if (curr == prev && (curr == 34 || curr == 39)) {
                    ++this.start;
                } else {
                    int open = OPENING.indexOf(prev);
                    if (open != -1 && CLOSING.indexOf(curr) == open) {
                        ++this.start;
                    }
                }
            }
        }
        this.del();
    }

    void delete() {
        if (!this.selected()) {
            if (this.pos == this.size()) {
                return;
            }
            this.start = this.pos;
            this.end = this.pos + Token.cl(this.text, this.pos);
        }
        this.del();
    }

    private void del() {
        int s = Math.min(this.start, this.end);
        int e = Math.max(this.start, this.end);
        int ts = this.size();
        byte[] tmp = new byte[ts - e + s];
        System.arraycopy(this.text, 0, tmp, 0, s);
        System.arraycopy(this.text, e, tmp, s, ts - e);
        this.text(tmp);
        this.pos = s;
    }

    void deleteLine() {
        this.selectLine();
        this.delete();
    }

    void deleteNext(boolean word) {
        if (!this.selected()) {
            if (this.pos() == this.size()) {
                return;
            }
            this.startSelect();
            if (word) {
                this.nextWord(true);
            } else {
                this.lineEnd(true);
            }
            this.endSelection();
        }
        this.delete();
    }

    void deletePrev(boolean word) {
        if (!this.selected()) {
            if (this.pos() == 0) {
                return;
            }
            this.startSelect();
            if (word) {
                this.prevWord(true);
            } else {
                this.bol(true);
            }
            this.endSelection();
        }
        this.delete();
    }

    private void replace(int s, int e, String value) {
        this.select(s, e);
        this.delete();
        this.add(value);
    }

    private boolean find(String key) {
        byte[] k = Token.token(key);
        int s = this.pos - k.length;
        return s >= 0 && Token.indexOf(this.text, k, s) == s && (s == 0 || !XMLToken.isChar(this.text[s - 1]));
    }

    private boolean extend() {
        int s;
        if (!this.selected()) {
            this.selectLine();
            if (!this.selected()) {
                return false;
            }
        }
        int e = Math.max(this.start, this.end);
        int ts = this.size();
        for (s = Math.min(this.start, this.end); s > 0 && this.text[s - 1] != 10; --s) {
        }
        if (e > 0) {
            while (e < ts && this.text[e - 1] != 10) {
                ++e;
            }
        }
        this.start = s;
        this.end = e;
        return true;
    }

    private void indent(boolean shift) {
        if (!this.extend()) {
            return;
        }
        int s = this.start;
        int e = this.end;
        int ind = this.indent();
        byte[] spaces = this.spaces();
        TokenBuilder tb = new TokenBuilder();
        for (int p = s; p < e; ++p) {
            if (p == 0 || this.text[p - 1] == 10) {
                int c;
                int i = 0;
                do {
                    byte cp;
                    if ((cp = this.text[p]) == 9) {
                        i += ind;
                        continue;
                    }
                    if (cp != 32) break;
                    ++i;
                } while (++p < e);
                i = shift ? Math.max(0, i - ind) : i + ind;
                for (c = 0; c < i / ind; ++c) {
                    tb.add(spaces);
                }
                for (c = 0; c < i % ind; ++c) {
                    tb.add(32);
                }
            }
            if (p >= e) continue;
            tb.addByte(this.text[p]);
        }
        this.insert(tb.finish(), s, e);
        this.select(s, s + tb.size());
    }

    private int open() {
        byte b;
        int ind = this.indent();
        int indent = 0;
        for (int p = this.pos - 1; p >= 0 && (b = this.text[p]) != 10; --p) {
            if (b == 9) {
                indent += ind;
                continue;
            }
            if (b == 32) {
                ++indent;
                continue;
            }
            indent = 0;
        }
        return indent;
    }

    int size() {
        return this.text.length;
    }

    int pos() {
        return this.pos;
    }

    void pos(int p) {
        this.pos = p;
        this.noSelect();
    }

    void noSelect() {
        this.start = -1;
        this.end = -1;
    }

    void select(int p, boolean select) {
        this.pos = p;
        if (select) {
            this.startSelect();
        } else {
            this.end = this.pos;
        }
    }

    void select(int s, int e) {
        this.start = s;
        this.end = e;
        this.pos = e;
        this.checkSelection();
    }

    void startSelection(boolean select) {
        if (select) {
            if (!this.selected()) {
                this.startSelect();
            }
        } else {
            this.noSelect();
        }
    }

    void endSelection() {
        this.end = this.pos;
        this.checkSelection();
    }

    private void checkSelection() {
        if (this.start == this.end) {
            this.noSelect();
        }
    }

    boolean selected() {
        return this.start != this.end;
    }

    String copy() {
        int s;
        TokenBuilder tb = new TokenBuilder();
        int e = this.start < this.end ? this.end : this.start;
        int n = s = this.start < this.end ? this.start : this.end;
        while (s < e) {
            int cp = Token.cp(this.text, s);
            if (cp >= 32 || cp == 10 || cp == 9) {
                tb.add(cp);
            }
            s += Token.cl(this.text, s);
        }
        return tb.toString();
    }

    void selectWord() {
        int cp;
        boolean ch = Token.ftChar(this.curr());
        while (this.pos() > 0) {
            cp = this.back(true);
            if (cp != 10 && ch == Token.ftChar(cp)) continue;
            this.forward(true);
            break;
        }
        this.startSelect();
        while (this.pos() < this.size() && (cp = this.curr()) != 10 && ch == Token.ftChar(cp)) {
            this.forward(true);
        }
        this.endSelection();
    }

    void selectLine() {
        this.bol(false);
        this.startSelect();
        this.forward(Integer.MAX_VALUE, true);
        this.next();
        this.endSelection();
    }

    private int curr() {
        return this.pos < 0 || this.pos >= this.size() ? 10 : Token.cp(this.text, this.pos);
    }

    private int next() {
        int c = this.curr();
        if (this.pos < this.size()) {
            this.pos += Token.cl(this.text, this.pos);
        }
        return c;
    }

    private void startSelect() {
        this.start = this.pos;
        this.end = this.pos;
    }

    void error(int s) {
        this.error = s;
    }

    int jump(TextPanel.SearchDir dir, boolean select) {
        if (this.searchPos[0].isEmpty()) {
            if (select) {
                this.noSelect();
            }
            return -1;
        }
        int s = this.searchPos[0].sortedIndexOf(!select || this.selected() ? this.pos : this.pos - 1);
        switch (dir) {
            case CURRENT: {
                s = s < 0 ? -s - 1 : s;
                break;
            }
            case FORWARD: {
                s = s < 0 ? -s - 1 : s + 1;
                break;
            }
            case BACKWARD: {
                s = s < 0 ? -s - 2 : s - 1;
            }
        }
        int sl = this.searchPos[0].size();
        if (s < 0) {
            s = sl - 1;
        } else if (s == sl) {
            s = 0;
        }
        int p = this.searchPos[0].get(s);
        if (select) {
            this.start = this.searchPos[1].get(s);
            this.end = p;
        }
        this.pos = p;
        return p;
    }

    public String toString() {
        return this.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block7: {
            REPLACE = new StringList();
            try {
                String file = "/completions.properties";
                InputStream is = MimeTypes.class.getResourceAsStream("/completions.properties");
                if (is == null) {
                    Util.errln("/completions.properties not found.", new Object[0]);
                    break block7;
                }
                NewlineInput nli = new NewlineInput(is);
                try {
                    String line;
                    while ((line = nli.readLine()) != null) {
                        int i = line.indexOf(61);
                        if (i == -1 || line.startsWith("#")) continue;
                        REPLACE.add(line.substring(0, i));
                        REPLACE.add(line.substring(i + 1).replace("\\n", "\n"));
                    }
                }
                finally {
                    nli.close();
                }
            }
            catch (IOException ex) {
                Util.errln(ex, new Object[0]);
            }
        }
    }
}

