/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.regex.Pattern;
import org.basex.core.Text;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.view.editor.EditorArea;
import org.basex.gui.view.project.ProjectNode;
import org.basex.gui.view.project.ProjectView;
import org.basex.io.IOFile;
import org.basex.io.in.TextInput;
import org.basex.util.Token;
import org.basex.util.TokenParser;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

final class ProjectFilter
extends BaseXBack {
    private static final int MAXHITS = 256;
    private final BaseXTextField files;
    private final BaseXTextField contents;
    private final ProjectView project;
    private final TokenList cache = new TokenList();
    private String lastFiles = "";
    private String lastContents = "";
    private boolean running;
    private int threadID;

    public ProjectFilter(final ProjectView view) {
        this.project = view;
        this.layout(new BorderLayout(0, 2));
        this.files = new BaseXTextField(view.gui);
        this.files.addFocusListener(this.project.lastfocus);
        this.contents = new BaseXTextField(view.gui);
        this.contents.hint(Text.FIND_CONTENTS + "...");
        this.contents.addFocusListener(this.project.lastfocus);
        this.add((Component)this.files, "North");
        this.add((Component)this.contents, "Center");
        KeyAdapter refreshKeys = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.NEXTLINE.is(e) || BaseXKeys.PREVLINE.is(e) || BaseXKeys.NEXTPAGE.is(e) || BaseXKeys.PREVPAGE.is(e)) {
                    ((ProjectFilter)ProjectFilter.this).project.list.dispatchEvent(e);
                } else {
                    for (GUIPopupCmd cmd : ((ProjectFilter)ProjectFilter.this).project.list.commands) {
                        if (cmd == null) continue;
                        for (BaseXKeys sc : cmd.shortcuts()) {
                            if (!sc.is(e)) continue;
                            cmd.execute(view.gui);
                            e.consume();
                            return;
                        }
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ProjectFilter.this.refresh(false);
            }
        };
        this.files.addKeyListener(refreshKeys);
        this.contents.addKeyListener(refreshKeys);
        this.refreshLayout();
    }

    void reset() {
        this.cache.reset();
        this.refresh(true);
    }

    private void init(int thread) {
        if (this.cache.isEmpty()) {
            TokenSet set = new TokenSet();
            set.add(Text.PLEASE_WAIT_D);
            this.project.list.setElements(set, null);
            this.add(this.project.root.file, thread);
        }
    }

    private void add(IOFile root, int thread) {
        for (IOFile file : root.children()) {
            if (file.isDir()) {
                this.add(file, thread);
            } else {
                this.cache.add(file.path());
            }
            if (this.threadID == thread) continue;
            this.cache.reset();
            return;
        }
    }

    private void filter(String file, String content, int thread) {
        while (this.running) {
            Thread.yield();
            if (this.threadID == thread) continue;
            return;
        }
        this.running = true;
        this.files.setCursor(GUIConstants.CURSORWAIT);
        this.contents.setCursor(GUIConstants.CURSORWAIT);
        this.init(thread);
        TokenSet results = new TokenSet();
        IntList il = new IntList();
        TokenParser tp = new TokenParser(Token.token(content));
        while (tp.more()) {
            il.add(Token.lc(tp.next()));
        }
        if (this.filter(file, il.toArray(), thread, results)) {
            this.project.list.setElements(results, content.isEmpty() ? null : content);
        }
        this.files.setCursor(GUIConstants.CURSORTEXT);
        this.contents.setCursor(GUIConstants.CURSORTEXT);
        this.running = false;
    }

    void refresh(boolean force) {
        boolean list;
        final String file = this.files.getText();
        final String content = this.contents.getText();
        if (!force && this.lastFiles.equals(file) && this.lastContents.equals(content)) {
            return;
        }
        this.lastFiles = file;
        this.lastContents = content;
        ++this.threadID;
        boolean bl = list = !file.isEmpty() || !content.isEmpty();
        if (list) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    ProjectFilter.this.filter(file, content, ProjectFilter.this.threadID);
                }
            };
            t.setDaemon(true);
            t.start();
        }
        this.project.showList(list);
    }

    void find(EditorArea ea) {
        String string = ea.searchString();
        if (string != null) {
            this.contents.requestFocusInWindow();
            this.contents.setText(string);
            if (ea.opened()) {
                String pattern;
                String name = ea.file().name();
                int i = name.lastIndexOf(46);
                String file = this.files.getText();
                String string2 = pattern = file.isEmpty() ? this.project.gui.gopts.get(GUIOptions.FILES) : file;
                if (i != -1 && !pattern.contains("*") && !pattern.contains("?") || !Pattern.compile(IOFile.regex(pattern)).matcher(name).matches()) {
                    this.files.setText('*' + name.substring(i));
                }
            }
            this.refresh(false);
        } else {
            this.files.requestFocusInWindow();
        }
    }

    void find(ProjectNode node) {
        if (node != null) {
            this.files.setText(node.file.path());
        }
        this.refresh(false);
        this.files.requestFocusInWindow();
    }

    public void refreshLayout() {
        String filter = this.project.gui.gopts.get(GUIOptions.FILES).trim();
        this.files.hint(filter.isEmpty() ? Text.FIND_FILES + "..." : filter);
    }

    private boolean filter(String file, int[] search, int thread, TokenSet results) {
        String pattern;
        String string = pattern = file.isEmpty() ? this.project.gui.gopts.get(GUIOptions.FILES) : file;
        if (pattern.contains("*") || pattern.contains("?")) {
            Pattern pt = Pattern.compile(IOFile.regex(pattern));
            for (byte[] input : this.cache) {
                int offset;
                if (pt.matcher(Token.string(Token.substring(input, offset = ProjectFilter.offset(input, true)))).matches() && this.filterContent(input, search, results)) {
                    return true;
                }
                if (thread == this.threadID) continue;
                return false;
            }
        }
        byte[] pttrn = Token.replace(Token.lc(Token.token(pattern)), 92, 47);
        TokenSet exclude = new TokenSet();
        boolean path = Token.indexOf(pttrn, 47) != -1;
        for (int i = 0; i < (path ? 2 : 3); ++i) {
            if (this.filter(pttrn, search, thread, i, results, exclude, path)) continue;
            return false;
        }
        return true;
    }

    private boolean filter(byte[] pattern, int[] search, int thread, int mode, TokenSet results, TokenSet exclude, boolean path) {
        if (results.size() < 256) {
            for (byte[] input : this.cache) {
                byte[] lc = Token.replace(Token.lc(input), 92, 47);
                int offset = ProjectFilter.offset(lc, path);
                if ((mode == 0 ? Token.startsWith(lc, pattern, offset) : (mode == 1 ? Token.contains(lc, pattern, offset) : ProjectFilter.matches(lc, pattern, offset))) && !exclude.contains(input)) {
                    exclude.add(input);
                    if (this.filterContent(input, search, results)) {
                        return true;
                    }
                }
                if (thread == this.threadID) continue;
                return false;
            }
        }
        return true;
    }

    private boolean filterContent(byte[] path, int[] search, TokenSet results) {
        if (ProjectFilter.filterContent(path, search) && !results.contains(path)) {
            results.add(path);
            if (results.size() >= 256) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean filterContent(byte[] path, int[] search) {
        int cl = search.length;
        if (cl == 0) {
            return true;
        }
        try {
            TextInput ti = new TextInput(new IOFile(Token.string(path)));
            try {
                IntList il = new IntList(cl - 1);
                int c = 0;
                while (true) {
                    block13: {
                        if (!il.isEmpty()) {
                            if (il.deleteAt(0) == search[c++]) continue;
                            c = 0;
                        }
                        do {
                            int cp;
                            if ((cp = ti.read()) == -1 || !XMLToken.valid(cp)) {
                                boolean bl = false;
                                return bl;
                            }
                            int lc = Token.lc(cp);
                            if (c > 0) {
                                il.add(lc);
                            }
                            if (lc != search[c]) break block13;
                        } while (++c != cl);
                        boolean bl = true;
                        return bl;
                    }
                    c = 0;
                }
            }
            finally {
                ti.close();
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }

    private static int offset(byte[] input, boolean path) {
        int b;
        if (path) {
            return 0;
        }
        int a = Token.lastIndexOf(input, 92);
        return (a > (b = Token.lastIndexOf(input, 47)) ? a : b) + 1;
    }

    private static boolean matches(byte[] input, byte[] pattern, int off) {
        int il = input.length;
        int pl = pattern.length;
        int p = 0;
        for (int i = off; i < il && p < pl; ++i) {
            if (pattern[p] != input[i]) continue;
            ++p;
        }
        return p == pl;
    }
}

