/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index;

import org.basex.util.Num;
import org.basex.util.Token;
import org.basex.util.hash.TokenIntMap;
import org.basex.util.list.BoolList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public class IndexTree {
    protected static final double FACTOR = 1.2;
    public final TokenList keys = new TokenList(1.2);
    public TokenList values = new TokenList(1.2);
    protected TokenIntMap maps = new TokenIntMap();
    protected int cn;
    private final IntList tree = new IntList(1.2);
    private final BoolList mod = new BoolList();
    private int root = -1;

    public final void index(byte[] key, int value) {
        this.index(key, value, true);
    }

    protected final int index(byte[] key, int value, boolean exist) {
        if (this.root == -1) {
            this.root = this.n(key, value, -1, exist);
            return this.root;
        }
        int n = this.root;
        while (true) {
            int ch;
            int c;
            if ((c = Token.diff(key, this.keys.get(n))) == 0) {
                if (exist) {
                    this.values.set(n, Num.add(this.values.get(n), value));
                } else {
                    int i = this.maps.get(Num.num(n));
                    if (i < 0) {
                        this.maps.put(Num.num(n), this.values.size());
                        this.values.add(Num.newNum(value));
                    } else {
                        this.values.set(i, Num.add(this.values.get(i), value));
                    }
                }
                return n;
            }
            int n2 = ch = c < 0 ? this.l(n) : this.r(n);
            if (ch == -1) {
                ch = this.n(key, value, n, exist);
                if (c < 0) {
                    this.l(n, ch);
                    this.a(this.l(n));
                } else {
                    this.r(n, ch);
                    this.a(this.r(n));
                }
                return ch;
            }
            n = ch;
        }
    }

    public final int size() {
        return this.values.size();
    }

    public final void init() {
        this.cn = this.root;
        if (this.cn != -1) {
            while (this.l(this.cn) != -1) {
                this.cn = this.l(this.cn);
            }
        }
    }

    public final boolean more() {
        return this.cn != -1;
    }

    public final int next() {
        int ln = this.cn;
        if (this.r(this.cn) == -1) {
            int t = this.cn;
            this.cn = this.p(this.cn);
            while (this.cn != -1 && t == this.r(this.cn)) {
                t = this.cn;
                this.cn = this.p(this.cn);
            }
        } else {
            this.cn = this.r(this.cn);
            while (this.l(this.cn) != -1) {
                this.cn = this.l(this.cn);
            }
        }
        return ln;
    }

    private int n(byte[] key, int value, int par, boolean exist) {
        this.tree.add(-1);
        this.tree.add(-1);
        this.tree.add(par);
        this.mod.add(false);
        this.keys.add(key);
        this.values.add(Num.newNum(value));
        if (!exist) {
            this.maps.put(Num.num(this.keys.size() - 1), this.values.size() - 1);
        }
        return this.mod.size() - 1;
    }

    private int l(int nd) {
        return this.tree.get((nd << 1) + nd);
    }

    private int r(int nd) {
        return this.tree.get((nd << 1) + nd + 1);
    }

    private int p(int nd) {
        return this.tree.get((nd << 1) + nd + 2);
    }

    private void l(int nd, int val) {
        this.tree.set((nd << 1) + nd, val);
    }

    private void r(int nd, int val) {
        this.tree.set((nd << 1) + nd + 1, val);
    }

    private void p(int nd, int val) {
        this.tree.set((nd << 1) + nd + 2, val);
    }

    private void a(int nd) {
        int n = nd;
        this.mod.set(n, true);
        while (n != -1 && n != this.root && this.mod.get(this.p(n))) {
            int y;
            if (this.p(n) == this.l(this.p(this.p(n)))) {
                y = this.r(this.p(this.p(n)));
                if (y != -1 && this.mod.get(y)) {
                    this.mod.set(this.p(n), false);
                    this.mod.set(y, false);
                    this.mod.set(this.p(this.p(n)), true);
                    n = this.p(this.p(n));
                    continue;
                }
                if (n == this.r(this.p(n))) {
                    n = this.p(n);
                    this.rl(n);
                }
                this.mod.set(this.p(n), false);
                this.mod.set(this.p(this.p(n)), true);
                if (this.p(this.p(n)) == -1) continue;
                this.rr(this.p(this.p(n)));
                continue;
            }
            y = this.l(this.p(this.p(n)));
            if (y != -1 && this.mod.get(y)) {
                this.mod.set(this.p(n), false);
                this.mod.set(y, false);
                this.mod.set(this.p(this.p(n)), true);
                n = this.p(this.p(n));
                continue;
            }
            if (n == this.l(this.p(n))) {
                n = this.p(n);
                this.rr(n);
            }
            this.mod.set(this.p(n), false);
            this.mod.set(this.p(this.p(n)), true);
            if (this.p(this.p(n)) == -1) continue;
            this.rl(this.p(this.p(n)));
        }
        this.mod.set(this.root, false);
    }

    private void rl(int n) {
        int r = this.r(n);
        this.r(n, this.l(r));
        if (this.l(r) != -1) {
            this.p(this.l(r), n);
        }
        this.p(r, this.p(n));
        if (this.p(n) == -1) {
            this.root = r;
        } else if (this.l(this.p(n)) == n) {
            this.l(this.p(n), r);
        } else {
            this.r(this.p(n), r);
        }
        this.l(r, n);
        this.p(n, r);
    }

    private void rr(int n) {
        int l = this.l(n);
        this.l(n, this.r(l));
        if (this.r(l) != -1) {
            this.p(this.r(l), n);
        }
        this.p(l, this.p(n));
        if (this.p(n) == -1) {
            this.root = l;
        } else if (this.r(this.p(n)) == n) {
            this.r(this.p(n), l);
        } else {
            this.l(this.p(n), l);
        }
        this.r(l, n);
        this.p(n, l);
    }
}

